/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.common.block;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import salted.packedup.common.block.handlers.ShapeHandler;

public class CrateLidBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final ImmutableMap<BlockState, VoxelShape> SHAPES;
    private static final Direction defaultFacing = Direction.NORTH;
    private final VoxelShape BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private final VoxelShape[] TOP1 = ShapeHandler.getRotated(ShapeHandler.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)8.0), defaultFacing));
    private final VoxelShape[] TOP2 = ShapeHandler.getRotated(ShapeHandler.rotate(Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)6.0, (double)7.0), defaultFacing));
    private final VoxelShape[] TOP3 = ShapeHandler.getRotated(ShapeHandler.rotate(Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)9.0, (double)6.0), defaultFacing));
    private final VoxelShape[] TOP4 = ShapeHandler.getRotated(ShapeHandler.rotate(Block.m_49796_((double)0.0, (double)9.0, (double)1.0, (double)16.0, (double)12.0, (double)5.0), defaultFacing));
    private final VoxelShape[] TOP5 = ShapeHandler.getRotated(ShapeHandler.rotate(Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), defaultFacing));

    private ImmutableBiMap<BlockState, VoxelShape> shapeConstructor(ImmutableList<BlockState> states) {
        ImmutableBiMap.Builder shape = new ImmutableBiMap.Builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Half half = (Half)state.m_61143_(HALF);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            if (half == Half.TOP) {
                shapes.add(this.TOP1[facing.m_122416_()]);
                shapes.add(this.TOP2[facing.m_122416_()]);
                shapes.add(this.TOP3[facing.m_122416_()]);
                shapes.add(this.TOP4[facing.m_122416_()]);
                shapes.add(this.TOP5[facing.m_122416_()]);
            } else {
                shapes.add(this.BOTTOM);
            }
            shape.put((Object)state, (Object)ShapeHandler.combineAll(shapes));
        }
        return shape.build();
    }

    public CrateLidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)defaultFacing)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.shapeConstructor((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Half half = (Half)state.m_61143_(HALF);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = world.m_8055_(blockpos);
        boolean bottomSupport = CrateLidBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
        if (half.equals((Object)Half.TOP)) {
            return bottomSupport && blockstate.m_60783_((BlockGetter)world, blockpos, direction);
        }
        return bottomSupport;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos blockPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, blockPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        Direction facing = ctx.m_8125_().m_122424_();
        FluidState fluid = ctx.m_43725_().m_6425_(pos);
        boolean flag = fluid.m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5) ? state : (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)Half.TOP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HALF, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

