/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.common.block;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import salted.packedup.common.block.state.PUProperties;

public class QuarterSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_HEIGHT = 4;
    public static final int HEIGHT_PASSABLE = 2;
    public static final IntegerProperty LAYERS = PUProperties.QUARTER_LAYERS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public QuarterSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS) - 1];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, world, pos, ctx);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        if (Objects.requireNonNull(type) == PathComputationType.LAND) {
            return (Integer)state.m_61143_((Property)LAYERS) <= 2;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean flag;
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        BlockState blockstate = ctx.m_43725_().m_8055_(pos);
        FluidState fluid = level.m_6425_(pos);
        boolean bl = flag = fluid.m_76152_() == Fluids.f_76193_;
        if (blockstate.m_60713_((Block)this)) {
            int layer = (Integer)blockstate.m_61143_((Property)LAYERS);
            if (layer == 3) {
                return (BlockState)((BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(4))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return (BlockState)((BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layer + 1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        int layer = (Integer)state.m_61143_((Property)LAYERS);
        if (ctx.m_43722_().m_150930_(this.m_5456_()) && layer < 4) {
            if (ctx.m_7058_()) {
                return ctx.m_43719_() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Integer)state.m_61143_((Property)LAYERS) != 4 ? super.m_6044_(level, pos, state, fluid) : false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public IntegerProperty getQuarterLayers() {
        return PUProperties.QUARTER_LAYERS;
    }
}

