/*
 * Decompiled with CFR 0.152.
 */
package io.github.friedkeenan.fried_hud.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.friedkeenan.fried_hud.FriedHUDMod;
import io.github.friedkeenan.fried_hud.HUDManager;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1316;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_434;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_491;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class CustomizeHUD
implements HUDManager {
    private static final int VERTICAL_SPEED = 2;
    private static final float FADE_OUT_TIME = 10.0f;
    private static final int HOTBAR_HEIGHT = 23;
    private static final int HOTBAR_SHOW_TIME = 30;
    private static final int FOOD_LEVEL_DAMAGED_WARN = 17;
    private static final int FOOD_LEVEL_UNDAMAGED_WARN = 10;
    private static final int HEALTH_SCREEN_SHOW_TIME = 30;
    private static final int HEALTH_CONSUMING_SHOW_TIME = 40;
    private static final int HEALTH_HUNGER_SHOW_TIME = 50;
    private static final int HEALTH_LOSE_FOOD_SHOW_TIME = 50;
    private static final int HEALTH_FREEZING_SHOW_TIME = 40;
    private static final int HEALTH_DAMAGE_SHOW_TIME = 40;
    private static final int HEALTH_REGEN_SHOW_TIME = 50;
    private static final int HEALTH_AIR_SHOW_TIME = 40;
    private static final int VEHICLE_HEALTH_SCREEN_SHOW_TIME = 30;
    private static final int VEHICLE_HEALTH_START_RIDING_SHOW_TIME = 50;
    private static final int HEALTH_X = 1;
    private static final int HEALTH_Y = 1;
    private static final int FOOD_SIZE = 9;
    private static final int HEART_SIZE = 9;
    private static final int AIR_SIZE = 9;
    private static final int SPRITES_PER_ROW = 10;
    private static final int JUMP_METER_SHOW_TIME = 30;
    @Shadow
    private int field_2042;
    @Shadow
    @Final
    private class_5819 field_2034;
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    @Final
    private class_340 field_2026;
    private int hotbar_show_time = 0;
    private int prev_selected = -1;
    private int health_show_time = 0;
    private int last_food_level = 0;
    private int last_total_health = 0;
    private int vehicle_health_show_time = 0;
    @Nullable
    private class_1309 last_vehicle = null;
    private int jump_meter_show_time = 0;
    private boolean forcing_health_render = false;

    @WrapWithCondition(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderArmor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIII)V")}, method={"renderPlayerHealth"})
    private boolean removeArmorStatRendering(class_332 graphics, class_1657 player, int i, int j, int k, int l) {
        return false;
    }

    @Shadow
    @Nullable
    private class_1657 method_1737() {
        throw new AssertionError();
    }

    private void showHotbarFor(int time) {
        this.hotbar_show_time = Math.max(this.hotbar_show_time, this.field_2042 + time);
    }

    private void showHealthFor(int time) {
        this.health_show_time = Math.max(this.health_show_time, this.field_2042 + time);
    }

    private void showVehicleHealthFor(int time) {
        this.vehicle_health_show_time = Math.max(this.vehicle_health_show_time, this.field_2042 + time);
    }

    private void showJumpMeterForTime(int time) {
        this.jump_meter_show_time = Math.max(this.jump_meter_show_time, this.field_2042 + time);
    }

    @Override
    public void showHealthAndHotbarFor(int time) {
        this.showHotbarFor(time);
        this.showHealthFor(time);
        this.showVehicleHealthFor(time);
    }

    private boolean shouldCurrentScreenShowElements() {
        return this.field_2035.field_1755 instanceof class_490 || this.field_2035.field_1755 instanceof class_491 || this.field_2035.field_1755 instanceof class_481;
    }

    private boolean shouldCurrentScreenShowHotbar() {
        return this.field_2035.field_1755 instanceof class_465 || this.shouldCurrentScreenShowElements();
    }

    private int heightOffsetForTime(int time) {
        return Math.max(0, 2 * (this.field_2042 - time));
    }

    private float alphaForTime(int time) {
        int difference = time - this.field_2042;
        if (difference >= 0) {
            return 1.0f;
        }
        return 1.0f - class_3532.method_15363((float)((float)(-difference) / 10.0f), (float)0.0f, (float)1.0f);
    }

    @WrapWithCondition(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;F)V")}, method={"renderHotbarAndDecorations"})
    private boolean disableHotbarRendering(class_329 gui, class_332 graphics, float delta) {
        class_1657 player = this.method_1737();
        if (player == null) {
            return false;
        }
        if (this.shouldCurrentScreenShowHotbar()) {
            this.showHotbarFor(30);
            return true;
        }
        if (this.prev_selected < 0) {
            this.prev_selected = player.method_31548().field_7545;
        }
        if (player.method_31548().field_7545 != this.prev_selected) {
            this.prev_selected = player.method_31548().field_7545;
            this.showHotbarFor(30);
            return true;
        }
        return this.heightOffsetForTime(this.hotbar_show_time) < 23;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderItemHotbar"})
    private void moveHotbar(class_332 graphics, float delta, CallbackInfo info) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, (float)this.heightOffsetForTime(this.hotbar_show_time), 0.0f);
    }

    @Inject(at={@At(value="RETURN")}, method={"renderItemHotbar"})
    private void cleanupMoveHotbar(class_332 graphics, float delta, CallbackInfo info) {
        graphics.method_51448().method_22909();
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"isExperienceBarVisible"})
    private boolean removeExperienceBar(boolean original) {
        return false;
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getPlayerVehicleWithHealth()Lnet/minecraft/world/entity/LivingEntity;")}, method={"renderPlayerHealth"})
    @Nullable
    private class_1309 alwaysAttemptRenderFood(class_1309 original) {
        return null;
    }

    @Shadow
    private void method_1760(class_332 graphics) {
        throw new AssertionError();
    }

    @Shadow
    private void method_1741(class_332 graphics) {
        throw new AssertionError();
    }

    @Override
    public void forceRenderHealth(class_332 graphics) {
        this.forcing_health_render = true;
        try {
            if (this.field_2035.field_1761.method_2908()) {
                this.method_1760(graphics);
            }
            this.method_1741(graphics);
        }
        finally {
            this.forcing_health_render = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderPlayerHealth"}, cancellable=true)
    private void updateHealthVisible(class_332 graphics, CallbackInfo info) {
        boolean would_lose_breath;
        boolean consuming_item;
        class_1657 player;
        if (this.shouldCurrentScreenShowElements()) {
            this.showHealthFor(30);
            if (!this.forcing_health_render) {
                info.cancel();
                return;
            }
        }
        if ((player = this.method_1737()) == null) {
            return;
        }
        if (player.method_32312() > 0) {
            this.showHealthFor(40);
        }
        boolean bl = consuming_item = player.method_6115() && (player.method_6030().method_7976() == class_1839.field_8950 || player.method_6030().method_7976() == class_1839.field_8946);
        if (consuming_item) {
            this.showHealthFor(40);
        }
        if (player.method_6059(class_1294.field_5903)) {
            this.showHealthFor(50);
        }
        int food_level = player.method_7344().method_7586();
        int health = class_3532.method_15386((float)player.method_6032());
        int total_health = health + class_3532.method_15386((float)player.method_6067());
        if (this.field_2035.field_1755 instanceof class_434) {
            this.last_food_level = food_level;
            this.last_total_health = total_health;
        }
        if (food_level < this.last_food_level && (food_level <= 10 || (float)health < player.method_6063() && food_level <= 17)) {
            this.showHealthFor(50);
        }
        this.last_food_level = food_level;
        if (this.last_total_health <= 0) {
            this.last_total_health = total_health;
        }
        if (total_health < this.last_total_health) {
            this.showHealthFor(40);
        } else if (total_health > this.last_total_health) {
            this.showHealthFor(50);
        }
        this.last_total_health = total_health;
        boolean bl2 = would_lose_breath = player.method_5777(class_3486.field_15517) && !player.method_37908().method_8320(class_2338.method_49637((double)player.method_23317(), (double)player.method_23320(), (double)player.method_23321())).method_27852(class_2246.field_10422);
        if (would_lose_breath) {
            boolean can_breathe_underwater;
            boolean bl3 = can_breathe_underwater = player.method_6094() || class_1292.method_5574((class_1309)player) || player.method_31549().field_7480;
            if (!can_breathe_underwater) {
                this.showHealthFor(40);
            }
        } else if (player.method_5669() < player.method_5748()) {
            this.showHealthFor(40);
        }
    }

    private int getFoodY() {
        return 1 - this.heightOffsetForTime(this.health_show_time);
    }

    private void invertedRenderFood(class_332 graphics, class_1657 player, int x, int y) {
        class_1702 food_data = player.method_7344();
        int food_level = food_data.method_7586();
        RenderSystem.enableBlend();
        for (int i = 0; i < 10; ++i) {
            class_2960 empty_food;
            class_2960 half_food;
            class_2960 full_food;
            int real_y = y;
            if (food_data.method_7589() <= 0.0f && this.field_2042 % (3 * food_level + 1) == 0) {
                real_y += this.field_2034.method_43048(3) - 1;
            }
            if (player.method_6059(class_1294.field_5903)) {
                full_food = FriedHUDMod.FOOD_FULL_HUNGER_SPRITE;
                half_food = FriedHUDMod.FOOD_HALF_HUNGER_SPRITE;
                empty_food = FriedHUDMod.FOOD_EMPTY_HUNGER_SPRITE;
            } else {
                full_food = FriedHUDMod.FOOD_FULL_SPRITE;
                half_food = FriedHUDMod.FOOD_HALF_SPRITE;
                empty_food = FriedHUDMod.FOOD_EMPTY_SPRITE;
            }
            int real_x = x + i * 8;
            graphics.method_52706(empty_food, real_x, real_y, 9, 9);
            int half_drawn_food_level = i * 2 + 1;
            if (half_drawn_food_level == food_level) {
                graphics.method_52706(half_food, real_x, real_y, 9, 9);
                continue;
            }
            if (half_drawn_food_level >= food_level) continue;
            graphics.method_52706(full_food, real_x, real_y, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderFood(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;II)V")}, method={"renderPlayerHealth"})
    private void moveFood(class_329 gui, class_332 graphics, class_1657 player, int y, int x, Operation<Void> original) {
        int food_y = this.getFoodY();
        if (food_y + 9 < 0) {
            return;
        }
        this.invertedRenderFood(graphics, player, 1, food_y);
    }

    private int getHeartsY(float max_health, int absorption_health, int vertical_spacing) {
        int additional_rows = (class_3532.method_15384((double)((double)max_health / 2.0)) + class_3532.method_15384((double)((double)absorption_health / 2.0)) - 1) / 10;
        return this.getFoodY() + 9 + 1 + additional_rows * vertical_spacing;
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderHearts(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/entity/player/Player;IIIIFIIIZ)V")}, method={"renderPlayerHealth"})
    private void moveHearts(class_329 gui, class_332 graphics, class_1657 player, int x, int y, int vertical_spacing, int bump_index, float max_health, int health, int display_health, int absorption_health, boolean blinking, Operation<Void> original) {
        int hearts_y = this.getHeartsY(max_health, absorption_health, vertical_spacing);
        if (hearts_y + 9 < 0) {
            return;
        }
        original.call(new Object[]{gui, graphics, player, 1, hearts_y, vertical_spacing, bump_index, Float.valueOf(max_health), health, display_health, absorption_health, blinking});
    }

    private int getAirY(float max_health, int absorption_health, int vertical_spacing) {
        return this.getHeartsY(max_health, absorption_health, vertical_spacing) + 9 + 1;
    }

    private void invertedRenderAir(class_332 graphics, int x, int y, int displayed_air, int max_air) {
        int intact_bubbles = class_3532.method_15384((double)(10.0 * (double)(displayed_air - 2) / (double)max_air));
        int popped_bubbles = class_3532.method_15384((double)(10.0 * (double)displayed_air / (double)max_air)) - intact_bubbles;
        RenderSystem.enableBlend();
        for (int i = 0; i < intact_bubbles + popped_bubbles; ++i) {
            int real_x = x + i * 8;
            if (i < intact_bubbles) {
                graphics.method_52706(FriedHUDMod.AIR_SPRITE, real_x, y, 9, 9);
                continue;
            }
            graphics.method_52706(FriedHUDMod.AIR_BURSTING_SPRITE, real_x, y, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getMaxAirSupply()I")}, method={"renderPlayerHealth"}, cancellable=true)
    private void moveAirBubbles(class_332 graphics, CallbackInfo info, @Local float max_health, @Local(ordinal=5) int absorption_health, @Local(ordinal=7) int vertical_spacing) {
        int air_y = this.getAirY(max_health, absorption_health, vertical_spacing);
        if (air_y + 9 >= 0) {
            class_1657 player = this.method_1737();
            int max_air = player.method_5748();
            int displayed_air = Math.min(player.method_5669(), max_air);
            if (player.method_5777(class_3486.field_15517) || displayed_air < max_air) {
                this.invertedRenderAir(graphics, 1, air_y, displayed_air, max_air);
            }
        }
        this.field_2035.method_16011().method_15407();
        info.cancel();
    }

    private int getVehicleHeartsY(class_332 graphics) {
        return graphics.method_51443() - 9 - 1 + this.heightOffsetForTime(this.vehicle_health_show_time);
    }

    @Shadow
    @Nullable
    private class_1309 method_1734() {
        throw new AssertionError();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderVehicleHealth"}, cancellable=true)
    private void updateVehicleHealthVisible(class_332 graphics, CallbackInfo info) {
        if (this.shouldCurrentScreenShowElements()) {
            this.showVehicleHealthFor(30);
            if (!this.forcing_health_render) {
                info.cancel();
                return;
            }
        }
        class_1309 vehicle = this.method_1734();
        if (this.field_2035.field_1755 instanceof class_434) {
            this.last_vehicle = vehicle;
        }
        if (vehicle != this.last_vehicle && vehicle != null) {
            this.showVehicleHealthFor(50);
        }
        this.last_vehicle = vehicle;
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;enableBlend()V")}, method={"renderVehicleHealth"}, cancellable=true)
    private void adjustVehicleHealth(class_332 graphics, CallbackInfo info, @Local(ordinal=0) int max_hearts, @Local(ordinal=3) LocalIntRef x, @Local(ordinal=4) LocalIntRef y) {
        int rows;
        int hearts_y = this.getVehicleHeartsY(graphics);
        if (hearts_y - 10 * ((rows = class_3532.method_15384((double)((double)max_hearts / 10.0))) - 1) > graphics.method_51443()) {
            info.cancel();
        }
        x.set(graphics.method_51421() - 1);
        y.set(hearts_y);
    }

    private boolean shouldShowDebugCrosshair() {
        return this.field_2026.method_53536() && !this.field_2035.field_1724.method_7302() && (Boolean)this.field_2035.field_1690.method_42442().method_41753() == false;
    }

    private static boolean ShouldShowCrossHairForAnim(class_1839 anim) {
        return anim != class_1839.field_8952 && anim != class_1839.field_8950 && anim != class_1839.field_8946 && anim != class_1839.field_8947 && anim != class_1839.field_27079 && anim != class_1839.field_39058 && anim != class_1839.field_42717;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderCrosshair"}, cancellable=true)
    private void removeCrosshair(class_332 graphics, float delta, CallbackInfo info) {
        if (this.shouldShowDebugCrosshair()) {
            return;
        }
        if (this.field_2035.field_1765 != null && this.field_2035.field_1765.method_17783() != class_239.class_240.field_1333) {
            return;
        }
        class_1657 player = this.method_1737();
        if (player == null) {
            return;
        }
        if (player.method_6115() && CustomizeHUD.ShouldShowCrossHairForAnim(player.method_6030().method_7976())) {
            return;
        }
        if (player.method_24520(item -> item.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)item))) {
            return;
        }
        info.cancel();
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;enableBlend()V", shift=At.Shift.AFTER)}, method={"renderJumpMeter"})
    private void setJumpMeterAlpha(class_1316 vehicle, class_332 graphics, int x, CallbackInfo info) {
        if (this.field_2035.field_1724.method_3151() > 0.0f) {
            this.showJumpMeterForTime(30);
        }
        if (vehicle.method_45327() > 0) {
            this.showJumpMeterForTime(30);
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.alphaForTime(this.jump_meter_show_time));
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableBlend()V", shift=At.Shift.BEFORE)}, method={"renderJumpMeter"})
    private void unsetJumpMeterAlpha(class_1316 vehicle, class_332 graphics, int x, CallbackInfo info) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

