/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.more_potion_types;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fiveavian.more_potion_types.MPTConfig;
import fiveavian.more_potion_types.item.MPTPotionItem;
import fiveavian.more_potion_types.item.PotionContainerItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;

public class MorePotionTypes
implements ModInitializer {
    public static final String MOD_ID = "more_potion_types";
    public static final ILogger LOGGER = MixinService.getService().getLogger("more_potion_types");
    public static final File CONFIG_FILE = new File("config/more_potion_types.json");
    public static MPTConfig config = new MPTConfig(new MPTConfig.PotionConfig(true, 0.75f, true), new MPTConfig.PotionConfig(true, 1.5f, false));
    public static PotionContainerItem glassVial = null;
    public static MPTPotionItem smallPotion = null;
    public static PotionContainerItem glassJar = null;
    public static MPTPotionItem bigPotion = null;

    public void onInitialize() {
        try {
            this.loadConfig();
            this.registerContent();
            LOGGER.info("Initialized more_potion_types", new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.fatal("Failed to initialize more_potion_types", (Throwable)ex);
        }
    }

    private void loadConfig() throws IOException {
        block21: {
            Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
            CONFIG_FILE.getParentFile().mkdirs();
            if (CONFIG_FILE.createNewFile()) {
                LOGGER.info("Creating new config file", new Object[0]);
                try (FileOutputStream stream = new FileOutputStream(CONFIG_FILE);
                     OutputStreamWriter writer = new OutputStreamWriter(stream);){
                    gson.toJson((Object)config, (Appendable)writer);
                    break block21;
                }
            }
            LOGGER.info("Loading existing config file", new Object[0]);
            try (FileInputStream stream = new FileInputStream(CONFIG_FILE);
                 InputStreamReader reader = new InputStreamReader(stream);){
                config = (MPTConfig)gson.fromJson((Reader)reader, MPTConfig.class);
            }
        }
    }

    private void registerContent() {
        if (MorePotionTypes.config.smallPotion.isEnabled) {
            glassVial = this.registerItem("glass_vial", new PotionContainerItem(new class_1792.class_1793().method_7889(64)));
            smallPotion = this.registerItem("small_potion", new MPTPotionItem(new class_1792.class_1793().method_7889(1)));
            MorePotionTypes.glassVial.potionItem = smallPotion;
            MorePotionTypes.smallPotion.containerItem = glassVial;
            MorePotionTypes.smallPotion.durationMultiplier = MorePotionTypes.config.smallPotion.durationMultiplier;
            MorePotionTypes.smallPotion.shatterAfterUsage = MorePotionTypes.config.smallPotion.shatterAfterUsage;
            class_1845.method_8080((class_1792)smallPotion);
            this.addItemToItemGroup((class_5321<class_1761>)class_7706.field_41062, glassVial);
            this.addPotionItemToItemGroup((class_5321<class_1761>)class_7706.field_41061, (class_1792)smallPotion);
            ColorProviderRegistry.ITEM.register(this::getPotionColor, (Object[])new class_1935[]{smallPotion});
            class_5620.field_27776.put(smallPotion, this.createContainerEmptyingBehavior(glassVial, (class_1792)smallPotion));
            class_5620.field_27775.put(smallPotion, this.createContainerEmptyingBehavior(glassVial, (class_1792)smallPotion));
            class_5620.field_27776.put(glassVial, this.createContainerFillingBehavior(glassVial, (class_1792)smallPotion));
        }
        if (MorePotionTypes.config.bigPotion.isEnabled) {
            glassJar = this.registerItem("glass_jar", new PotionContainerItem(new class_1792.class_1793().method_7889(64)));
            bigPotion = this.registerItem("big_potion", new MPTPotionItem(new class_1792.class_1793().method_7889(1)));
            MorePotionTypes.glassJar.potionItem = bigPotion;
            MorePotionTypes.bigPotion.containerItem = glassJar;
            MorePotionTypes.bigPotion.durationMultiplier = MorePotionTypes.config.bigPotion.durationMultiplier;
            MorePotionTypes.bigPotion.shatterAfterUsage = MorePotionTypes.config.bigPotion.shatterAfterUsage;
            class_1845.method_8080((class_1792)bigPotion);
            this.addItemToItemGroup((class_5321<class_1761>)class_7706.field_41062, glassJar);
            this.addPotionItemToItemGroup((class_5321<class_1761>)class_7706.field_41061, (class_1792)bigPotion);
            ColorProviderRegistry.ITEM.register(this::getPotionColor, (Object[])new class_1935[]{bigPotion});
            class_5620.field_27776.put(bigPotion, this.createContainerEmptyingBehavior(glassJar, (class_1792)bigPotion));
            class_5620.field_27775.put(bigPotion, this.createContainerEmptyingBehavior(glassJar, (class_1792)bigPotion));
            class_5620.field_27776.put(glassJar, this.createContainerFillingBehavior(glassJar, (class_1792)bigPotion));
        }
    }

    private <T extends class_1792> T registerItem(String path, T item) {
        return (T)((class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, path), item));
    }

    private void addItemToItemGroup(class_5321<class_1761> itemGroup, class_1792 item) {
        ItemGroupEvents.modifyEntriesEvent(itemGroup).register(entries -> entries.method_45421((class_1935)item));
    }

    private void addPotionItemToItemGroup(class_5321<class_1761> itemGroup, class_1792 item) {
        ItemGroupEvents.modifyEntriesEvent(itemGroup).register(entries -> class_7923.field_41179.method_46771().method_42017().filter(e -> !e.method_40225(class_1847.field_42473)).map(e -> class_1844.method_8061((class_1799)new class_1799((class_1935)item), (class_1842)((class_1842)e.comp_349()))).forEach(arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0)));
    }

    private class_5620 createContainerFillingBehavior(class_1792 container, class_1792 potion) {
        return (state, world, pos, player, hand, stack) -> {
            if (world.field_9236) {
                return class_1269.field_21466;
            }
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1844.method_8061((class_1799)potion.method_7854(), (class_1842)class_1847.field_8991)));
            class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, class_5712.field_28167, pos);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
            world.method_20290(1047, pos, 0);
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)container));
            return class_1269.field_5812;
        };
    }

    private class_5620 createContainerEmptyingBehavior(class_1792 container, class_1792 potion) {
        return (state, world, pos, player, hand, stack) -> {
            Integer level = state.method_28500((class_2769)class_5556.field_27206).orElse(0);
            if (level == 3 || class_1844.method_8063((class_1799)stack) != class_1847.field_8991) {
                return class_1269.field_5811;
            }
            if (world.field_9236) {
                return class_1269.field_21466;
            }
            if (level == 0) {
                world.method_8501(pos, class_2246.field_27097.method_9564());
            } else {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level + 1)));
            }
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)container.method_7854()));
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, class_5712.field_28166, pos);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
            world.method_20290(1047, pos, 0);
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)potion));
            return class_1269.field_5812;
        };
    }

    private int getPotionColor(class_1799 stack, int tintIndex) {
        return tintIndex > 0 ? -1 : class_1844.method_8064((class_1799)stack);
    }
}

