/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.core.modular;

import com.xiaoyue.celestial_artifacts.CelestialArtifacts;
import com.xiaoyue.celestial_artifacts.content.core.feature.FeatureMap;
import com.xiaoyue.celestial_artifacts.content.core.feature.FeatureType;
import com.xiaoyue.celestial_artifacts.content.core.feature.IFeature;
import com.xiaoyue.celestial_artifacts.content.core.modular.IFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.ModularCurio;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityNetworkHandler;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@SerialClass
public class CurioCacheCap
extends PlayerCapabilityTemplate<CurioCacheCap> {
    public static final Capability<CurioCacheCap> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CurioCacheCap>(){});
    public static final PlayerCapabilityHolder<CurioCacheCap> HOLDER = new PlayerCapabilityHolder(CelestialArtifacts.loc("curios_cache"), CAPABILITY, CurioCacheCap.class, CurioCacheCap::new, PlayerCapabilityNetworkHandler::new);
    private final Map<Item, ItemStack> map = new HashMap<Item, ItemStack>();
    private final FeatureMap features = new FeatureMap();
    private long lastTime = -1L;

    private void refresh() {
        if (this.player.m_9236_().m_46467_() != this.lastTime) {
            this.lastTime = this.player.m_9236_().m_46467_();
            this.map.clear();
            this.features.clear();
            LazyOptional opt = CuriosApi.getCuriosInventory((LivingEntity)this.player);
            if (opt.resolve().isPresent()) {
                for (ICurioStacksHandler e : ((ICuriosItemHandler)opt.resolve().get()).getCurios().values()) {
                    for (int i = 0; i < e.getStacks().getSlots(); ++i) {
                        ItemStack stack = e.getStacks().getStackInSlot(i);
                        this.map.put(stack.m_41720_(), stack);
                        Item item = stack.m_41720_();
                        if (!(item instanceof ModularCurio)) continue;
                        ModularCurio modular = (ModularCurio)item;
                        this.features.addAll(modular.features());
                    }
                }
            }
            for (ICurioStacksHandler e : ((ConditionalData)ConditionalData.HOLDER.get((Player)this.player)).data.values()) {
                if (!(e instanceof IFacet)) continue;
                IFacet t = (IFacet)e;
                this.features.add(t);
            }
        }
    }

    public ItemStack get(Item item) {
        this.refresh();
        return this.map.getOrDefault(item, ItemStack.f_41583_);
    }

    public boolean has(Item ... items) {
        this.refresh();
        for (Item e : items) {
            if (this.map.containsKey(e)) continue;
            return false;
        }
        return true;
    }

    public static void register() {
    }

    public <T extends IFeature> Iterable<T> getFeature(FeatureType<T> type) {
        this.refresh();
        return this.features.get(type);
    }
}

