/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.core.modular;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.xiaoyue.celestial_artifacts.content.core.feature.FeatureMap;
import com.xiaoyue.celestial_artifacts.content.core.modular.AttrFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.BaseCurio;
import com.xiaoyue.celestial_artifacts.content.core.modular.IFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.SetFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.SlotFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TickFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TotemFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.TokenFacet;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.data.CATagGen;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import dev.xkmc.l2damagetracker.contents.curios.L2Totem;
import dev.xkmc.l2damagetracker.contents.curios.TotemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public final class ModularCurio
extends BaseCurio
implements L2Totem {
    private final List<AttrFacet> attributes = new ArrayList<AttrFacet>();
    private final List<SlotFacet> slots = new ArrayList<SlotFacet>();
    private final List<TextFacet> text = new ArrayList<TextFacet>();
    private final List<TickFacet> tick = new ArrayList<TickFacet>();
    private SetFacet set = null;
    private TotemFacet totem = null;
    private TokenFacet<?> token = null;
    private final FeatureMap features = new FeatureMap();
    public final Prop prop;
    private String idCache;

    public static Builder builder() {
        return new Builder();
    }

    public static ModularCurio of(IFacet ... facets) {
        return ModularCurio.builder().build(facets);
    }

    private ModularCurio(Item.Properties props, Prop prop, IFacet ... facets) {
        super(props);
        this.prop = prop;
        for (IFacet e : facets) {
            this.add(e);
        }
    }

    private void add(IFacet facet) {
        IFacet e;
        if (facet instanceof AttrFacet) {
            e = (AttrFacet)facet;
            this.attributes.add((AttrFacet)e);
        }
        if (facet instanceof SlotFacet) {
            e = (SlotFacet)facet;
            this.slots.add((SlotFacet)e);
        }
        if (facet instanceof TextFacet) {
            e = (TextFacet)facet;
            this.text.add((TextFacet)e);
        }
        if (facet instanceof TickFacet) {
            e = (TickFacet)facet;
            this.tick.add((TickFacet)e);
        }
        if (facet instanceof SetFacet) {
            e = (SetFacet)facet;
            this.set = e;
        }
        if (facet instanceof TotemFacet) {
            e = (TotemFacet)facet;
            this.totem = e;
        }
        if (facet instanceof TokenFacet) {
            e = (TokenFacet)facet;
            this.token = e;
        }
        this.features.add(facet);
    }

    public FeatureMap features() {
        return this.features;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.cosmetic()) {
            return;
        }
        for (TickFacet e : this.tick) {
            e.tick(slotContext.entity(), stack);
        }
    }

    @Nullable
    private TotemFacet totem(LivingEntity le) {
        Object obj;
        if (this.totem != null) {
            return this.totem;
        }
        if (this.token != null && (obj = this.token.get(le)) instanceof TotemFacet) {
            TotemFacet t = (TotemFacet)obj;
            return t;
        }
        return null;
    }

    public void trigger(LivingEntity self, ItemStack holded, TotemHelper.TotemSlot second, DamageSource source) {
        TotemFacet totem = this.totem(self);
        if (totem != null && self instanceof Player) {
            Player pl = (Player)self;
            totem.trigger(pl, holded, second, source);
        }
    }

    public boolean allow(LivingEntity self, ItemStack stack, DamageSource pDamageSource) {
        Player player;
        if (!((Boolean)this.enableConfig().get()).booleanValue()) {
            return false;
        }
        TotemFacet totem = this.totem(self);
        return totem != null && self instanceof Player && totem.allow(player = (Player)self, stack, pDamageSource);
    }

    public boolean isValid(LivingEntity self, ItemStack stack, TotemHelper.TotemSlot slot) {
        if (!((Boolean)this.enableConfig().get()).booleanValue()) {
            return false;
        }
        TotemFacet totem = this.totem(self);
        return totem != null && slot instanceof TotemHelper.CurioPred && self instanceof Player;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (!((Boolean)this.enableConfig().get()).booleanValue()) {
            list.add((Component)CALang.Tooltip.BAN.get(new MutableComponent[0]).m_130940_(ChatFormatting.RED));
            return;
        }
        if (level == null || Screen.m_96638_()) {
            for (TextFacet e : this.text) {
                e.addText(level, list);
            }
            if (!this.prop.hideAttr()) {
                if (this.prop.fortune != 0) {
                    list.add((Component)TextFacet.wrap(AttrFacet.simpleAdd((Component)CALang.Modular.FORTUNE.get(new MutableComponent[0]), this.prop.fortune)));
                }
                if (this.prop.loot != 0) {
                    list.add((Component)TextFacet.wrap(AttrFacet.simpleAdd((Component)CALang.Modular.LOOT.get(new MutableComponent[0]), this.prop.loot)));
                }
            }
            if (this.prop.enderMask) {
                list.add((Component)CALang.Modular.ENDER_MASK.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            if (stack.m_204117_(CATagGen.REQUIRE_CURSE)) {
                list.add((Component)CALang.Modular.curse());
            }
            if (!this.text.isEmpty() || !this.prop.hideAttr() && (this.prop.fortune() > 0 || this.prop.loot() > 0) || this.prop.enderMask) {
                list.add((Component)CALang.Modular.shift());
            }
            if (this.prop.immune) {
                list.add((Component)CALang.Modular.IMMUNE.get(new MutableComponent[0]).m_130940_(ChatFormatting.GOLD));
            }
        }
        if (this.set != null) {
            if (level == null || Screen.m_96639_()) {
                this.set.addText(level, list);
            } else {
                list.add((Component)CALang.Modular.alt());
            }
        }
        if (!Screen.m_96638_() && this.prop.curse()) {
            if (Screen.m_96639_()) {
                list.addAll(CatastropheScroll.addInfo());
            } else {
                list.add((Component)CALang.Modular.curseAlt());
            }
        }
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        return this.prop.fortune;
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack stack) {
        return this.prop.loot;
    }

    public boolean m_41386_(DamageSource source) {
        if (this.prop.immune) {
            return false;
        }
        return super.m_41386_(source);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap ans = LinkedHashMultimap.create();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this);
        assert (id != null);
        for (AttrFacet attrFacet : this.attributes) {
            attrFacet.modify(uuid, id.toString(), (Multimap<Attribute, AttributeModifier>)ans);
        }
        for (SlotFacet slotFacet : this.slots) {
            slotFacet.modify(uuid, (Multimap<Attribute, AttributeModifier>)ans);
        }
        return ans;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        if (this.attributes.isEmpty()) {
            return tooltips;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < tooltips.size(); ++i) {
            MutableComponent comp;
            ComponentContents componentContents;
            Object object;
            TranslatableContents tr;
            Object[] args;
            Component txt = tooltips.get(i);
            ComponentContents componentContents2 = txt.m_214077_();
            if (!(componentContents2 instanceof TranslatableContents) || (args = (tr = (TranslatableContents)componentContents2).m_237523_()).length != 2 || !((object = args[1]) instanceof MutableComponent) || !((componentContents = (comp = (MutableComponent)object).m_214077_()) instanceof TranslatableContents)) continue;
            TranslatableContents sub = (TranslatableContents)componentContents;
            map.put(sub.m_237508_(), i);
        }
        for (AttrFacet ent : this.attributes) {
            double val = ent.val().getAsDouble();
            Integer index = (Integer)map.get(ent.attr().get().m_22087_());
            if (index == null) continue;
            if (this.prop.hideAttr()) {
                tooltips.set(index, null);
                continue;
            }
            MutableComponent rep = null;
            if (AttrTooltip.isMult((Attribute)ent.attr().get()) || AttrTooltip.isNegative((Attribute)ent.attr().get())) {
                rep = AttrTooltip.getDesc((Attribute)ent.attr().get(), (double)val, (AttributeModifier.Operation)ent.op());
            }
            if (rep == null) continue;
            tooltips.set(index, (Component)rep);
        }
        tooltips.removeIf(Objects::isNull);
        return tooltips;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return this.prop.enderMask;
    }

    @Override
    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        Player player;
        if (!((Boolean)this.enableConfig().get()).booleanValue()) {
            return false;
        }
        LivingEntity entity = slotContext.entity();
        if (!(!stack.m_204117_(CATagGen.REQUIRE_CURSE) || entity instanceof Player && CurioUtils.isCsOn(player = (Player)entity))) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public ForgeConfigSpec.BooleanValue enableConfig() {
        if (this.idCache == null) {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)this);
            assert (rl != null);
            this.idCache = rl.m_135815_();
        }
        return CAModConfig.COMMON.toggles.get(this.idCache);
    }

    public void enableMap(Consumer<ModularCurio> cons) {
        if (((Boolean)this.enableConfig().get()).booleanValue()) {
            cons.accept(this);
        }
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        Player player;
        if (!this.prop.curse() || !((Boolean)CAModConfig.COMMON.misc.catastropheScrollPreventUnequip.get()).booleanValue()) {
            return true;
        }
        LivingEntity livingEntity = slotContext.entity();
        return livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_();
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext ctx, DamageSource source, int loot, boolean hit, ItemStack stack) {
        return this.prop.curse() ? ICurio.DropRule.ALWAYS_KEEP : super.getDropRule(ctx, source, loot, hit, stack);
    }

    public static class Builder {
        private final Item.Properties prop = new Item.Properties().m_41487_(1);
        private boolean requireCS = false;
        private boolean curse = false;
        private boolean immune = false;
        private boolean hideAttr = false;
        private boolean enderMask = false;
        private int fortune = 0;
        private int loot = 0;

        private Builder() {
        }

        public Builder immune() {
            this.immune = true;
            this.prop.m_41486_();
            return this;
        }

        public Builder requireCS() {
            this.requireCS = true;
            return this;
        }

        public Builder hideAttr() {
            this.hideAttr = true;
            return this;
        }

        public Builder curse() {
            this.curse = true;
            return this;
        }

        public Builder enderMask() {
            this.enderMask = true;
            return this;
        }

        public Builder rarity(Rarity rarity) {
            this.prop.m_41497_(rarity);
            return this;
        }

        public Builder fortune(int fortune) {
            this.fortune = fortune;
            return this;
        }

        public Builder loot(int loot) {
            this.loot = loot;
            return this;
        }

        public ModularCurio build(IFacet ... facet) {
            return new ModularCurio(this.prop, new Prop(this.requireCS, this.curse, this.immune, this.hideAttr, this.enderMask, this.fortune, this.loot), facet);
        }
    }

    public record Prop(boolean requireCS, boolean curse, boolean immune, boolean hideAttr, boolean enderMask, int fortune, int loot) {
    }
}

