/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.core.token;

import com.xiaoyue.celestial_artifacts.content.core.feature.IFeature;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeRoot;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import java.util.Optional;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public interface CAAttackToken
extends IFeature {
    public static boolean chance(LivingEntity player, double chance) {
        return player.m_217043_().m_188500_() < chance;
    }

    public static DamageSource getSource(AttackCache cache) {
        LivingAttackEvent event = cache.getLivingAttackEvent();
        if (!1.$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        return event.getSource();
    }

    public static boolean isArrow(AttackCache cache) {
        return CAAttackToken.getSource(cache).m_269533_(DamageTypeTags.f_268524_);
    }

    public static boolean isMelee(AttackCache cache) {
        if (cache.getAttacker() == null) {
            return false;
        }
        if (cache.getAttacker() == cache.getAttackTarget()) {
            return false;
        }
        LivingAttackEvent event = cache.getLivingAttackEvent();
        if (event == null) {
            return false;
        }
        if (event.getSource().m_7640_() != cache.getAttacker()) {
            return false;
        }
        Optional<DamageTypeRoot> ans = event.getSource().m_269150_().m_203543_().map(DamageTypeRoot::of);
        return ans.isPresent() && (ans.get() == L2DamageTypes.PLAYER_ATTACK || ans.get() == L2DamageTypes.MOB_ATTACK);
    }

    default public void onPlayerDamagedFinal(Player player, AttackCache cache) {
    }

    default public void onPlayerAttackTarget(Player player, AttackCache cache) {
    }

    default public void onPlayerHurtTarget(Player player, AttackCache cache) {
    }

    default public void onPlayerDamageTarget(Player player, AttackCache cache) {
    }

    default public boolean onPlayerAttacked(Player player, AttackCache cache) {
        return false;
    }

    default public void onPlayerHurt(Player player, AttackCache cache) {
    }

    default public void onPlayerDamaged(Player player, AttackCache cache) {
    }

    default public void onPlayerDamageTargetFinal(Player player, AttackCache cache) {
    }

    default public void onCreateSource(Player player, CreateSourceEvent event) {
    }

    default public void onPlayerKill(Player player, LivingDeathEvent event) {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

