/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.charm;

import com.xiaoyue.celestial_artifacts.content.core.modular.MultiLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TickFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TotemFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.curios.TotemHelper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HolyTalisman
implements MultiLineText,
TickFacet,
CAAttackToken,
TotemFacet {
    private static int interval() {
        return (Integer)CAModConfig.COMMON.charm.holyTalismanWeakenInterval.get();
    }

    private static int duration() {
        return (Integer)CAModConfig.COMMON.charm.holyTalismanEffectDuration.get();
    }

    private static double prot() {
        return (Double)CAModConfig.COMMON.charm.holyTalismanProtection.get();
    }

    private static double protUndead() {
        return (Double)CAModConfig.COMMON.charm.holyTalismanProtectionUndead.get();
    }

    private static int cooldown() {
        return (Integer)CAModConfig.COMMON.charm.holyTalismanCooldown.get();
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Charm.HOLY_TALISMAN_1.get(TextFacet.num(HolyTalisman.interval()), TextFacet.num(HolyTalisman.duration()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.HOLY_TALISMAN_2.get(TextFacet.perc(HolyTalisman.prot()), TextFacet.perc(HolyTalisman.protUndead()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.HOLY_TALISMAN_3.get(TextFacet.num(HolyTalisman.cooldown()))));
    }

    @Override
    public void tick(LivingEntity entity, ItemStack stack) {
        if (entity.f_19797_ % (HolyTalisman.interval() * 20) == 0) {
            List entities = EntityUtils.getExceptForCentralEntity((LivingEntity)entity, (float)8.0f, (float)2.0f, LivingEntity::m_6084_);
            int size = entities.size();
            for (LivingEntity list : entities) {
                if (!(list instanceof Monster)) continue;
                Monster monster = (Monster)list;
                EntityUtils.addEct((LivingEntity)monster, (MobEffect)MobEffects.f_19613_, (int)(size * HolyTalisman.duration() * 20), (int)0);
            }
        }
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        LivingEntity e = cache.getAttacker();
        if (e != null) {
            float factor = (float)(e.m_6336_() == MobType.f_21641_ ? 1.0 - HolyTalisman.protUndead() : 1.0 - HolyTalisman.prot());
            cache.addDealtModifier(DamageModifier.multTotal((float)factor));
        }
    }

    @Override
    public void trigger(Player player, ItemStack holded, TotemHelper.TotemSlot second, DamageSource source) {
        TotemFacet.super.trigger(player, holded, second, source);
        player.m_7911_(player.m_21233_());
        player.m_36335_().m_41524_(holded.m_41720_(), HolyTalisman.cooldown() * 20);
    }
}

