/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.heart;

import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.AttrAdder;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class TwistedHeart
extends BaseTickingToken
implements CAAttackToken {
    private static double damageFactor() {
        return (Double)CAModConfig.COMMON.heart.twistedHeartDamage.get();
    }

    private static double toughnessFactor() {
        return (Double)CAModConfig.COMMON.heart.twistedHeartToughness.get();
    }

    private boolean bonus(Player player) {
        return CatastropheScroll.Curses.NIHILITY.cursing(player);
    }

    private AttrAdder armor(Player player) {
        return AttrAdder.of("twisted_heart", () -> Attributes.f_22285_, AttributeModifier.Operation.MULTIPLY_TOTAL, this.bonus(player) ? TwistedHeart::toughnessFactor : () -> -TwistedHeart.toughnessFactor());
    }

    private AttrAdder attack(Player player) {
        return AttrAdder.of("twisted_heart", () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, this.bonus(player) ? TwistedHeart::damageFactor : () -> -TwistedHeart.damageFactor());
    }

    @Override
    protected void removeImpl(Player player) {
        this.armor(player).removeImpl(player);
        this.attack(player).removeImpl(player);
    }

    @Override
    protected void tickImpl(Player player) {
        this.armor(player).tickImpl(player);
        this.attack(player).tickImpl(player);
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Heart.TWISTED_HEART_1.get(TextFacet.perc(TwistedHeart.damageFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Heart.TWISTED_HEART_2.get(TextFacet.perc(TwistedHeart.toughnessFactor())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Heart.TWISTED_HEART_3.get(new MutableComponent[0]).m_130940_(ChatFormatting.GRAY)));
    }
}

