/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.events;

import com.xiaoyue.celestial_artifacts.content.core.feature.FeatureType;
import com.xiaoyue.celestial_artifacts.content.core.modular.CurioCacheCap;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class CAAttackListener
implements AttackListener {
    public static void fireEvent(Player player, Consumer<CAAttackToken> cons) {
        for (CAAttackToken token : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.ATK)) {
            cons.accept(token);
        }
    }

    public static boolean fireEventCancellable(Player player, Predicate<CAAttackToken> cons) {
        for (CAAttackToken token : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.ATK)) {
            if (!cons.test(token)) continue;
            return true;
        }
        return false;
    }

    public void onCreateSource(CreateSourceEvent event) {
        LivingEntity livingEntity;
        if (event.getResult() != null && event.getResult().toRoot() == L2DamageTypes.PLAYER_ATTACK && (livingEntity = event.getAttacker()) instanceof Player) {
            Player player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onCreateSource(player, event));
        }
    }

    public void onDamageFinalized(AttackCache cache, ItemStack weapon) {
        Player player;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        LivingEntity livingEntity = cache.getAttackTarget();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerDamagedFinal(player, cache));
        }
        if ((livingEntity = cache.getAttacker()) instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerDamageTargetFinal(player, cache));
        }
    }

    public void onAttack(AttackCache cache, ItemStack weapon) {
        Player player;
        LivingAttackEvent event = cache.getLivingAttackEvent();
        assert (event != null);
        LivingEntity livingEntity = cache.getAttackTarget();
        if (livingEntity instanceof Player && CAAttackListener.fireEventCancellable(player = (Player)livingEntity, t -> t.onPlayerAttacked(player, cache))) {
            event.setCanceled(true);
            return;
        }
        livingEntity = cache.getAttacker();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerAttackTarget(player, cache));
        }
    }

    public void onHurt(AttackCache cache, ItemStack weapon) {
        Player player;
        LivingHurtEvent event = cache.getLivingHurtEvent();
        assert (event != null);
        LivingEntity livingEntity = cache.getAttacker();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerHurtTarget(player, cache));
            LivingEntity livingEntity2 = cache.getAttackTarget();
            if (livingEntity2 instanceof Mob) {
                Mob mob = (Mob)livingEntity2;
                if (mob.f_21346_.m_148105_().isEmpty()) {
                    CatastropheScroll.Curses.DESIRE.trigger(player);
                }
            }
        }
        if ((livingEntity = cache.getAttackTarget()) instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerHurt(player, cache));
            CatastropheScroll.Curses.LIFE.trigger(player);
        }
    }

    public void onDamage(AttackCache cache, ItemStack weapon) {
        Player player;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        LivingEntity livingEntity = cache.getAttacker();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerDamageTarget(player, cache));
        }
        if ((livingEntity = cache.getAttackTarget()) instanceof Player) {
            player = (Player)livingEntity;
            CAAttackListener.fireEvent(player, t -> t.onPlayerDamaged(player, cache));
        }
    }
}

