/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.events;

import com.xiaoyue.celestial_artifacts.content.core.feature.BreakSpeedFeature;
import com.xiaoyue.celestial_artifacts.content.core.feature.FeatureType;
import com.xiaoyue.celestial_artifacts.content.core.feature.HealFeature;
import com.xiaoyue.celestial_artifacts.content.core.feature.ShieldingFeature;
import com.xiaoyue.celestial_artifacts.content.core.feature.XpBonusFeature;
import com.xiaoyue.celestial_artifacts.content.core.modular.CurioCacheCap;
import com.xiaoyue.celestial_artifacts.events.CAAttackListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_artifacts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CAGeneralEventHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            CAAttackListener.fireEvent(player, t -> t.onPlayerKill(player, event));
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        double factor = 1.0;
        for (XpBonusFeature e : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.EXP)) {
            factor += e.getXpBonus(player);
        }
        event.getOrb().f_20770_ = (int)((double)event.getOrb().f_20770_ * factor);
    }

    @SubscribeEvent
    public static void onPlayerBreak(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        double factor = 1.0;
        for (BreakSpeedFeature e : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.MINING)) {
            factor *= e.getBreakFactor(player);
        }
        event.setNewSpeed((float)((double)event.getOriginalSpeed() * factor));
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (HealFeature e : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.HEAL)) {
                e.onPlayerHeal(player, event);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBlocked(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ShieldingFeature e : ((CurioCacheCap)CurioCacheCap.HOLDER.get(player)).getFeature(FeatureType.SHIELD)) {
                e.onPlayerBlocked(player, event);
            }
        }
    }
}

