/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.heroesofenvell.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.heroesofenvell.HeroesOfEnvellMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HeroesOfEnvellModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        HeroesOfEnvellMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        HeroesOfEnvellMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HeroesOfEnvellMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.class_hero = message.data.class_hero;
                    variables.elements = message.data.elements;
                    variables.world_x = message.data.world_x;
                    variables.world_y = message.data.world_y;
                    variables.world_z = message.data.world_z;
                    variables.envell_x = message.data.envell_x;
                    variables.envell_y = message.data.envell_y;
                    variables.envell_z = message.data.envell_z;
                    variables.dimensional = message.data.dimensional;
                    variables.exp = message.data.exp;
                    variables.level = message.data.level;
                    variables.skill = message.data.skill;
                    variables.Mana = message.data.Mana;
                    variables.marionette = message.data.marionette;
                    variables.start = message.data.start;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double class_hero = 0.0;
        public double elements = 0.0;
        public double world_x = 0.0;
        public double world_y = 0.0;
        public double world_z = 0.0;
        public double envell_x = 0.0;
        public double envell_y = 0.0;
        public double envell_z = 0.0;
        public double dimensional = 1.0;
        public double exp = 0.0;
        public double level = 1.0;
        public double skill = 1.0;
        public double Mana = 200.0;
        public double marionette = 0.0;
        public boolean start = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("class_hero", this.class_hero);
            nbt.m_128347_("elements", this.elements);
            nbt.m_128347_("world_x", this.world_x);
            nbt.m_128347_("world_y", this.world_y);
            nbt.m_128347_("world_z", this.world_z);
            nbt.m_128347_("envell_x", this.envell_x);
            nbt.m_128347_("envell_y", this.envell_y);
            nbt.m_128347_("envell_z", this.envell_z);
            nbt.m_128347_("dimensional", this.dimensional);
            nbt.m_128347_("exp", this.exp);
            nbt.m_128347_("level", this.level);
            nbt.m_128347_("skill", this.skill);
            nbt.m_128347_("Mana", this.Mana);
            nbt.m_128347_("marionette", this.marionette);
            nbt.m_128379_("start", this.start);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.class_hero = nbt.m_128459_("class_hero");
            this.elements = nbt.m_128459_("elements");
            this.world_x = nbt.m_128459_("world_x");
            this.world_y = nbt.m_128459_("world_y");
            this.world_z = nbt.m_128459_("world_z");
            this.envell_x = nbt.m_128459_("envell_x");
            this.envell_y = nbt.m_128459_("envell_y");
            this.envell_z = nbt.m_128459_("envell_z");
            this.dimensional = nbt.m_128459_("dimensional");
            this.exp = nbt.m_128459_("exp");
            this.level = nbt.m_128459_("level");
            this.skill = nbt.m_128459_("skill");
            this.Mana = nbt.m_128459_("Mana");
            this.marionette = nbt.m_128459_("marionette");
            this.start = nbt.m_128471_("start");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("heroes_of_envell", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "heroes_of_envell_mapvars";
        public boolean throne_room = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.throne_room = nbt.m_128471_("throne_room");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("throne_room", this.throne_room);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "heroes_of_envell_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.class_hero = original.class_hero;
            clone.world_x = original.world_x;
            clone.world_y = original.world_y;
            clone.world_z = original.world_z;
            clone.envell_x = original.envell_x;
            clone.envell_y = original.envell_y;
            clone.envell_z = original.envell_z;
            clone.dimensional = original.dimensional;
            clone.exp = original.exp;
            clone.level = original.level;
            clone.marionette = original.marionette;
            clone.start = original.start;
            if (!event.isWasDeath()) {
                clone.elements = original.elements;
                clone.skill = original.skill;
                clone.Mana = original.Mana;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                HeroesOfEnvellMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

