/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.events;

import com.thomas7520.remindclockhud.RemindClockHUD;
import com.thomas7520.remindclockhud.object.Chronometer;
import com.thomas7520.remindclockhud.object.Clock;
import com.thomas7520.remindclockhud.screens.MenuScreen;
import com.thomas7520.remindclockhud.util.HUDMode;
import com.thomas7520.remindclockhud.util.RemindClockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="remindclockhud")
public class RemindClockEvent {
    @SubscribeEvent
    public static void onKeyInputEvent(InputEvent.Key event) {
        Chronometer chronometer;
        if (RemindClockUtil.guiBind.m_90857_()) {
            Minecraft.m_91087_().m_91152_((Screen)new MenuScreen());
        }
        if (RemindClockUtil.switchChronometerBind.m_90857_()) {
            chronometer = RemindClockHUD.getChronometer();
            if (!chronometer.isEnable()) {
                return;
            }
            if (!chronometer.isStarted()) {
                chronometer.setStarted(true);
            } else {
                chronometer.setPaused(!chronometer.isPaused());
            }
        }
        if (RemindClockUtil.resetChronometerBind.m_90857_()) {
            chronometer = RemindClockHUD.getChronometer();
            if (!(chronometer.isEnable() && chronometer.isStarted() && chronometer.isPaused())) {
                return;
            }
            chronometer.reset();
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ != null) {
            if (RemindClockHUD.getClock().isEnable()) {
                if (RemindClockHUD.getClock().getRgbModeText() != HUDMode.STATIC) {
                    RemindClockUtil.waveCounterClockText += (float)(RemindClockHUD.getClock().getRgbSpeedText() - 1) / 99.0f * 9.0f + 1.0f;
                }
                if (RemindClockHUD.getClock().isDrawBackground() && RemindClockHUD.getClock().getRgbModeBackground() != HUDMode.STATIC) {
                    RemindClockUtil.waveCounterClockBackground += (float)(RemindClockHUD.getClock().getRgbSpeedBackground() - 1) / 99.0f * 19.0f + 1.0f;
                }
            }
            if (RemindClockHUD.getChronometer().isEnable()) {
                if (RemindClockHUD.getChronometer().getRgbModeText() != HUDMode.STATIC) {
                    RemindClockUtil.waveCounterChronometerText += (float)(RemindClockHUD.getChronometer().getRgbSpeedText() - 1) / 99.0f * 9.0f + 1.0f;
                }
                if (RemindClockHUD.getChronometer().isDrawBackground() && RemindClockHUD.getChronometer().getRgbModeBackground() != HUDMode.STATIC) {
                    RemindClockUtil.waveCounterChronometerBackground += (float)(RemindClockHUD.getChronometer().getRgbSpeedBackground() - 1) / 99.0f * 9.0f + 1.0f;
                }
            }
        }
    }

    @SubscribeEvent
    public static void hudEvent(RenderGuiOverlayEvent.Post event) {
        Chronometer chronometer;
        if (event.getOverlay() != VanillaGuiOverlay.AIR_LEVEL.type()) {
            return;
        }
        Clock clock = RemindClockHUD.getClock();
        int width = event.getGuiGraphics().m_280182_();
        int height = event.getGuiGraphics().m_280206_();
        Font font = Minecraft.m_91087_().f_91062_;
        float x = (float)(clock.getPosX() / 100.0 * (double)event.getWindow().m_85445_());
        float y = (float)(clock.getPosY() / 100.0 * (double)event.getWindow().m_85446_());
        if (clock.isEnable()) {
            RemindClockUtil.renderClock(clock, event.getGuiGraphics(), font, x, y, width, height);
        }
        if ((chronometer = RemindClockHUD.getChronometer()).isEnable() && (chronometer.isStarted() || chronometer.isIdleRender())) {
            String chronometerFormatted = chronometer.getFormat().formatTime(chronometer.getStartTime());
            if (chronometer.isPaused()) {
                chronometerFormatted = chronometer.getPauseTimeCache();
            }
            if (!chronometer.isStarted() && chronometer.isIdleRender()) {
                chronometerFormatted = chronometer.getFormat().formatTime(System.currentTimeMillis());
            }
            x = (float)(chronometer.getPosX() / 100.0 * (double)event.getWindow().m_85445_());
            y = (float)(chronometer.getPosY() / 100.0 * (double)event.getWindow().m_85446_());
            RemindClockUtil.drawChronometer(chronometer, chronometerFormatted, event.getGuiGraphics(), font, x, y, width, height);
        }
    }
}

