/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.object;

import com.thomas7520.remindclockhud.util.ChronometerFormat;
import com.thomas7520.remindclockhud.util.HUDMode;
import java.util.ArrayList;
import java.util.List;

public class Chronometer {
    private ChronometerFormat format;
    private String pauseTimeCache;
    private boolean drawBackground;
    private HUDMode rgbModeText;
    private HUDMode rgbModeBackground;
    private int redText;
    private int greenText;
    private int blueText;
    private int alphaText;
    private int rgbSpeedText;
    private int redBackground;
    private int greenBackground;
    private int blueBackground;
    private int alphaBackground;
    private int rgbSpeedBackground;
    private boolean textRightToLeftDirection;
    private boolean backgroundRightToLeftDirection;
    private double posX;
    private double posY;
    private long startTime;
    private long pauseTime;
    private boolean enable;
    private boolean paused;
    private boolean started;
    private boolean idleRender;
    private final List<Long> laps = new ArrayList<Long>();

    public Chronometer(boolean enable, ChronometerFormat format, boolean drawBackground, HUDMode rgbModeText, HUDMode rgbModeBackground, int redText, int greenText, int blueText, int alphaText, int rgbSpeedText, int redBackground, int greenBackground, int blueBackground, int alphaBackground, int rgbSpeedBackground, boolean textRightToLeftDirection, boolean backgroundRightToLeftDirection, boolean idleRender, double posX, double posY) {
        this.enable = enable;
        this.format = format;
        this.drawBackground = drawBackground;
        this.rgbModeText = rgbModeText;
        this.rgbModeBackground = rgbModeBackground;
        this.redText = redText;
        this.greenText = greenText;
        this.blueText = blueText;
        this.alphaText = alphaText;
        this.rgbSpeedText = rgbSpeedText;
        this.redBackground = redBackground;
        this.greenBackground = greenBackground;
        this.blueBackground = blueBackground;
        this.alphaBackground = alphaBackground;
        this.rgbSpeedBackground = rgbSpeedBackground;
        this.textRightToLeftDirection = textRightToLeftDirection;
        this.backgroundRightToLeftDirection = backgroundRightToLeftDirection;
        this.idleRender = idleRender;
        this.posX = posX;
        this.posY = posY;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setStarted(boolean started) {
        if (!this.enable) {
            return;
        }
        this.started = started;
        this.setStartTime(System.currentTimeMillis());
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean stop) {
        if (!this.started || !this.enable) {
            return;
        }
        if (!this.paused && stop) {
            this.pauseTimeCache = this.format.formatTime(this.startTime);
            this.pauseTime = System.currentTimeMillis();
        }
        if (this.paused && !stop) {
            this.pauseTimeCache = "";
            this.setStartTime(this.startTime + (System.currentTimeMillis() - this.pauseTime));
            this.pauseTime = 0L;
        }
        this.paused = stop;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void addLap(long time) {
        this.laps.add(time);
    }

    public List<Long> getLaps() {
        return this.laps;
    }

    public ChronometerFormat getFormat() {
        return this.format;
    }

    public void setFormat(ChronometerFormat format) {
        this.format = format;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public HUDMode getRgbModeText() {
        return this.rgbModeText;
    }

    public void setRgbModeText(HUDMode rgbModeText) {
        this.rgbModeText = rgbModeText;
    }

    public HUDMode getRgbModeBackground() {
        return this.rgbModeBackground;
    }

    public void setRgbModeBackground(HUDMode rgbModeBackground) {
        this.rgbModeBackground = rgbModeBackground;
    }

    public int getRedText() {
        return this.redText;
    }

    public void setRedText(int redText) {
        this.redText = redText;
    }

    public int getGreenText() {
        return this.greenText;
    }

    public void setGreenText(int greenText) {
        this.greenText = greenText;
    }

    public int getBlueText() {
        return this.blueText;
    }

    public void setBlueText(int blueText) {
        this.blueText = blueText;
    }

    public int getAlphaText() {
        return this.alphaText;
    }

    public void setAlphaText(int alphaText) {
        this.alphaText = alphaText;
    }

    public int getRgbSpeedText() {
        return this.rgbSpeedText;
    }

    public void setRgbSpeedText(int rgbSpeedText) {
        this.rgbSpeedText = rgbSpeedText;
    }

    public int getRedBackground() {
        return this.redBackground;
    }

    public void setRedBackground(int redBackground) {
        this.redBackground = redBackground;
    }

    public int getGreenBackground() {
        return this.greenBackground;
    }

    public void setGreenBackground(int greenBackground) {
        this.greenBackground = greenBackground;
    }

    public int getBlueBackground() {
        return this.blueBackground;
    }

    public void setBlueBackground(int blueBackground) {
        this.blueBackground = blueBackground;
    }

    public int getAlphaBackground() {
        return this.alphaBackground;
    }

    public void setAlphaBackground(int alphaBackground) {
        this.alphaBackground = alphaBackground;
    }

    public int getRgbSpeedBackground() {
        return this.rgbSpeedBackground;
    }

    public void setRgbSpeedBackground(int rgbSpeedBackground) {
        this.rgbSpeedBackground = rgbSpeedBackground;
    }

    public boolean isTextRightToLeftDirection() {
        return this.textRightToLeftDirection;
    }

    public void setTextRightToLeftDirection(boolean textRightToLeftDirection) {
        this.textRightToLeftDirection = textRightToLeftDirection;
    }

    public boolean isBackgroundRightToLeftDirection() {
        return this.backgroundRightToLeftDirection;
    }

    public void setBackgroundRightToLeftDirection(boolean backgroundRightToLeftDirection) {
        this.backgroundRightToLeftDirection = backgroundRightToLeftDirection;
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public String getPauseTimeCache() {
        return this.pauseTimeCache;
    }

    public boolean isIdleRender() {
        return this.idleRender;
    }

    public void setIdleRender(boolean idleRender) {
        this.idleRender = idleRender;
    }

    public void reset() {
        this.paused = false;
        this.started = false;
        this.startTime = 0L;
        this.laps.clear();
    }

    public String toString() {
        return "Chronometer{format=" + this.format + ", pauseTimeCache='" + this.pauseTimeCache + "', drawBackground=" + this.drawBackground + ", rgbModeText=" + this.rgbModeText + ", rgbModeBackground=" + this.rgbModeBackground + ", redText=" + this.redText + ", greenText=" + this.greenText + ", blueText=" + this.blueText + ", alphaText=" + this.alphaText + ", rgbSpeedText=" + this.rgbSpeedText + ", redBackground=" + this.redBackground + ", greenBackground=" + this.greenBackground + ", blueBackground=" + this.blueBackground + ", alphaBackground=" + this.alphaBackground + ", rgbSpeedBackground=" + this.rgbSpeedBackground + ", textRightToLeftDirection=" + this.textRightToLeftDirection + ", backgroundRightToLeftDirection=" + this.backgroundRightToLeftDirection + ", posX=" + this.posX + ", posY=" + this.posY + ", startTime=" + this.startTime + ", pauseTime=" + this.pauseTime + ", enable=" + this.enable + ", paused=" + this.paused + ", started=" + this.started + ", idleRender=" + this.idleRender + ", laps=" + this.laps + "}";
    }
}

