/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.object;

import com.thomas7520.remindclockhud.util.HUDMode;
import com.thomas7520.remindclockhud.util.RemindClockUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class Clock {
    private boolean enable;
    private String formatText;
    private boolean drawBackground;
    private boolean use12HourFormat;
    private HUDMode rgbModeText;
    private HUDMode rgbModeBackground;
    private int redText;
    private int greenText;
    private int blueText;
    private int alphaText;
    private int rgbSpeedText;
    private int redBackground;
    private int greenBackground;
    private int blueBackground;
    private int alphaBackground;
    private int rgbSpeedBackground;
    private boolean textRightToLeftDirection;
    private boolean backgroundRightToLeftDirection;
    private double posX;
    private double posY;

    public Clock(boolean enable, String formatText, boolean drawBackground, boolean use12HourFormat, HUDMode rgbModeText, HUDMode rgbModeBackground, int redText, int greenText, int blueText, int alphaText, int rgbSpeedText, int redBackground, int greenBackground, int blueBackground, int alphaBackground, int rgbSpeedBackground, boolean textRightToLeftDirection, boolean backgroundRightToLeftDirection, double posX, double posY) {
        this.enable = enable;
        this.formatText = formatText;
        this.drawBackground = drawBackground;
        this.use12HourFormat = use12HourFormat;
        this.rgbModeText = rgbModeText;
        this.rgbModeBackground = rgbModeBackground;
        this.redText = redText;
        this.greenText = greenText;
        this.blueText = blueText;
        this.alphaText = alphaText;
        this.rgbSpeedText = rgbSpeedText;
        this.redBackground = redBackground;
        this.greenBackground = greenBackground;
        this.blueBackground = blueBackground;
        this.alphaBackground = alphaBackground;
        this.rgbSpeedBackground = rgbSpeedBackground;
        this.textRightToLeftDirection = textRightToLeftDirection;
        this.backgroundRightToLeftDirection = backgroundRightToLeftDirection;
        this.posX = posX;
        this.posY = posY;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getFormatText() {
        return this.formatText;
    }

    public void setFormatText(String formatText) {
        this.formatText = formatText;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isUse12HourFormat() {
        return this.use12HourFormat;
    }

    public void setUse12HourFormat(boolean use12HourFormat) {
        this.use12HourFormat = use12HourFormat;
    }

    public HUDMode getRgbModeText() {
        return this.rgbModeText;
    }

    public void setRgbModeText(HUDMode rgbModeText) {
        this.rgbModeText = rgbModeText;
    }

    public HUDMode getRgbModeBackground() {
        return this.rgbModeBackground;
    }

    public void setRgbModeBackground(HUDMode rgbModeBackground) {
        this.rgbModeBackground = rgbModeBackground;
    }

    public int getRedText() {
        return this.redText;
    }

    public void setRedText(int redText) {
        this.redText = redText;
    }

    public int getGreenText() {
        return this.greenText;
    }

    public void setGreenText(int greenText) {
        this.greenText = greenText;
    }

    public int getBlueText() {
        return this.blueText;
    }

    public void setBlueText(int blueText) {
        this.blueText = blueText;
    }

    public int getAlphaText() {
        return this.alphaText;
    }

    public void setAlphaText(int alphaText) {
        this.alphaText = alphaText;
    }

    public int getRgbSpeedText() {
        return this.rgbSpeedText;
    }

    public void setRgbSpeedText(int rgbSpeedText) {
        this.rgbSpeedText = rgbSpeedText;
    }

    public int getRedBackground() {
        return this.redBackground;
    }

    public void setRedBackground(int redBackground) {
        this.redBackground = redBackground;
    }

    public int getGreenBackground() {
        return this.greenBackground;
    }

    public void setGreenBackground(int greenBackground) {
        this.greenBackground = greenBackground;
    }

    public int getBlueBackground() {
        return this.blueBackground;
    }

    public void setBlueBackground(int blueBackground) {
        this.blueBackground = blueBackground;
    }

    public int getAlphaBackground() {
        return this.alphaBackground;
    }

    public void setAlphaBackground(int alphaBackground) {
        this.alphaBackground = alphaBackground;
    }

    public int getRgbSpeedBackground() {
        return this.rgbSpeedBackground;
    }

    public void setRgbSpeedBackground(int rgbSpeedBackground) {
        this.rgbSpeedBackground = rgbSpeedBackground;
    }

    public boolean isTextRightToLeftDirection() {
        return this.textRightToLeftDirection;
    }

    public void setTextRightToLeftDirection(boolean textRightToLeftDirection) {
        this.textRightToLeftDirection = textRightToLeftDirection;
    }

    public boolean isBackgroundRightToLeftDirection() {
        return this.backgroundRightToLeftDirection;
    }

    public void setBackgroundRightToLeftDirection(boolean backgroundRightToLeftDirection) {
        this.backgroundRightToLeftDirection = backgroundRightToLeftDirection;
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public String toString() {
        return "Clock{enable=" + this.enable + ", formatText='" + this.formatText + "', drawBackground=" + this.drawBackground + ", use12HourFormat=" + this.use12HourFormat + ", rgbModeText=" + this.rgbModeText + ", rgbModeBackground=" + this.rgbModeBackground + ", redText=" + this.redText + ", greenText=" + this.greenText + ", blueText=" + this.blueText + ", alphaText=" + this.alphaText + ", rgbSpeedText=" + this.rgbSpeedText + ", redBackground=" + this.redBackground + ", greenBackground=" + this.greenBackground + ", blueBackground=" + this.blueBackground + ", alphaBackground=" + this.alphaBackground + ", rgbSpeedBackground=" + this.rgbSpeedBackground + ", textRightToLeftDirection=" + this.textRightToLeftDirection + ", backgroundRightToLeftDirection=" + this.backgroundRightToLeftDirection + ", posX=" + this.posX + ", posY=" + this.posY + "}";
    }

    public String getDateFormatted() {
        LocalDateTime now = LocalDateTime.now();
        Locale locale = RemindClockUtil.getMinecraftLocalLanguage();
        DateTimeFormatter timeFormatter = this.use12HourFormat ? DateTimeFormatter.ofPattern("hh:mm:ss a", locale) : DateTimeFormatter.ofPattern("HH:mm:ss", locale);
        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("EEEE", locale);
        DateTimeFormatter dayShortFormatter = DateTimeFormatter.ofPattern("E", locale);
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM", locale);
        DateTimeFormatter shortMonthFormatter = DateTimeFormatter.ofPattern("MMM", locale);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy", locale);
        String date = this.formatText.replace("%hh", timeFormatter.format(now).substring(0, 2)).replace("%mm", timeFormatter.format(now).substring(3, 5)).replace("%ss", timeFormatter.format(now).substring(6, 8)).replace("%dd", dateFormatter.format(now).substring(0, 2)).replace("%day", StringUtils.capitalize((String)dayFormatter.format(now))).replace("%sday", StringUtils.capitalize((String)dayShortFormatter.format(now))).replace("%month", StringUtils.capitalize((String)monthFormatter.format(now))).replace("%smonth", StringUtils.capitalize((String)shortMonthFormatter.format(now))).replace("%MM", dateFormatter.format(now).substring(3, 5)).replace("%yyyy", String.valueOf(now.getYear())).replace("%yy", String.valueOf(now.getYear() % 100));
        if (this.use12HourFormat) {
            date = date.replace("%state", timeFormatter.format(now).substring(9, 11));
        }
        return date;
    }
}

