/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.screens.chronometer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.thomas7520.remindclockhud.RemindClockHUD;
import com.thomas7520.remindclockhud.object.Chronometer;
import com.thomas7520.remindclockhud.util.RemindClockConfig;
import com.thomas7520.remindclockhud.util.RemindClockUtil;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;

public class ChronometerPositionScreen
extends Screen {
    private final Screen lastScreen;
    public Chronometer chronometer;
    private boolean clicked;
    private double percentageX;
    private double percentageY;
    private double x;
    private double y;

    public ChronometerPositionScreen(Screen lastScreen) {
        super((Component)Component.m_237119_());
        this.lastScreen = lastScreen;
        this.chronometer = RemindClockHUD.getChronometer();
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX >= this.x && pMouseX <= this.x + (double)this.f_96547_.m_92895_(this.chronometer.getFormat().formatTime(System.currentTimeMillis())) + 3.0 && pMouseY >= this.y && pMouseY <= this.y + 12.0 && !this.clicked) {
            this.clicked = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.clicked) {
            this.clicked = false;
            RemindClockConfig.Client.Chronometer configChronometer = RemindClockConfig.CLIENT.chronometer;
            configChronometer.posX.set((Object)this.chronometer.getPosX());
            configChronometer.posY.set((Object)this.chronometer.getPosY());
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float p_282465_) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, p_282465_);
        if (this.clicked) {
            this.percentageX = (double)mouseX / (double)this.f_96541_.m_91268_().m_85445_() * 100.0;
            this.percentageY = (double)mouseY / (double)this.f_96541_.m_91268_().m_85446_() * 100.0;
            this.percentageX = Math.min(100.0, Math.max(0.0, this.percentageX));
            this.percentageY = Math.min(100.0, Math.max(0.0, this.percentageY));
            this.chronometer.setPosX(this.percentageX);
            this.chronometer.setPosY(this.percentageY);
        }
        for (int i = 1; i < 4; ++i) {
            graphics.m_280509_(this.f_96543_ / 4 * i, 0, this.f_96543_ / 4 * i + 1, this.f_96544_, Color.RED.getRGB());
            graphics.m_280509_(0, this.f_96544_ / 4 * i, this.f_96543_, this.f_96544_ / 4 * i + 1, Color.RED.getRGB());
        }
        String dateFormatted = this.chronometer.getFormat().formatTime(System.currentTimeMillis());
        graphics.m_280653_(this.f_96547_, this.f_96539_, 2, 20, 0xFFFFFF);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172811_);
        this.x = (float)(this.chronometer.getPosX() / 100.0 * (double)this.f_96541_.m_91268_().m_85445_());
        this.y = (float)(this.chronometer.getPosY() / 100.0 * (double)this.f_96541_.m_91268_().m_85446_());
        RemindClockUtil.drawChronometer(this.chronometer, dateFormatted, graphics, this.f_96547_, this.x, this.y, this.f_96543_, this.f_96544_);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        switch (pKeyCode) {
            case 263: {
                xOffset -= 0.5f;
                break;
            }
            case 262: {
                xOffset += 0.5f;
                break;
            }
            case 265: {
                yOffset -= 0.5f;
                break;
            }
            case 264: {
                yOffset += 0.5f;
            }
        }
        this.x = (float)((this.chronometer.getPosX() + (double)xOffset) / 100.0 * (double)this.f_96541_.m_91268_().m_85445_());
        this.y = (float)((this.chronometer.getPosY() + (double)yOffset) / 100.0 * (double)this.f_96541_.m_91268_().m_85446_());
        int rectWidth = this.f_96547_.m_92895_(this.chronometer.getFormat().formatTime(System.currentTimeMillis())) + 3;
        int rectHeight = 12;
        this.x = Math.max(0.0, this.x);
        this.x = Math.min((double)(this.f_96543_ - rectWidth), this.x);
        this.y = Math.max(this.y, 0.0);
        this.y = Math.min(this.y, (double)(this.f_96544_ - rectHeight));
        this.percentageX = this.x / (double)this.f_96541_.m_91268_().m_85445_() * 100.0;
        this.percentageY = this.y / (double)this.f_96541_.m_91268_().m_85446_() * 100.0;
        this.percentageX = Math.min(100.0, Math.max(0.0, this.percentageX));
        this.percentageY = Math.min(100.0, Math.max(0.0, this.percentageY));
        this.chronometer.setPosX(this.percentageX);
        this.chronometer.setPosY(this.percentageY);
        RemindClockConfig.Client.Chronometer configChronometer = RemindClockConfig.CLIENT.chronometer;
        configChronometer.posX.set((Object)this.chronometer.getPosX());
        configChronometer.posY.set((Object)this.chronometer.getPosY());
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

