/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.screens.chronometer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.thomas7520.remindclockhud.object.Chronometer;
import com.thomas7520.remindclockhud.screens.chronometer.ChronometerPositionScreen;
import com.thomas7520.remindclockhud.util.ButtonDropDown;
import com.thomas7520.remindclockhud.util.ChronometerFormat;
import com.thomas7520.remindclockhud.util.HUDMode;
import com.thomas7520.remindclockhud.util.RemindClockConfig;
import com.thomas7520.remindclockhud.util.RemindClockUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChronometerScreen
extends Screen {
    private final Chronometer chronometer;
    private final String[] stateValues = new String[]{"text.red", "text.green", "text.blue", "text.alpha"};
    private ForgeSlider sliderRedText;
    private ForgeSlider sliderGreenText;
    private ForgeSlider sliderBlueText;
    private ForgeSlider sliderRGBText;
    private ForgeSlider sliderRedBackground;
    private ForgeSlider sliderGreenBackground;
    private ForgeSlider sliderBlueBackground;
    private ForgeSlider sliderRGBBackground;
    private final Screen lastScreen;
    private Button buttonWaveDirection;
    private Button buttonWaveDirectionBackground;
    private ButtonDropDown predefineFormatsButton;

    public ChronometerScreen(Screen lastScreen, Chronometer Chronometer2) {
        super((Component)Component.m_237115_((String)"chronometer.title"));
        this.lastScreen = lastScreen;
        this.chronometer = Chronometer2;
    }

    protected void m_7856_() {
        ArrayList<ButtonDropDown.Entry> formatEntries = new ArrayList<ButtonDropDown.Entry>();
        for (ChronometerFormat value : ChronometerFormat.values()) {
            formatEntries.add(new ButtonDropDown.Entry(value.name(), pEntry -> {
                this.chronometer.setFormat(ChronometerFormat.valueOf(pEntry.getName()));
                this.predefineFormatsButton.m_93666_((Component)Component.m_237110_((String)"chronometer.format", (Object[])new Object[]{value.name()}));
            }));
        }
        this.predefineFormatsButton = ButtonDropDown.builder((Component)Component.m_237110_((String)"chronometer.format", (Object[])new Object[]{this.chronometer.getFormat().name()})).bounds(0, 0, 154, 20).addEntries(formatEntries).build();
        Button displayMode = Button.m_253074_((Component)Component.m_237115_((String)"text.display_position"), pButton -> this.f_96541_.m_91152_((Screen)new ChronometerPositionScreen(this))).m_252987_(0, 0, 154, 20).m_253136_();
        Button rgbTextMode = Button.m_253074_((Component)Component.m_237110_((String)"text.text_mode", (Object[])new Object[]{this.chronometer.getRgbModeText().name()}), pButton -> {
            this.chronometer.setRgbModeText(this.getNextMode(this.chronometer.getRgbModeText()));
            this.sliderRGBText.f_93624_ = this.chronometer.getRgbModeText() == HUDMode.WAVE || this.chronometer.getRgbModeText() == HUDMode.CYCLE;
            this.buttonWaveDirection.f_93624_ = this.chronometer.getRgbModeText() == HUDMode.WAVE;
            pButton.m_93666_((Component)Component.m_237110_((String)"text.text_mode", (Object[])new Object[]{this.chronometer.getRgbModeText().name()}));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        Button rgbBackgroundMode = Button.m_253074_((Component)Component.m_237110_((String)"text.background_mode", (Object[])new Object[]{this.chronometer.getRgbModeBackground().name()}), pButton -> {
            this.chronometer.setRgbModeBackground(this.getNextMode(this.chronometer.getRgbModeBackground()));
            this.sliderRGBBackground.f_93624_ = this.chronometer.getRgbModeBackground() == HUDMode.WAVE || this.chronometer.getRgbModeBackground() == HUDMode.CYCLE;
            this.buttonWaveDirectionBackground.f_93624_ = this.chronometer.getRgbModeBackground() == HUDMode.WAVE;
            pButton.m_93666_((Component)Component.m_237110_((String)"text.background_mode", (Object[])new Object[]{this.chronometer.getRgbModeBackground().name()}));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        this.buttonWaveDirection = Button.m_253074_((Component)Component.m_237115_((String)(this.chronometer.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")), pButton -> {
            this.chronometer.setTextRightToLeftDirection(!this.chronometer.isTextRightToLeftDirection());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.chronometer.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")));
        }).m_252987_(0, 0, 100, 20).m_253136_();
        this.buttonWaveDirection.f_93624_ = this.chronometer.getRgbModeText() == HUDMode.WAVE;
        this.buttonWaveDirectionBackground = Button.m_253074_((Component)Component.m_237115_((String)(this.chronometer.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")), pButton -> {
            this.chronometer.setBackgroundRightToLeftDirection(!this.chronometer.isBackgroundRightToLeftDirection());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.chronometer.isBackgroundRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")));
        }).m_252987_(0, 0, 100, 20).m_253136_();
        this.buttonWaveDirectionBackground.f_93624_ = this.chronometer.getRgbModeBackground() == HUDMode.WAVE;
        Button buttonBackgroundState = Button.m_253074_((Component)Component.m_237115_((String)(this.chronometer.isDrawBackground() ? "text.disable_background" : "text.enable_background")), pButton -> {
            this.chronometer.setDrawBackground(!this.chronometer.isDrawBackground());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.chronometer.isDrawBackground() ? "text.disable_background" : "text.enable_background")));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        Button buttonIdleState = Button.m_253074_((Component)Component.m_237115_((String)(this.chronometer.isIdleRender() ? "chronometer.idle_off" : "chronometer.idle_on")), pButton -> {
            this.chronometer.setIdleRender(!this.chronometer.isIdleRender());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.chronometer.isIdleRender() ? "chronometer.idle_off" : "chronometer.idle_on")));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        int i = 1;
        this.sliderRedText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getRedText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedText.getValueInt() << 16 | ChronometerScreen.this.sliderGreenText.getValueInt() << 8 | ChronometerScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFF00FFFF, col1 | 0xFF0000, col1 & 0xFF00FFFF, col1 | 0xFF0000);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setRedText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderGreenText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getGreenText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedText.getValueInt() << 16 | ChronometerScreen.this.sliderGreenText.getValueInt() << 8 | ChronometerScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFF00FF, col1 | 0xFF00, col1 & 0xFFFF00FF, col1 | 0xFF00);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setGreenText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderBlueText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getBlueText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedText.getValueInt() << 16 | ChronometerScreen.this.sliderGreenText.getValueInt() << 8 | ChronometerScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFFFF00, col1 | 0xFF, col1 & 0xFFFFFF00, col1 | 0xFF);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setBlueText(this.getValueInt());
                super.m_5697_();
            }
        };
        ForgeSlider sliderAlphaText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)(100 * (this.chronometer.getAlphaText() - 25)) / 230.0, 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedText.getValueInt() << 16 | ChronometerScreen.this.sliderGreenText.getValueInt() << 8 | ChronometerScreen.this.sliderBlueText.getValueInt();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280398_(new ResourceLocation("remindclockhud", "textures/transparency.png"), this.m_252754_() + 1, this.m_252907_() + 1, 0, 0.0f, 0.0f, this.m_5711_() - 2, this.m_93694_() - 2, 10, 10);
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, rgb | 0x46000000, rgb | 0xFF000000, rgb | 0x46000000, rgb | 0xFF000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            public int getValueInt() {
                return (int)((float)super.getValueInt() / 100.0f * 230.0f + 25.0f);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setAlphaText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)"text.speed").getString() + " : ")), (Component)Component.m_237113_((String)"%"), 1.0, 100.0, this.chronometer.getRgbSpeedText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setRgbSpeedText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBText.f_93624_ = this.chronometer.getRgbModeText() == HUDMode.WAVE || this.chronometer.getRgbModeText() == HUDMode.CYCLE;
        i = 1;
        this.sliderRedBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getRedBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedBackground.getValueInt() << 16 | ChronometerScreen.this.sliderGreenBackground.getValueInt() << 8 | ChronometerScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFF00FFFF, col1 | 0xFF0000, col1 & 0xFF00FFFF, col1 | 0xFF0000);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setRedBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderGreenBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getGreenBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedBackground.getValueInt() << 16 | ChronometerScreen.this.sliderGreenBackground.getValueInt() << 8 | ChronometerScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFF00FF, col1 | 0xFF00, col1 & 0xFFFF00FF, col1 | 0xFF00);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setGreenBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderBlueBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.chronometer.getBlueBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedBackground.getValueInt() << 16 | ChronometerScreen.this.sliderGreenBackground.getValueInt() << 8 | ChronometerScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFFFF00, col1 | 0xFF, col1 & 0xFFFFFF00, col1 | 0xFF);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setBlueBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        ForgeSlider sliderAlphaBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)(100 * this.chronometer.getAlphaBackground()) / 255.0, 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ChronometerScreen.this.sliderRedBackground.getValueInt() << 16 | ChronometerScreen.this.sliderGreenBackground.getValueInt() << 8 | ChronometerScreen.this.sliderBlueBackground.getValueInt();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280398_(new ResourceLocation("remindclockhud", "textures/transparency.png"), this.m_252754_() + 1, this.m_252907_() + 1, 0, 0.0f, 0.0f, this.m_5711_() - 2, this.m_93694_() - 2, 10, 10);
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, rgb | 0x46000000, rgb | 0xFF000000, rgb | 0x46000000, rgb | 0xFF000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            public int getValueInt() {
                return (int)((float)super.getValueInt() / 100.0f * 255.0f);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setAlphaBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)"text.speed").getString() + " : ")), (Component)Component.m_237113_((String)"%"), 1.0, 100.0, this.chronometer.getRgbSpeedBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            }

            protected void m_5697_() {
                ChronometerScreen.this.chronometer.setRgbSpeedBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBBackground.f_93624_ = this.chronometer.getRgbModeBackground() == HUDMode.WAVE || this.chronometer.getRgbModeBackground() == HUDMode.CYCLE;
        GridLayout gridlayout = new GridLayout();
        gridlayout.m_264211_().m_264129_(4, 4, 4, 0);
        GridLayout.RowHelper gridlayout$rowhelper = gridlayout.m_264606_(3);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.predefineFormatsButton);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRedText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRedBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)displayMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderGreenText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderGreenBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)rgbTextMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderBlueText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderBlueBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)rgbBackgroundMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)sliderAlphaText);
        gridlayout$rowhelper.m_264139_((LayoutElement)sliderAlphaBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)buttonBackgroundState);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRGBText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRGBBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)buttonIdleState);
        gridlayout.m_264075_((LayoutElement)this.buttonWaveDirection, 5, 1, gridlayout.m_264211_());
        gridlayout.m_264075_((LayoutElement)this.buttonWaveDirectionBackground, 5, 2, gridlayout.m_264211_());
        gridlayout.m_264036_();
        FrameLayout.m_264460_((LayoutElement)gridlayout, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.5f, (float)0.5f);
        gridlayout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, p_280842_ -> {
            this.saveConfig();
            this.f_96541_.m_91152_(this.lastScreen);
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20).m_253136_());
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_282465_) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, p_282465_);
        String chronometerFormatted = this.chronometer.getFormat().formatTime(System.currentTimeMillis());
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 3, 0xFFFFFF);
        int x = this.f_96543_ / 2 - this.f_96547_.m_92895_(chronometerFormatted) / 2;
        int y = this.predefineFormatsButton.m_252907_() - 20;
        RemindClockUtil.drawChronometer(this.chronometer, chronometerFormatted, guiGraphics, this.f_96547_, x, y, this.f_96543_, this.f_96544_);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private HUDMode getNextMode(HUDMode currentOption) {
        HUDMode[] values = HUDMode.values();
        int currentIndex = currentOption.ordinal();
        int nextIndex = (currentIndex + 1) % values.length;
        return values[nextIndex];
    }

    public void m_7379_() {
        this.saveConfig();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    private void saveConfig() {
        RemindClockConfig.Client.Chronometer configChronometer = RemindClockConfig.CLIENT.chronometer;
        configChronometer.format.set((Object)this.chronometer.getFormat());
        configChronometer.drawBackground.set((Object)this.chronometer.isDrawBackground());
        configChronometer.rgbModeText.set((Object)this.chronometer.getRgbModeText());
        configChronometer.rgbModeBackground.set((Object)this.chronometer.getRgbModeBackground());
        configChronometer.redText.set((Object)this.chronometer.getRedText());
        configChronometer.greenText.set((Object)this.chronometer.getGreenText());
        configChronometer.blueText.set((Object)this.chronometer.getBlueText());
        configChronometer.alphaText.set((Object)this.chronometer.getAlphaText());
        configChronometer.rgbSpeedText.set((Object)this.chronometer.getRgbSpeedText());
        configChronometer.redBackground.set((Object)this.chronometer.getRedBackground());
        configChronometer.greenBackground.set((Object)this.chronometer.getGreenBackground());
        configChronometer.blueBackground.set((Object)this.chronometer.getBlueBackground());
        configChronometer.alphaBackground.set((Object)this.chronometer.getAlphaBackground());
        configChronometer.rgbSpeedBackground.set((Object)this.chronometer.getRgbSpeedBackground());
        configChronometer.textRightToLeftDirection.set((Object)this.chronometer.isTextRightToLeftDirection());
        configChronometer.backgroundRightToLeftDirection.set((Object)this.chronometer.isBackgroundRightToLeftDirection());
    }
}

