/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.screens.clock;

import com.mojang.blaze3d.systems.RenderSystem;
import com.thomas7520.remindclockhud.object.Clock;
import com.thomas7520.remindclockhud.screens.buttons.InformationButton;
import com.thomas7520.remindclockhud.screens.clock.ClockPositionScreen;
import com.thomas7520.remindclockhud.util.HUDMode;
import com.thomas7520.remindclockhud.util.RemindClockConfig;
import com.thomas7520.remindclockhud.util.RemindClockUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ClockScreen
extends Screen {
    private final Clock clock;
    private EditBox dateBox;
    private final String[] stateValues = new String[]{"text.red", "text.green", "text.blue", "text.alpha"};
    private ForgeSlider sliderRedText;
    private ForgeSlider sliderGreenText;
    private ForgeSlider sliderBlueText;
    private ForgeSlider sliderRGBText;
    private ForgeSlider sliderRedBackground;
    private ForgeSlider sliderGreenBackground;
    private ForgeSlider sliderBlueBackground;
    private ForgeSlider sliderRGBBackground;
    private final Screen lastScreen;
    private Button buttonWaveDirection;
    private Button buttonWaveDirectionBackground;

    public ClockScreen(Screen lastScreen, Clock clock) {
        super((Component)Component.m_237115_((String)"clock.title"));
        this.lastScreen = lastScreen;
        this.clock = clock;
    }

    protected void m_7856_() {
        this.dateBox = new EditBox(this.f_96547_, 0, 0, 151, 20, Component.m_130674_(null)){};
        this.dateBox.m_94190_(true);
        this.dateBox.m_94199_(100);
        this.dateBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"clock.date_format")));
        this.dateBox.m_94144_(this.clock.getFormatText());
        this.dateBox.m_94151_(newDate -> {
            this.clock.setFormatText((String)newDate);
            RemindClockConfig.CLIENT.clock.formatText.set(newDate);
        });
        Button formatHourButton = Button.m_253074_((Component)Component.m_237115_((String)(this.clock.isUse12HourFormat() ? "clock.formatters12" : "clock.formatters24")), pButton -> {
            this.clock.setUse12HourFormat(!this.clock.isUse12HourFormat());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.clock.isUse12HourFormat() ? "clock.formatters12" : "clock.formatters24")));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        Button displayMode = Button.m_253074_((Component)Component.m_237115_((String)"text.display_position"), pButton -> this.f_96541_.m_91152_((Screen)new ClockPositionScreen(this))).m_252987_(0, 0, 154, 20).m_253136_();
        Button rgbTextMode = Button.m_253074_((Component)Component.m_237110_((String)"text.text_mode", (Object[])new Object[]{this.clock.getRgbModeText().name()}), pButton -> {
            this.clock.setRgbModeText(this.getNextMode(this.clock.getRgbModeText()));
            this.sliderRGBText.f_93624_ = this.clock.getRgbModeText() == HUDMode.WAVE || this.clock.getRgbModeText() == HUDMode.CYCLE;
            this.buttonWaveDirection.f_93624_ = this.clock.getRgbModeText() == HUDMode.WAVE;
            pButton.m_93666_((Component)Component.m_237110_((String)"text.text_mode", (Object[])new Object[]{this.clock.getRgbModeText().name()}));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        Button rgbBackgroundMode = Button.m_253074_((Component)Component.m_237110_((String)"text.background_mode", (Object[])new Object[]{this.clock.getRgbModeBackground().name()}), pButton -> {
            this.clock.setRgbModeBackground(this.getNextMode(this.clock.getRgbModeBackground()));
            this.sliderRGBBackground.f_93624_ = this.clock.getRgbModeBackground() == HUDMode.WAVE || this.clock.getRgbModeBackground() == HUDMode.CYCLE;
            this.buttonWaveDirectionBackground.f_93624_ = this.clock.getRgbModeBackground() == HUDMode.WAVE;
            pButton.m_93666_((Component)Component.m_237110_((String)"text.background_mode", (Object[])new Object[]{this.clock.getRgbModeBackground().name()}));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        this.buttonWaveDirection = Button.m_253074_((Component)Component.m_237115_((String)(this.clock.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")), pButton -> {
            this.clock.setTextRightToLeftDirection(!this.clock.isTextRightToLeftDirection());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.clock.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")));
        }).m_252987_(0, 0, 100, 20).m_253136_();
        this.buttonWaveDirection.f_93624_ = this.clock.getRgbModeText() == HUDMode.WAVE;
        this.buttonWaveDirectionBackground = Button.m_253074_((Component)Component.m_237115_((String)(this.clock.isTextRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")), pButton -> {
            this.clock.setBackgroundRightToLeftDirection(!this.clock.isBackgroundRightToLeftDirection());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.clock.isBackgroundRightToLeftDirection() ? "text.direction_lr" : "text.direction_rl")));
        }).m_252987_(0, 0, 100, 20).m_253136_();
        this.buttonWaveDirectionBackground.f_93624_ = this.clock.getRgbModeBackground() == HUDMode.WAVE;
        Button buttonBackgroundState = Button.m_253074_((Component)Component.m_237115_((String)(this.clock.isDrawBackground() ? "text.disable_background" : "text.enable_background")), pButton -> {
            this.clock.setDrawBackground(!this.clock.isDrawBackground());
            pButton.m_93666_((Component)Component.m_237115_((String)(this.clock.isDrawBackground() ? "text.disable_background" : "text.enable_background")));
        }).m_252987_(0, 0, 154, 20).m_253136_();
        ArrayList<String> tooltipLines = new ArrayList<String>();
        tooltipLines.add(Component.m_237115_((String)"clock.available_formats").getString());
        tooltipLines.add("%hh");
        tooltipLines.add("%mm");
        tooltipLines.add("%ss");
        tooltipLines.add("%dd");
        tooltipLines.add("%day");
        tooltipLines.add("%sday");
        tooltipLines.add("%month");
        tooltipLines.add("%smonth");
        tooltipLines.add("%MM");
        tooltipLines.add("%yyyy");
        tooltipLines.add("%yy");
        tooltipLines.add("%state (AM/PM)");
        StringBuilder tooltip = new StringBuilder();
        for (String s : tooltipLines) {
            tooltip.append(s).append("\n");
        }
        int i = 1;
        this.sliderRedText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getRedText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedText.getValueInt() << 16 | ClockScreen.this.sliderGreenText.getValueInt() << 8 | ClockScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFF00FFFF, col1 | 0xFF0000, col1 & 0xFF00FFFF, col1 | 0xFF0000);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setRedText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderGreenText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getGreenText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedText.getValueInt() << 16 | ClockScreen.this.sliderGreenText.getValueInt() << 8 | ClockScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFF00FF, col1 | 0xFF00, col1 & 0xFFFF00FF, col1 | 0xFF00);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setGreenText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderBlueText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getBlueText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedText.getValueInt() << 16 | ClockScreen.this.sliderGreenText.getValueInt() << 8 | ClockScreen.this.sliderBlueText.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFFFF00, col1 | 0xFF, col1 & 0xFFFFFF00, col1 | 0xFF);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setBlueText(this.getValueInt());
                super.m_5697_();
            }
        };
        ForgeSlider sliderAlphaText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)(100 * (this.clock.getAlphaText() - 25)) / 230.0, 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedText.getValueInt() << 16 | ClockScreen.this.sliderGreenText.getValueInt() << 8 | ClockScreen.this.sliderBlueText.getValueInt();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280398_(new ResourceLocation("remindclockhud", "textures/transparency.png"), this.m_252754_() + 1, this.m_252907_() + 1, 0, 0.0f, 0.0f, this.m_5711_() - 2, this.m_93694_() - 2, 10, 10);
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, rgb | 0x46000000, rgb | 0xFF000000, rgb | 0x46000000, rgb | 0xFF000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            public int getValueInt() {
                return (int)((float)super.getValueInt() / 100.0f * 230.0f + 25.0f);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setAlphaText(this.getValueInt());
                super.m_5697_();
            }
        };
        ++i;
        this.sliderRGBText = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)"text.speed").getString() + " : ")), (Component)Component.m_237113_((String)"%"), 1.0, 100.0, this.clock.getRgbSpeedText(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setRgbSpeedText(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBText.f_93624_ = this.clock.getRgbModeText() == HUDMode.WAVE || this.clock.getRgbModeText() == HUDMode.CYCLE;
        i = 1;
        this.sliderRedBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getRedBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedBackground.getValueInt() << 16 | ClockScreen.this.sliderGreenBackground.getValueInt() << 8 | ClockScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFF00FFFF, col1 | 0xFF0000, col1 & 0xFF00FFFF, col1 | 0xFF0000);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setRedBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderGreenBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getGreenBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedBackground.getValueInt() << 16 | ClockScreen.this.sliderGreenBackground.getValueInt() << 8 | ClockScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFF00FF, col1 | 0xFF00, col1 & 0xFFFF00FF, col1 | 0xFF00);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setGreenBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderBlueBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237119_(), 0.0, 255.0, this.clock.getBlueBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedBackground.getValueInt() << 16 | ClockScreen.this.sliderGreenBackground.getValueInt() << 8 | ClockScreen.this.sliderBlueBackground.getValueInt();
                int col1 = rgb | 0xFF000000;
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, col1 & 0xFFFFFF00, col1 | 0xFF, col1 & 0xFFFFFF00, col1 | 0xFF);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setBlueBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        ForgeSlider sliderAlphaBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)this.stateValues[++i - 1]).getString() + " : ")), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)(100 * this.clock.getAlphaBackground()) / 255.0, 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_(), this.m_252907_(), 0, this.m_264355_(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
                int rgb = ClockScreen.this.sliderRedBackground.getValueInt() << 16 | ClockScreen.this.sliderGreenBackground.getValueInt() << 8 | ClockScreen.this.sliderBlueBackground.getValueInt();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280398_(new ResourceLocation("remindclockhud", "textures/transparency.png"), this.m_252754_() + 1, this.m_252907_() + 1, 0, 0.0f, 0.0f, this.m_5711_() - 2, this.m_93694_() - 2, 10, 10);
                RemindClockUtil.drawGradientRect(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, 0, rgb | 0x46000000, rgb | 0xFF000000, rgb | 0x46000000, rgb | 0xFF000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blitWithBorder(f_263683_, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, this.m_264270_(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
                this.m_280372_(guiGraphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }

            public int getValueInt() {
                return (int)((float)super.getValueInt() / 100.0f * 255.0f);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setAlphaBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBBackground = new ForgeSlider(0, 0, 100, 20, (Component)Component.m_237113_((String)(Component.m_237115_((String)"text.speed").getString() + " : ")), (Component)Component.m_237113_((String)"%"), 1.0, 100.0, this.clock.getRgbSpeedBackground(), 1.0, 1, true){

            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            }

            protected void m_5697_() {
                ClockScreen.this.clock.setRgbSpeedBackground(this.getValueInt());
                super.m_5697_();
            }
        };
        this.sliderRGBBackground.f_93624_ = this.clock.getRgbModeBackground() == HUDMode.WAVE || this.clock.getRgbModeBackground() == HUDMode.CYCLE;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, p_280842_ -> {
            this.saveConfig();
            this.f_96541_.m_91152_(this.lastScreen);
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20).m_253136_());
        GridLayout gridlayout = new GridLayout();
        gridlayout.m_264211_().m_264129_(4, 4, 4, 0);
        GridLayout.RowHelper gridlayout$rowhelper = gridlayout.m_264606_(3);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.dateBox);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRedText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRedBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)formatHourButton);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderGreenText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderGreenBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)displayMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderBlueText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderBlueBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)rgbTextMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)sliderAlphaText);
        gridlayout$rowhelper.m_264139_((LayoutElement)sliderAlphaBackground);
        gridlayout$rowhelper.m_264139_((LayoutElement)rgbBackgroundMode);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRGBText);
        gridlayout$rowhelper.m_264139_((LayoutElement)this.sliderRGBBackground);
        gridlayout.m_264075_((LayoutElement)buttonBackgroundState, 5, 0, gridlayout.m_264211_());
        gridlayout.m_264075_((LayoutElement)this.buttonWaveDirection, 5, 1, gridlayout.m_264211_());
        gridlayout.m_264075_((LayoutElement)this.buttonWaveDirectionBackground, 5, 2, gridlayout.m_264211_());
        gridlayout.m_264036_();
        FrameLayout.m_264460_((LayoutElement)gridlayout, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (float)0.5f, (float)0.5f);
        InformationButton informationButton = new InformationButton(this.dateBox.m_252754_() - 25, this.dateBox.m_252907_(), 20, 20, (Component)Component.m_237119_(), p_93751_ -> {}, Supplier::get);
        this.dateBox.m_252865_(this.dateBox.m_252754_() + 1);
        informationButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip.toString())));
        this.m_142416_((GuiEventListener)informationButton);
        gridlayout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        super.m_7856_();
    }

    public void m_86600_() {
        this.dateBox.m_94120_();
        super.m_86600_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float p_282465_) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, p_282465_);
        String dateFormatted = this.clock.getDateFormatted();
        this.dateBox.m_88315_(graphics, mouseX, mouseY, p_282465_);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 3, 0xFFFFFF);
        int x = this.f_96543_ / 2 - this.f_96547_.m_92895_(dateFormatted) / 2;
        int y = this.dateBox.m_252907_() - 20;
        RemindClockUtil.renderClock(this.clock, graphics, this.f_96547_, x, y, this.f_96543_, this.f_96544_);
    }

    public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
        if (!this.dateBox.m_5953_(p_94695_, p_94696_) && this.dateBox.m_93696_()) {
            this.dateBox.m_93692_(false);
        }
        return super.m_6375_(p_94695_, p_94696_, p_94697_);
    }

    private HUDMode getNextMode(HUDMode currentOption) {
        HUDMode[] values = HUDMode.values();
        int currentIndex = currentOption.ordinal();
        int nextIndex = (currentIndex + 1) % values.length;
        return values[nextIndex];
    }

    public void m_7379_() {
        this.saveConfig();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    private void saveConfig() {
        RemindClockConfig.Client.Clock configClock = RemindClockConfig.CLIENT.clock;
        configClock.formatText.set((Object)this.clock.getFormatText());
        configClock.drawBackground.set((Object)this.clock.isDrawBackground());
        configClock.use12HourFormat.set((Object)this.clock.isUse12HourFormat());
        configClock.rgbModeText.set((Object)this.clock.getRgbModeText());
        configClock.rgbModeBackground.set((Object)this.clock.getRgbModeBackground());
        configClock.redText.set((Object)this.clock.getRedText());
        configClock.greenText.set((Object)this.clock.getGreenText());
        configClock.blueText.set((Object)this.clock.getBlueText());
        configClock.alphaText.set((Object)this.clock.getAlphaText());
        configClock.rgbSpeedText.set((Object)this.clock.getRgbSpeedText());
        configClock.redBackground.set((Object)this.clock.getRedBackground());
        configClock.greenBackground.set((Object)this.clock.getGreenBackground());
        configClock.blueBackground.set((Object)this.clock.getBlueBackground());
        configClock.alphaBackground.set((Object)this.clock.getAlphaBackground());
        configClock.rgbSpeedBackground.set((Object)this.clock.getRgbSpeedBackground());
        configClock.textRightToLeftDirection.set((Object)this.clock.isTextRightToLeftDirection());
        configClock.backgroundRightToLeftDirection.set((Object)this.clock.isBackgroundRightToLeftDirection());
    }
}

