/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ButtonDropDown
extends AbstractButton {
    protected static final CreateNarration DEFAULT_NARRATION = Supplier::get;
    protected final CreateNarration createNarration;
    private final List<Entry> entries;
    protected boolean focused;

    public static Builder builder(Component pMessage) {
        return new Builder(pMessage);
    }

    protected ButtonDropDown(int pX, int pY, int pWidth, int pHeight, Component pMessage, List<Entry> entries, CreateNarration pCreateNarration) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.createNarration = pCreateNarration;
        this.entries = entries;
    }

    protected ButtonDropDown(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.entries, builder.createNarration);
        this.m_257544_(builder.tooltip);
    }

    protected MutableComponent m_5646_() {
        return this.createNarration.createNarrationMessage(() -> super.m_5646_());
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        this.m_168802_(pNarrationElementOutput);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean hovered;
        if (this.f_93622_) {
            this.focused = !this.focused;
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        boolean bl = hovered = pMouseX >= (double)this.m_252754_() && pMouseX <= (double)(this.m_252754_() + this.m_5711_()) && pMouseY >= (double)(this.m_252907_() + this.m_93694_()) && pMouseY <= (double)(this.m_252907_() + this.m_93694_() + 20 * this.entries.size());
        if (!hovered) {
            this.focused = false;
        } else if (this.focused) {
            int index = (int)Math.floor((pMouseY - (double)this.m_252907_() - (double)this.m_93694_()) / 20.0);
            this.entries.get(index).onPress();
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.focused = !this.focused;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_5691_() {
    }

    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        if (this.focused) {
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                boolean entryHovered = pMouseX >= this.m_252754_() && pMouseX <= this.m_252754_() + this.m_5711_() && pMouseY >= this.m_252907_() + this.m_93694_() + 20 * i && pMouseY <= this.m_252907_() + this.m_93694_() + 20 * (i + 1);
                pGuiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.m_93694_() + 20 * i, this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_() + 20 * (i + 1), entryHovered ? Color.WHITE.getRGB() : -6250336);
                pGuiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + this.m_93694_() + 20 * i + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() + 20 * (i + 1) - 1, -16777216);
                ButtonDropDown.m_280138_((GuiGraphics)pGuiGraphics, (Font)minecraft.f_91062_, (Component)Component.m_237113_((String)entry.getName()), (int)(this.m_252754_() + 2), (int)(this.m_252907_() + this.m_93694_() + 10 + 20 * i - 5), (int)(this.m_252754_() + this.m_5711_() - 2), (int)(this.m_252907_() + this.m_93694_() + 10 + 20 * i + 3), (int)Color.WHITE.getRGB());
            }
        }
        pGuiGraphics.m_280168_().m_85849_();
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private int m_274533_() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 26 + i * 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private CreateNarration createNarration = DEFAULT_NARRATION;
        private List<Entry> entries;

        public Builder(Component pMessage) {
            this.message = pMessage;
        }

        public Builder pos(int pX, int pY) {
            this.x = pX;
            this.y = pY;
            return this;
        }

        public Builder width(int pWidth) {
            this.width = pWidth;
            return this;
        }

        public Builder size(int pWidth, int pHeight) {
            this.width = pWidth;
            this.height = pHeight;
            return this;
        }

        public Builder bounds(int pX, int pY, int pWidth, int pHeight) {
            return this.pos(pX, pY).size(pWidth, pHeight);
        }

        public Builder tooltip(@Nullable Tooltip pTooltip) {
            this.tooltip = pTooltip;
            return this;
        }

        public Builder createNarration(CreateNarration pCreateNarration) {
            this.createNarration = pCreateNarration;
            return this;
        }

        public Builder addEntries(List<Entry> entries) {
            this.entries = entries;
            return this;
        }

        public ButtonDropDown build() {
            return this.build(ButtonDropDown::new);
        }

        public ButtonDropDown build(Function<Builder, ButtonDropDown> builder) {
            return builder.apply(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CreateNarration {
        public MutableComponent createNarrationMessage(Supplier<MutableComponent> var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry {
        private final OnEntryPress onPress;
        private final String name;

        public Entry(String name, OnEntryPress entryPress) {
            this.name = name;
            this.onPress = entryPress;
        }

        public String getName() {
            return this.name;
        }

        public void onPress() {
            this.onPress.onPress(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnEntryPress {
        public void onPress(Entry var1);
    }
}

