/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.util;

import com.thomas7520.remindclockhud.util.ChronometerFormat;
import com.thomas7520.remindclockhud.util.HUDMode;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class RemindClockConfig {
    public static final String CLOCK_CATEGORY = "clock";
    public static final String CHRONOMETER_CATEGORY = "chronometer";
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public Clock clock = new Clock();
        public Chronometer chronometer = new Chronometer();

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Clock settings").push(RemindClockConfig.CLOCK_CATEGORY);
            this.clock.enable = builder.comment("Enable chronometer").define("enable", true);
            this.clock.formatText = builder.comment("Clock format.").define("formatText", (Object)"%day %dd %smonth %yyyy %hh:%mm:%ss");
            this.clock.drawBackground = builder.comment("Allow to draw background for text.").define("drawBackground", true);
            this.clock.use12HourFormat = builder.comment("Use 12 hour format or 24 format.").define("use12HourFormat", false);
            this.clock.rgbModeText = builder.comment("RGB Mode Text (Static, Wave, Cycle)").defineEnum("rgbModeText", (Enum)HUDMode.STATIC);
            this.clock.rgbModeBackground = builder.comment("RGB Mode Background (Static, Wave, Cycle)").defineEnum("rgbModeBackground", (Enum)HUDMode.STATIC);
            this.clock.redText = builder.defineInRange("redText", 255, 0, 255);
            this.clock.greenText = builder.defineInRange("greenText", 255, 0, 255);
            this.clock.blueText = builder.defineInRange("blueText", 255, 0, 255);
            this.clock.alphaText = builder.defineInRange("alphaText", 186, 0, 255);
            this.clock.rgbSpeedText = builder.defineInRange("rgbSpeedText", 50, 0, 100);
            this.clock.redBackground = builder.defineInRange("redBackground", 140, 0, 255);
            this.clock.greenBackground = builder.defineInRange("greenBackground", 255, 0, 255);
            this.clock.blueBackground = builder.defineInRange("blueBackground", 255, 0, 255);
            this.clock.alphaBackground = builder.defineInRange("alphaBackground", 100, 0, 255);
            this.clock.rgbSpeedBackground = builder.defineInRange("rgbSpeedBackground", 50, 0, 100);
            this.clock.textRightToLeftDirection = builder.define("textRightToLeftDirection", false);
            this.clock.backgroundRightToLeftDirection = builder.define("backgroundRightToLeftDirection", false);
            this.clock.posX = builder.comment("Value of x screen in percentage.").defineInRange("posX", 0.0, 0.0, 100.0);
            this.clock.posY = builder.comment("Value of y screen in percentage.").defineInRange("posY", 0.0, 0.0, 100.0);
            builder.pop();
            builder.comment("Chronometer settings").push(RemindClockConfig.CHRONOMETER_CATEGORY);
            this.chronometer.enable = builder.comment("Enable chronometer").define("enable", true);
            this.chronometer.format = builder.comment("Chronometer format.").defineEnum("format", (Enum)ChronometerFormat.SS_MS);
            this.chronometer.drawBackground = builder.comment("Allow to draw background for text.").define("drawBackground", true);
            this.chronometer.rgbModeText = builder.comment("RGB Mode Text (Static, Wave, Cycle)").defineEnum("rgbModeText", (Enum)HUDMode.STATIC);
            this.chronometer.rgbModeBackground = builder.comment("RGB Mode Background (Static, Wave, Cycle)").defineEnum("rgbModeBackground", (Enum)HUDMode.STATIC);
            this.chronometer.redText = builder.defineInRange("redText", 255, 0, 255);
            this.chronometer.greenText = builder.defineInRange("greenText", 255, 0, 255);
            this.chronometer.blueText = builder.defineInRange("blueText", 255, 0, 255);
            this.chronometer.alphaText = builder.defineInRange("alphaText", 186, 0, 255);
            this.chronometer.rgbSpeedText = builder.defineInRange("rgbSpeedText", 50, 0, 100);
            this.chronometer.redBackground = builder.defineInRange("redBackground", 140, 0, 255);
            this.chronometer.greenBackground = builder.defineInRange("greenBackground", 255, 0, 255);
            this.chronometer.blueBackground = builder.defineInRange("blueBackground", 255, 0, 255);
            this.chronometer.alphaBackground = builder.defineInRange("alphaBackground", 100, 0, 255);
            this.chronometer.rgbSpeedBackground = builder.defineInRange("rgbSpeedBackground", 50, 0, 100);
            this.chronometer.textRightToLeftDirection = builder.define("textRightToLeftDirection", false);
            this.chronometer.backgroundRightToLeftDirection = builder.define("backgroundRightToLeftDirection", false);
            this.chronometer.idleRender = builder.comment("Enable chronometer render when it is idle.").define("idleRender", false);
            this.chronometer.posX = builder.comment("Value of x screen in percentage.").defineInRange("posX", 0.0, 0.0, 100.0);
            this.chronometer.posY = builder.comment("Value of y screen in percentage.").defineInRange("posY", 47.45, 0.0, 100.0);
        }

        public static class Clock {
            public ForgeConfigSpec.BooleanValue enable;
            public ForgeConfigSpec.ConfigValue<String> formatText;
            public ForgeConfigSpec.BooleanValue drawBackground;
            public ForgeConfigSpec.BooleanValue use12HourFormat;
            public ForgeConfigSpec.EnumValue<HUDMode> rgbModeText;
            public ForgeConfigSpec.EnumValue<HUDMode> rgbModeBackground;
            public ForgeConfigSpec.IntValue redText;
            public ForgeConfigSpec.IntValue greenText;
            public ForgeConfigSpec.IntValue blueText;
            public ForgeConfigSpec.IntValue alphaText;
            public ForgeConfigSpec.IntValue rgbSpeedText;
            public ForgeConfigSpec.IntValue redBackground;
            public ForgeConfigSpec.IntValue greenBackground;
            public ForgeConfigSpec.IntValue blueBackground;
            public ForgeConfigSpec.IntValue alphaBackground;
            public ForgeConfigSpec.IntValue rgbSpeedBackground;
            public ForgeConfigSpec.BooleanValue textRightToLeftDirection;
            public ForgeConfigSpec.BooleanValue backgroundRightToLeftDirection;
            public ForgeConfigSpec.DoubleValue posX;
            public ForgeConfigSpec.DoubleValue posY;
        }

        public static class Chronometer {
            public ForgeConfigSpec.BooleanValue enable;
            public ForgeConfigSpec.EnumValue<ChronometerFormat> format;
            public ForgeConfigSpec.BooleanValue drawBackground;
            public ForgeConfigSpec.EnumValue<HUDMode> rgbModeText;
            public ForgeConfigSpec.EnumValue<HUDMode> rgbModeBackground;
            public ForgeConfigSpec.IntValue redText;
            public ForgeConfigSpec.IntValue greenText;
            public ForgeConfigSpec.IntValue blueText;
            public ForgeConfigSpec.IntValue alphaText;
            public ForgeConfigSpec.IntValue rgbSpeedText;
            public ForgeConfigSpec.IntValue redBackground;
            public ForgeConfigSpec.IntValue greenBackground;
            public ForgeConfigSpec.IntValue blueBackground;
            public ForgeConfigSpec.IntValue alphaBackground;
            public ForgeConfigSpec.IntValue rgbSpeedBackground;
            public ForgeConfigSpec.BooleanValue textRightToLeftDirection;
            public ForgeConfigSpec.BooleanValue backgroundRightToLeftDirection;
            public ForgeConfigSpec.BooleanValue idleRender;
            public ForgeConfigSpec.DoubleValue posX;
            public ForgeConfigSpec.DoubleValue posY;
        }
    }
}

