/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.remindclockhud.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.thomas7520.remindclockhud.RemindClockHUD;
import com.thomas7520.remindclockhud.object.Alarm;
import com.thomas7520.remindclockhud.object.Chronometer;
import com.thomas7520.remindclockhud.object.Clock;
import com.thomas7520.remindclockhud.object.Remind;
import com.thomas7520.remindclockhud.util.HUDMode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.apache.commons.lang3.LocaleUtils;

public class RemindClockUtil {
    public static final int RECT_HEIGHT = 12;
    public static final int TEXT_X = 2;
    public static final int TEXT_Y = 2;
    public static float waveCounterClockBackground;
    public static float waveCounterClockText;
    public static float waveCounterChronometerBackground;
    public static float waveCounterChronometerText;
    public static KeyMapping guiBind;
    public static KeyMapping switchChronometerBind;
    public static KeyMapping addLapsBind;
    public static KeyMapping resetChronometerBind;
    public static KeyMapping stopAlarm;
    private static final List<Remind> reminds;
    private static final HashMap<UUID, Alarm> alarms;
    private static final HashMap<UUID, Alarm> serverAlarms;

    public static List<Remind> getReminds() {
        return reminds;
    }

    public static HashMap<UUID, Alarm> getAlarms() {
        return alarms;
    }

    public static HashMap<UUID, Alarm> getServerAlarms() {
        return serverAlarms;
    }

    public static void circleDoubleProgress(int x, int y, float radius, float radiusDouble, float progress, float initialDegree, int segment, Color color) {
        float a = 360.0f / (float)segment;
        double osin = 0.0;
        double ocos = 0.0;
        Tesselator tessellator = Tesselator.m_85913_();
        tessellator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        for (int i = 0; i <= segment; ++i) {
            float b = a * (float)i;
            double degree = b < progress ? (double)(initialDegree + b) * Math.PI / 180.0 : (double)(initialDegree + progress) * Math.PI / 180.0;
            double sin = Math.sin(-degree);
            double cos = Math.cos(-degree);
            tessellator.m_85915_().m_5483_((double)((float)((double)x + osin * (double)radius)), (double)((float)((double)y + ocos * (double)radius)), 0.0).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            tessellator.m_85915_().m_5483_((double)((float)((double)x + osin * (double)radiusDouble)), (double)((float)((double)y + ocos * (double)radiusDouble)), 0.0).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            tessellator.m_85915_().m_5483_((double)((float)((double)x + sin * (double)radiusDouble)), (double)((float)((double)y + cos * (double)radiusDouble)), 0.0).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            tessellator.m_85915_().m_5483_((double)((float)((double)x + sin * (double)radius)), (double)((float)((double)y + cos * (double)radius)), 0.0).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            osin = sin;
            ocos = cos;
            if (b > progress) break;
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderClock(Clock clock, GuiGraphics guiGraphics, Font font, double x, double y, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172811_);
        String dateFormatted = clock.getDateFormatted();
        int rectWidth = font.m_92895_(dateFormatted) + 3;
        x = Math.max(0.0, x);
        x = Math.min((double)(width - rectWidth), x);
        y = Math.max(y, 0.0);
        y = Math.min(y, (double)(height - 12));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(x, y, 0.0);
        if (clock.isDrawBackground()) {
            if (clock.getRgbModeBackground() == HUDMode.WAVE) {
                for (int i = 0; i < rectWidth; ++i) {
                    float hueStart = 1.0f - ((float)i - waveCounterClockBackground) / 360.0f;
                    float hueEnd = 1.0f - ((float)(i + 1) - waveCounterClockBackground) / 360.0f;
                    if (clock.isBackgroundRightToLeftDirection()) {
                        hueStart = ((float)i + waveCounterClockBackground) / 360.0f;
                        hueEnd = ((float)(i + 4) + waveCounterClockBackground) / 360.0f;
                    }
                    int colorStart = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
                    int colorEnd = Color.HSBtoRGB(hueEnd, 1.0f, 1.0f);
                    colorStart = colorStart & 0xFFFFFF | clock.getAlphaBackground() << 24;
                    colorEnd = colorEnd & 0xFFFFFF | clock.getAlphaBackground() << 24;
                    RemindClockUtil.drawGradientRect(x + (double)i, y, x + (double)i + 1.0, y + 12.0, 0, colorStart, colorEnd, colorStart, colorEnd);
                }
            } else if (clock.getRgbModeBackground() == HUDMode.CYCLE) {
                float hueStart = 1.0f - waveCounterClockBackground / 360.0f;
                if (clock.isBackgroundRightToLeftDirection()) {
                    hueStart = waveCounterClockBackground / 360.0f;
                }
                float hueEnd = hueStart;
                int colorStart = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
                int colorEnd = Color.HSBtoRGB(hueEnd, 1.0f, 1.0f);
                colorStart = colorStart & 0xFFFFFF | clock.getAlphaBackground() << 24;
                colorEnd = colorEnd & 0xFFFFFF | clock.getAlphaBackground() << 24;
                RemindClockUtil.drawGradientRect(x, y, x + (double)rectWidth, y + 12.0, 0, colorStart, colorStart, colorEnd, colorEnd);
            } else {
                int colorBackground = clock.getAlphaBackground() << 24 | clock.getRedBackground() << 16 | clock.getGreenBackground() << 8 | clock.getBlueBackground();
                guiGraphics.m_280509_(0, -2, rectWidth, 12, colorBackground);
            }
        }
        if (clock.getRgbModeText() == HUDMode.WAVE) {
            int textCharX = 2;
            for (int i = 0; i < dateFormatted.length(); ++i) {
                char c = dateFormatted.charAt(i);
                int color = RemindClockUtil.getFadeClockColor(dateFormatted, i);
                guiGraphics.m_280056_(font, String.valueOf(c), textCharX, 2, color, false);
                textCharX += font.m_92895_(String.valueOf(c));
            }
        } else if (clock.getRgbModeText() == HUDMode.CYCLE) {
            float hueStart = 1.0f - waveCounterClockText / 255.0f;
            if (clock.isTextRightToLeftDirection()) {
                hueStart = waveCounterClockText / 255.0f;
            }
            int color = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
            color = color & 0xFFFFFF | clock.getAlphaText() << 24;
            guiGraphics.m_280056_(font, dateFormatted, 2, 2, color, false);
        } else {
            int colorText = clock.getAlphaText() << 24 | clock.getRedText() << 16 | clock.getGreenText() << 8 | clock.getBlueText();
            guiGraphics.m_280056_(font, dateFormatted, 2, 2, colorText, false);
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    public static void drawChronometer(Chronometer chronometer, String chronometerFormatted, GuiGraphics guiGraphics, Font font, double x, double y, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172811_);
        int rectWidth = font.m_92895_(chronometerFormatted) + 3;
        x -= (double)(font.m_92895_(chronometerFormatted) - font.m_92895_(chronometer.getFormat().formatTime(System.currentTimeMillis()))) / 2.0;
        x = Math.max(0.0, x);
        x = Math.min((double)(width - rectWidth), x);
        y = Math.max(y, 0.0);
        y = Math.min(y, (double)(height - 12));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(x, y, 0.0);
        if (chronometer.isDrawBackground()) {
            if (chronometer.getRgbModeBackground() == HUDMode.WAVE) {
                for (int i = 0; i < rectWidth; ++i) {
                    float hueStart = 1.0f - ((float)i - waveCounterChronometerBackground) / 360.0f;
                    float hueEnd = 1.0f - ((float)(i + 1) - waveCounterChronometerBackground) / 360.0f;
                    if (chronometer.isBackgroundRightToLeftDirection()) {
                        hueStart = ((float)i + waveCounterChronometerBackground) / 360.0f;
                        hueEnd = ((float)(i + 4) + waveCounterChronometerBackground) / 360.0f;
                    }
                    int colorStart = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
                    int colorEnd = Color.HSBtoRGB(hueEnd, 1.0f, 1.0f);
                    colorStart = colorStart & 0xFFFFFF | chronometer.getAlphaBackground() << 24;
                    colorEnd = colorEnd & 0xFFFFFF | chronometer.getAlphaBackground() << 24;
                    RemindClockUtil.drawGradientRect(x + (double)i, y, x + (double)i + 1.0, y + 12.0, 0, colorStart, colorEnd, colorStart, colorEnd);
                }
            } else if (chronometer.getRgbModeBackground() == HUDMode.CYCLE) {
                float hueStart = 1.0f - waveCounterChronometerBackground / 360.0f;
                if (chronometer.isBackgroundRightToLeftDirection()) {
                    hueStart = waveCounterChronometerBackground / 360.0f;
                }
                float hueEnd = hueStart;
                int colorStart = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
                int colorEnd = Color.HSBtoRGB(hueEnd, 1.0f, 1.0f);
                colorStart = colorStart & 0xFFFFFF | chronometer.getAlphaBackground() << 24;
                colorEnd = colorEnd & 0xFFFFFF | chronometer.getAlphaBackground() << 24;
                RemindClockUtil.drawGradientRect(x, y, x + (double)rectWidth, y + 12.0, 0, colorStart, colorStart, colorEnd, colorEnd);
            } else {
                int colorBackground = chronometer.getAlphaBackground() << 24 | chronometer.getRedBackground() << 16 | chronometer.getGreenBackground() << 8 | chronometer.getBlueBackground();
                guiGraphics.m_280509_(0, -2, rectWidth, 12, colorBackground);
            }
        }
        if (chronometer.getRgbModeText() == HUDMode.WAVE) {
            int textCharX = 2;
            for (int i = 0; i < chronometerFormatted.length(); ++i) {
                char c = chronometerFormatted.charAt(i);
                int color = RemindClockUtil.getFadeChronometerColor(chronometerFormatted, i);
                guiGraphics.m_280056_(font, String.valueOf(c), textCharX, 2, color, false);
                textCharX += font.m_92895_(String.valueOf(c));
            }
        } else if (chronometer.getRgbModeText() == HUDMode.CYCLE) {
            float hueStart = 1.0f - waveCounterChronometerText / 255.0f;
            if (chronometer.isTextRightToLeftDirection()) {
                hueStart = waveCounterChronometerText / 255.0f;
            }
            int color = Color.HSBtoRGB(hueStart, 1.0f, 1.0f);
            color = color & 0xFFFFFF | chronometer.getAlphaText() << 24;
            guiGraphics.m_280056_(font, chronometerFormatted, 2, 2, color, false);
        } else {
            int colorText = chronometer.getAlphaText() << 24 | chronometer.getRedText() << 16 | chronometer.getGreenText() << 8 | chronometer.getBlueText();
            guiGraphics.m_280056_(font, chronometerFormatted, 2, 2, colorText, false);
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(double left, double top, double right, double bottom, int z, int coltl, int coltr, int colbl, int colbr) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        Tesselator tesselator = Tesselator.m_85913_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_(right, top, (double)z).m_6122_((coltr & 0xFF0000) >> 16, (coltr & 0xFF00) >> 8, coltr & 0xFF, (coltr & 0xFF000000) >>> 24).m_5752_();
        buffer.m_5483_(left, top, (double)z).m_6122_((coltl & 0xFF0000) >> 16, (coltl & 0xFF00) >> 8, coltl & 0xFF, (coltl & 0xFF000000) >>> 24).m_5752_();
        buffer.m_5483_(left, bottom, (double)z).m_6122_((colbl & 0xFF0000) >> 16, (colbl & 0xFF00) >> 8, colbl & 0xFF, (colbl & 0xFF000000) >>> 24).m_5752_();
        buffer.m_5483_(right, bottom, (double)z).m_6122_((colbr & 0xFF0000) >> 16, (colbr & 0xFF00) >> 8, colbr & 0xFF, (colbr & 0xFF000000) >>> 24).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    private static int getFadeClockColor(String dateFormatted, int i) {
        float hue = 1.0f - ((float)(dateFormatted.length() - i) + waveCounterClockText) * 2.0f / 360.0f;
        if (RemindClockHUD.getClock().isTextRightToLeftDirection()) {
            hue = ((float)(dateFormatted.length() + i) + waveCounterClockText) * 2.0f / 360.0f;
        }
        float saturation = 1.0f;
        float brightness = 1.0f;
        int color = Color.HSBtoRGB(hue, saturation, brightness);
        color = color & 0xFFFFFF | RemindClockHUD.getClock().getAlphaText() << 24;
        return color;
    }

    private static int getFadeChronometerColor(String chornometerFormatted, int i) {
        float hue = 1.0f - ((float)(chornometerFormatted.length() - i) + waveCounterChronometerText) * 2.0f / 360.0f;
        if (RemindClockHUD.getClock().isTextRightToLeftDirection()) {
            hue = ((float)(chornometerFormatted.length() + i) + waveCounterChronometerText) * 2.0f / 360.0f;
        }
        float saturation = 1.0f;
        float brightness = 1.0f;
        int color = Color.HSBtoRGB(hue, saturation, brightness);
        color = color & 0xFFFFFF | RemindClockHUD.getChronometer().getAlphaText() << 24;
        return color;
    }

    public static Locale getMinecraftLocalLanguage() {
        String language = Minecraft.m_91087_().f_91066_.f_92075_;
        String lastTwoChars = language.substring(language.length() - 2).toUpperCase();
        String result = language.substring(0, language.length() - 2) + lastTwoChars;
        return Optional.of(LocaleUtils.toLocale((String)result)).orElse(Locale.getDefault());
    }

    static {
        reminds = new ArrayList<Remind>();
        alarms = new HashMap();
        serverAlarms = new HashMap();
    }
}

