/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="slotmachinemod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> VALID_GAMBLING_ITEM = BUILDER.comment("A list of items to allow being gambled with, you can have a max total of 9 different items!").defineListAllowEmpty("valid_gambling_items", List.of("minecraft:emerald"), Config::validateItemName);
    private static final ForgeConfigSpec.ConfigValue<Double> WIN_CHANCE_2 = BUILDER.comment("Percentage that 2 of the same will occur in the slot machine [0.1 = 10%, 1.0 = 100%] (Range: 0.0 - 1.0)").define("double_win_chance", (Object)0.2, Config::validateDouble);
    private static final ForgeConfigSpec.ConfigValue<Double> WIN_CHANCE_3 = BUILDER.comment("Percentage that 3 of the same will occur in the slot machine [0.1 = 10%, 1.0 = 100%] (Range: 0.0 - 1.0)").define("triple_win_chance", (Object)0.1, Config::validateDouble);
    private static final ForgeConfigSpec.ConfigValue<Integer> DOUBLE_PAYOUT_AMOUNT = BUILDER.comment("Set the amount of items you return when you have 2 of the same in the slots machine. (Valid Range: 1 - 8)").define("double_payout_amount", (Object)2, Config::validateIntegerMax8);
    private static final ForgeConfigSpec.ConfigValue<Integer> TRIPLE_PAYOUT_AMOUNT = BUILDER.comment("Set the amount of items you return when you have 3 of the same in the slots machine. Note that setting this will prevent spinning the slot machine when the output slot + this value is more then the stack limit! Also keep this value higher than double_payout_amount (Valid Range: 1 - 16)").define("triple_payout_amount", (Object)3, Config::validateIntegerMax16);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static Set<Item> validBetItems;
    public static double tripleWinChance;
    public static double doubleWinChance;
    public static int triplePayoutAmount;
    public static int doublePayoutAmount;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    private static boolean validateDouble(Object obj) {
        Double d;
        return obj instanceof Double && (d = (Double)obj) >= 0.0 && d <= 1.0;
    }

    private static boolean validateIntegerMax8(Object obj) {
        Integer d;
        return obj instanceof Integer && (d = (Integer)obj) >= 1 && d <= 8;
    }

    private static boolean validateIntegerMax16(Object obj) {
        Integer d;
        return obj instanceof Integer && (d = (Integer)obj) >= 1 && d <= 16;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        validBetItems = ((List)VALID_GAMBLING_ITEM.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).limit(9L).collect(Collectors.toSet());
        tripleWinChance = (Double)WIN_CHANCE_3.get();
        doubleWinChance = (Double)WIN_CHANCE_2.get();
        triplePayoutAmount = (Integer)TRIPLE_PAYOUT_AMOUNT.get();
        doublePayoutAmount = (Integer)DOUBLE_PAYOUT_AMOUNT.get();
    }
}

