/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine;

import com.mojang.logging.LogUtils;
import net.micaxs.slotmachine.Config;
import net.micaxs.slotmachine.block.ModBlocks;
import net.micaxs.slotmachine.block.ModItems;
import net.micaxs.slotmachine.block.entity.ModBlockEntities;
import net.micaxs.slotmachine.network.PacketHandler;
import net.micaxs.slotmachine.screen.ModMenuTypes;
import net.micaxs.slotmachine.screen.SlotMachineOwnerScreen;
import net.micaxs.slotmachine.screen.SlotMachineScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="slotmachinemod")
public class SlotMachineMod {
    public static final String MOD_ID = "slotmachinemod";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SlotMachineMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModBlocks.SLOT_MACHINE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="slotmachinemod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SLOT_MACHINE_MENU.get()), SlotMachineScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SLOT_MACHINE_OWNER_MENU.get()), SlotMachineOwnerScreen::new);
        }
    }
}

