/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine.block;

import net.micaxs.slotmachine.block.entity.ModBlockEntities;
import net.micaxs.slotmachine.block.entity.SlotMachineBlockEntity;
import net.micaxs.slotmachine.screen.SlotMachineOwnerMenuProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SlotMachineBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)29.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public SlotMachineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SlotMachineBlockEntity(blockPos, blockState);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (entity instanceof ServerPlayer && (blockEntity = world.m_7702_(pos)) instanceof SlotMachineBlockEntity) {
            ((SlotMachineBlockEntity)blockEntity).setOwner(entity.m_20148_());
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof SlotMachineBlockEntity) {
                SlotMachineBlockEntity slotMachineBlockEntity = (SlotMachineBlockEntity)blockEntity;
                if (pPlayer.m_6047_() && slotMachineBlockEntity.getOwner().equals(pPlayer.m_20148_())) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)new SlotMachineOwnerMenuProvider(slotMachineBlockEntity), (BlockPos)pPos);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)slotMachineBlockEntity, (BlockPos)pPos);
                }
            } else {
                throw new IllegalStateException("Container provider went yeet?");
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity _te = world.m_7702_(pos);
        if (!(_te instanceof SlotMachineBlockEntity)) {
            return;
        }
        SlotMachineBlockEntity te = (SlotMachineBlockEntity)_te;
        if (te.getOwner().equals(player.m_20148_()) && player.m_6144_()) {
            te.dropSlotsMachine(player, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return SlotMachineBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SLOT_MACHINE_BE.get()), (level, blockPos, blockState, pBlockEntity) -> pBlockEntity.tick(level, blockPos, blockState, pBlockEntity));
    }
}

