/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.slotmachine.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.micaxs.slotmachine.network.PacketHandler;
import net.micaxs.slotmachine.network.packet.SlotsC2SPacket;
import net.micaxs.slotmachine.screen.SlotMachineMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SlotMachineScreen
extends AbstractContainerScreen<SlotMachineMenu> {
    private long lastClickTime = 0L;
    private static final long COOLDOWN = 1000L;
    private static final ResourceLocation TEXTURE = new ResourceLocation("slotmachinemod", "textures/gui/slot_machine_gui.png");
    private int[] results = new int[3];
    private Button spinButton;
    private Button stopButton;
    private String message = "";
    private boolean outOfService;
    private ResourceLocation[] lastImages = new ResourceLocation[3];

    public SlotMachineScreen(SlotMachineMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.results = new int[]{6, 6, 6};
        if (SlotMachineMenu.blockEntity.isSlotMachineInventoryFull()) {
            this.outOfService = true;
            this.message = "Out of Order";
        } else {
            this.outOfService = false;
            this.message = "";
        }
        if (!this.outOfService) {
            this.spinButton = new Button.Builder((Component)Component.m_237115_((String)"slots.gui.spin"), pButton -> {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime < 1000L) {
                    return;
                }
                this.lastClickTime = currentTime;
                PacketHandler.sendToServer(new SlotsC2SPacket(SlotMachineMenu.blockEntity.m_58899_(), true));
                this.results = new int[]{0, 0, 0};
            }).m_252794_(x + 64, y + 68).m_253046_(44, 11).m_253136_();
            this.stopButton = new Button.Builder((Component)Component.m_237115_((String)"slots.gui.stop"), pButton -> PacketHandler.sendToServer(new SlotsC2SPacket(SlotMachineMenu.blockEntity.m_58899_(), false))).m_252794_(x + 64, y + 68).m_253046_(44, 11).m_253136_();
            this.m_142416_((GuiEventListener)this.spinButton);
            this.m_142416_((GuiEventListener)this.stopButton);
        }
    }

    public void updateResults(int[] newResults) {
        this.results = newResults;
        this.message = this.getResultMessage();
    }

    private String getResultMessage() {
        if (this.results[0] == this.results[1] && this.results[1] == this.results[2]) {
            if (this.results[0] != 6 && this.results[0] != 0) {
                return "You won!";
            }
            return "";
        }
        if (this.results[0] != this.results[1] && this.results[1] != this.results[2] && this.results[0] != this.results[2]) {
            return "You lost!";
        }
        return "2 out of 3!";
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.outOfService) {
            if (this.results[0] != 0 && this.results[1] != 0 && this.results[2] != 0) {
                this.drawSlotImageInSlot(guiGraphics, x + 59, y + 21, this.results[0]);
                this.drawSlotImageInSlot(guiGraphics, x + 78, y + 21, this.results[1]);
                this.drawSlotImageInSlot(guiGraphics, x + 97, y + 21, this.results[2]);
            } else {
                this.renderSlotWheels(guiGraphics, x, y);
            }
        }
    }

    private void renderSlotWheels(GuiGraphics guiGraphics, int x, int y) {
        SlotMachineMenu menu = (SlotMachineMenu)this.f_97732_;
        if (!this.areResutlsInYet()) {
            this.drawRandomImage(guiGraphics, x + 59, y + 21);
            this.drawRandomImage(guiGraphics, x + 78, y + 21);
            this.drawRandomImage(guiGraphics, x + 97, y + 21);
        }
    }

    private ResourceLocation drawSlotImageInSlot(GuiGraphics guiGraphics, int x, int y, int slotImage) {
        List<ResourceLocation> images = Arrays.asList(new ResourceLocation("slotmachinemod", "textures/gui/slot_banana.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_bar.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_cherry.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_orange.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_strawberry.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_empty.png"));
        ResourceLocation image = images.get(slotImage - 1);
        this.drawImage(guiGraphics, image, x, y);
        return image;
    }

    private ResourceLocation drawRandomImage(GuiGraphics guiGraphics, int x, int y) {
        List<ResourceLocation> images = Arrays.asList(new ResourceLocation("slotmachinemod", "textures/gui/slot_banana.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_bar.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_cherry.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_orange.png"), new ResourceLocation("slotmachinemod", "textures/gui/slot_strawberry.png"));
        int randomIndex = new Random().nextInt(images.size());
        ResourceLocation image = images.get(randomIndex);
        this.drawImage(guiGraphics, image, x, y);
        return image;
    }

    private void drawImage(GuiGraphics guiGraphics, ResourceLocation image, int x, int y) {
        if (image != null) {
            guiGraphics.m_280163_(image, x, y, 0.0f, 0.0f, 16, 43, 16, 43);
        }
    }

    private boolean areResutlsInYet() {
        return this.results[0] != 0 && this.results[1] != 0 && this.results[2] != 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        if (!this.outOfService) {
            this.stopButton.f_93624_ = !this.areResutlsInYet();
            this.spinButton.f_93624_ = !this.stopButton.f_93624_;
            guiGraphics.m_280509_(this.f_96543_ / 2 - 50, this.f_96544_ / 2 - 25, this.f_96543_ / 2 + 50, this.f_96544_ / 2 + 25, -16711936);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int messageWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.message);
        if (Objects.equals(this.message, "Out of Order")) {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.message, (int)((float)(this.f_96543_ - messageWidth) / 2.0f), (int)((float)this.f_96544_ / 2.0f) - 45, 0xFF0000);
        } else {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.message, (int)((float)(this.f_96543_ - messageWidth) / 2.0f), (int)((float)this.f_96544_ / 2.0f) - 75, 0xFFFFFF);
        }
    }
}

