/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block;

import com.modernmissions.block.entity.NuclearMissileBlockEntity;
import com.modernmissions.entity.NuclearMissileEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NuclearMissileBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public NuclearMissileBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 6.0f).m_60955_().m_60999_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof NuclearMissileBlockEntity) {
            NuclearMissileBlockEntity missileEntity = (NuclearMissileBlockEntity)blockEntity;
            missileEntity.startCountdown();
            player.m_5661_((Component)Component.m_237113_((String)"Launch sequence initiated!").m_130940_(ChatFormatting.RED), true);
            level.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.5f, 0.8f);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void launchMissile(Level level, BlockPos pos, BlockState state) {
        NuclearMissileEntity missile = new NuclearMissileEntity((EntityType<? extends NuclearMissileEntity>)((EntityType)ModEntities.NUCLEAR_MISSILE.get()), level);
        missile.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        missile.m_20334_(0.0, 0.5, 0.0);
        level.m_7967_((Entity)missile);
        level.m_7471_(pos, false);
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 3.0f, 0.5f);
        level.m_5594_(null, pos, SoundEvents.f_11705_, SoundSource.BLOCKS, 2.0f, 0.3f);
        level.m_5594_(null, pos, SoundEvents.f_11892_, SoundSource.BLOCKS, 1.5f, 0.7f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int ring = 0; ring < 3; ++ring) {
                double radius = (double)(ring + 1) * 1.5;
                for (int i = 0; i < 20; ++i) {
                    double angle = Math.PI * 2 * (double)i / 20.0;
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                    double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, (double)pos.m_123342_() + 0.1, z, 1, 0.0, 0.1, 0.0, 0.05);
                    if (ring != 0) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, (double)pos.m_123342_(), z, 1, 0.0, 0.3, 0.0, 0.02);
                }
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
            for (int y = 0; y < 8; ++y) {
                for (int i = 0; i < 10; ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + (double)y * 0.5, (double)pos.m_123343_() + 0.5 + offsetZ, 2, offsetX * 0.05, 0.3, offsetZ * 0.05, 0.1);
                    if (i % 2 != 0) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5 + offsetX * 0.5, (double)pos.m_123342_() + (double)y * 0.5, (double)pos.m_123343_() + 0.5 + offsetZ * 0.5, 1, 0.0, 0.2, 0.0, 0.05);
                }
            }
            for (int i = 0; i < 150; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 4.0;
                double offsetY = level.f_46441_.m_188500_() * 2.0;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 4.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, offsetX * 0.02, 0.05, offsetZ * 0.02, 0.01);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new NuclearMissileBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return NuclearMissileBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.NUCLEAR_MISSILE.get()), NuclearMissileBlockEntity::tick);
    }
}

