/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.ModernMissions;
import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.ReactorLubricantTankBlock;
import com.modernmissions.block.ReactorMonitorBlock;
import com.modernmissions.block.entity.ReactorControlRodPortBlockEntity;
import com.modernmissions.block.entity.ReactorFuelPortBlockEntity;
import com.modernmissions.block.entity.ReactorLubricantTankBlockEntity;
import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModFluids;
import com.modernmissions.init.ModItems;
import com.modernmissions.init.ModSounds;
import com.modernmissions.menu.ReactorControllerMenu;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2CReactorStatePacket;
import com.modernmissions.util.ReactorMultiblock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NuclearControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int MAX_COOLANT_BLOCKS = 25;
    public static final int MAX_FUEL = 16;
    public static final int MAX_LUBRICANT = 10;
    private final ItemStackHandler fuelInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            NuclearControllerBlockEntity.this.cachedFuelCount = NuclearControllerBlockEntity.this.fuelInventory.getStackInSlot(0).m_41613_();
            NuclearControllerBlockEntity.this.m_6596_();
            if (NuclearControllerBlockEntity.this.f_58857_ != null && !((NuclearControllerBlockEntity)NuclearControllerBlockEntity.this).f_58857_.f_46443_) {
                NuclearControllerBlockEntity.this.f_58857_.m_7260_(NuclearControllerBlockEntity.this.f_58858_, NuclearControllerBlockEntity.this.m_58900_(), NuclearControllerBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_150930_((Item)ModItems.URANIUM_FUEL_CELL.get());
        }

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private LazyOptional<IItemHandler> itemCapability = LazyOptional.empty();
    private int cachedFuelCount = 0;
    private int cachedCoolantBlocks = 0;
    private int cachedLubricantLevel = 0;
    private boolean cachedActiveState = false;
    private int cachedControlRodCount = 0;
    private int cachedControlRodProgressPct = 0;
    private int cachedControlRodEtaTicks = 0;
    private int waterConsumptionTimer = 0;
    private static final int STEAM_PARTICLE_INTERVAL = 20;
    private boolean manuallyActivated = false;
    private int warningTimer = 0;
    private boolean wasWarning = false;
    private static final int WARNING_DURATION = 1200;
    private static final int CRITICAL_WARNING_DURATION = 200;
    private static final int WARNING_SOUND_INTERVAL = 240;
    private int fuelConsumptionTimer = 0;
    private int lubricantConsumptionTimer = 0;
    private static final int FUEL_CONSUMPTION_RATE = 1200;
    private static final int LUBRICANT_CONSUMPTION_RATE = 2400;
    private int stateBroadcastTimer = 0;
    private static final int STATE_BROADCAST_INTERVAL = 100;
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> NuclearControllerBlockEntity.this.cachedFuelCount;
                case 1 -> NuclearControllerBlockEntity.this.cachedCoolantBlocks;
                case 2 -> NuclearControllerBlockEntity.this.cachedLubricantLevel;
                case 3 -> {
                    if (NuclearControllerBlockEntity.this.cachedActiveState) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> NuclearControllerBlockEntity.this.cachedControlRodCount;
                case 5 -> NuclearControllerBlockEntity.this.cachedControlRodProgressPct;
                case 6 -> NuclearControllerBlockEntity.this.cachedControlRodEtaTicks;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    NuclearControllerBlockEntity.this.cachedFuelCount = value;
                    break;
                }
                case 1: {
                    NuclearControllerBlockEntity.this.cachedCoolantBlocks = value;
                    break;
                }
                case 2: {
                    NuclearControllerBlockEntity.this.cachedLubricantLevel = value;
                    break;
                }
                case 3: {
                    NuclearControllerBlockEntity.this.cachedActiveState = value != 0;
                    break;
                }
                case 4: {
                    NuclearControllerBlockEntity.this.cachedControlRodCount = value;
                    break;
                }
                case 5: {
                    NuclearControllerBlockEntity.this.cachedControlRodProgressPct = value;
                    break;
                }
                case 6: {
                    NuclearControllerBlockEntity.this.cachedControlRodEtaTicks = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public NuclearControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NUCLEAR_CONTROLLER.get(), pos, state);
    }

    public boolean isActive() {
        return this.cachedActiveState;
    }

    public void broadcastStateToNearbyPlayers() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            S2CReactorStatePacket packet = new S2CReactorStatePacket(this.f_58858_, this.cachedActiveState);
            ModNetworking.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 32.0, serverLevel.m_46472_())), (Object)packet);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NuclearControllerBlockEntity entity) {
        if (!level.f_46443_) {
            entity.serverTick();
        }
    }

    private void serverTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int newFuelCount = NuclearControllerBlockEntity.calculateFuelFromPorts(this.f_58857_, this.f_58858_);
        int newCoolantBlocks = NuclearControllerBlockEntity.calculateCoolantBlocks(this.f_58857_, this.f_58858_);
        int newLubricantLevel = NuclearControllerBlockEntity.calculateLubricantLevel(this.f_58857_, this.f_58858_);
        int newRodCount = NuclearControllerBlockEntity.calculateControlRodCount(this.f_58857_, this.f_58858_);
        int newRodProgress = NuclearControllerBlockEntity.calculateControlRodProgressPercent(this.f_58857_, this.f_58858_);
        int newRodEta = NuclearControllerBlockEntity.calculateControlRodRemainingTicks(this.f_58857_, this.f_58858_);
        boolean newActiveState = (Boolean)this.m_58900_().m_61143_((Property)NuclearControllerBlock.ACTIVE);
        if (newActiveState) {
            ++this.waterConsumptionTimer;
            if (this.waterConsumptionTimer >= (Integer)CommonConfig.REACTOR_COOLANT_CONSUMPTION_RATE.get()) {
                this.consumePurifiedWater();
                this.waterConsumptionTimer = 0;
            }
            if (this.waterConsumptionTimer % 20 == 0) {
                this.createSteamEffects();
            }
            ++this.stateBroadcastTimer;
            if (this.stateBroadcastTimer >= 100) {
                this.stateBroadcastTimer = 0;
                this.broadcastStateToNearbyPlayers();
            }
        } else {
            this.waterConsumptionTimer = 0;
            this.stateBroadcastTimer = 0;
        }
        if (newActiveState != this.cachedActiveState || newFuelCount != this.cachedFuelCount || newCoolantBlocks != this.cachedCoolantBlocks || newLubricantLevel != this.cachedLubricantLevel || newRodCount != this.cachedControlRodCount || newRodProgress != this.cachedControlRodProgressPct || newRodEta != this.cachedControlRodEtaTicks) {
            Level level;
            if (newActiveState != this.cachedActiveState && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                S2CReactorStatePacket packet = new S2CReactorStatePacket(this.f_58858_, newActiveState);
                ModNetworking.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 32.0, serverLevel.m_46472_())), (Object)packet);
                ModernMissions.LOGGER.info("Sent reactor state packet - pos: {}, active: {}", (Object)this.f_58858_, (Object)newActiveState);
            }
            this.cachedActiveState = newActiveState;
            this.cachedFuelCount = newFuelCount;
            this.cachedCoolantBlocks = newCoolantBlocks;
            this.cachedLubricantLevel = newLubricantLevel;
            this.cachedControlRodCount = newRodCount;
            this.cachedControlRodProgressPct = newRodProgress;
            this.cachedControlRodEtaTicks = newRodEta;
            this.m_6596_();
        }
    }

    private static int calculateCoolantBlocks(Level level, BlockPos controllerPos) {
        BlockState controllerState = level.m_8055_(controllerPos);
        if (!controllerState.m_61138_((Property)NuclearControllerBlock.FACING)) {
            return 0;
        }
        Direction facing = (Direction)controllerState.m_61143_((Property)NuclearControllerBlock.FACING);
        Direction back = facing.m_122424_();
        BlockPos coolantPortPos = controllerPos.m_121945_(back).m_7495_();
        if (!level.m_8055_(coolantPortPos).m_60713_((Block)ModBlocks.REACTOR_COOLANT_PORT.get())) {
            return 0;
        }
        int count = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos checkPos = coolantPortPos.m_7495_().m_7918_(dx, 0, dz);
                if (!NuclearControllerBlockEntity.containsPurifiedWater(level, checkPos)) continue;
                ++count;
            }
        }
        return count;
    }

    private static boolean containsPurifiedWater(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60713_((Block)ModFluids.PURIFIED_WATER_BLOCK.get())) {
            return true;
        }
        if (blockState.m_60713_((Block)ModBlocks.PURIFIED_WATER_SOURCE_BLOCK.get())) {
            return true;
        }
        FluidState fluidState = level.m_6425_(pos);
        return fluidState.m_192917_((Fluid)ModFluids.PURIFIED_WATER_SOURCE.get()) || fluidState.m_192917_((Fluid)ModFluids.PURIFIED_WATER_FLOWING.get());
    }

    private static int calculateLubricantLevel(Level level, BlockPos origin) {
        BlockPos tankPos = origin.m_7494_();
        BlockEntity tankEntity = level.m_7702_(tankPos);
        if (tankEntity instanceof ReactorLubricantTankBlockEntity) {
            ReactorLubricantTankBlockEntity tank = (ReactorLubricantTankBlockEntity)tankEntity;
            return tank.getFillLevel();
        }
        BlockState tankState = level.m_8055_(tankPos);
        if (tankState.m_60713_((Block)ModBlocks.REACTOR_LUBRICANT_TANK.get()) && tankState.m_61138_((Property)ReactorLubricantTankBlock.FILL_LEVEL)) {
            return (Integer)tankState.m_61143_((Property)ReactorLubricantTankBlock.FILL_LEVEL);
        }
        return 0;
    }

    private static int calculateFuelFromPorts(Level level, BlockPos origin) {
        int totalFuel = 0;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos checkPos = origin.m_7918_(dx, dy, dz);
                    BlockEntity blockEntity = level.m_7702_(checkPos);
                    if (!(blockEntity instanceof ReactorFuelPortBlockEntity)) continue;
                    ReactorFuelPortBlockEntity fuelPort = (ReactorFuelPortBlockEntity)blockEntity;
                    for (int i = 0; i < fuelPort.getItemHandler().getSlots(); ++i) {
                        ItemStack stack = fuelPort.getItemHandler().getStackInSlot(i);
                        if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.URANIUM_FUEL_CELL.get())) continue;
                        totalFuel += stack.m_41613_();
                    }
                }
            }
        }
        return totalFuel;
    }

    private static int calculateControlRodCount(Level level, BlockPos origin) {
        int total = 0;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos check = origin.m_7918_(dx, dy, dz);
                    BlockEntity be = level.m_7702_(check);
                    if (!(be instanceof ReactorControlRodPortBlockEntity)) continue;
                    ReactorControlRodPortBlockEntity port = (ReactorControlRodPortBlockEntity)be;
                    total += port.getControlRodCount();
                }
            }
        }
        return total;
    }

    private static int calculateControlRodProgressPercent(Level level, BlockPos origin) {
        int maxPct = 0;
        boolean hasAny = false;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    ReactorControlRodPortBlockEntity port;
                    int count;
                    BlockPos check = origin.m_7918_(dx, dy, dz);
                    BlockEntity be = level.m_7702_(check);
                    if (!(be instanceof ReactorControlRodPortBlockEntity) || (count = (port = (ReactorControlRodPortBlockEntity)be).getControlRodCount()) <= 0) continue;
                    hasAny = true;
                    int maxTime = Math.max(1, port.getMaxConsumptionTime());
                    int timer = Math.min(maxTime, Math.max(0, port.getConsumptionProgress()));
                    int pctConsumed = (int)Math.floor((double)timer / (double)maxTime * 100.0);
                    int pctRemaining = Math.max(0, 100 - pctConsumed);
                    if (pctRemaining <= maxPct) continue;
                    maxPct = pctRemaining;
                }
            }
        }
        return hasAny ? maxPct : 0;
    }

    private static int calculateControlRodRemainingTicks(Level level, BlockPos origin) {
        int best = Integer.MAX_VALUE;
        boolean hasAny = false;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    int timer;
                    ReactorControlRodPortBlockEntity port;
                    int count;
                    BlockPos check = origin.m_7918_(dx, dy, dz);
                    BlockEntity be = level.m_7702_(check);
                    if (!(be instanceof ReactorControlRodPortBlockEntity) || (count = (port = (ReactorControlRodPortBlockEntity)be).getControlRodCount()) <= 0) continue;
                    hasAny = true;
                    int maxTime = Math.max(1, port.getMaxConsumptionTime());
                    int remaining = Math.max(0, maxTime - (timer = Math.min(maxTime, Math.max(0, port.getConsumptionProgress()))));
                    if (remaining >= best) continue;
                    best = remaining;
                }
            }
        }
        return hasAny ? best : 0;
    }

    private void consumePurifiedWater() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState controllerState = this.m_58900_();
        if (!controllerState.m_61138_((Property)NuclearControllerBlock.FACING)) {
            return;
        }
        Direction facing = (Direction)controllerState.m_61143_((Property)NuclearControllerBlock.FACING);
        Direction back = facing.m_122424_();
        BlockPos coolantPortPos = this.f_58858_.m_121945_(back).m_7495_();
        if (!this.f_58857_.m_8055_(coolantPortPos).m_60713_((Block)ModBlocks.REACTOR_COOLANT_PORT.get())) {
            return;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos checkPos;
                FluidState fluidState;
                boolean isCoreBlock = false;
                if (dx == 0 && dz == 0) {
                    isCoreBlock = true;
                } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    if (dx == 0 && Math.abs(dz) == 1) {
                        isCoreBlock = true;
                    }
                } else if (dz == 0 && Math.abs(dx) == 1) {
                    isCoreBlock = true;
                }
                if (isCoreBlock || !(fluidState = this.f_58857_.m_6425_(checkPos = coolantPortPos.m_7495_().m_7918_(dx, 0, dz))).m_192917_((Fluid)ModFluids.PURIFIED_WATER_SOURCE.get()) || !fluidState.m_76170_()) continue;
                this.f_58857_.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                this.cachedCoolantBlocks = NuclearControllerBlockEntity.calculateCoolantBlocks(this.f_58857_, this.f_58858_);
                this.m_6596_();
                return;
            }
        }
    }

    private void createSteamEffects() {
        Level level;
        if (this.f_58857_ == null || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = this.f_58857_.m_213780_();
        for (int i = 0; i < 8; ++i) {
            double x = (double)this.f_58858_.m_123341_() + 0.2 + random.m_188500_() * 0.6;
            double y = (double)this.f_58858_.m_123342_() + 1.1 + random.m_188500_() * 0.3;
            double z = (double)this.f_58858_.m_123343_() + 0.2 + random.m_188500_() * 0.6;
            double velocityX = (random.m_188500_() - 0.5) * 0.02;
            double velocityY = 0.05 + random.m_188500_() * 0.03;
            double velocityZ = (random.m_188500_() - 0.5) * 0.02;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, velocityX, velocityY, velocityZ, 0.01);
        }
    }

    public ItemStackHandler getFuelInventory() {
        return this.fuelInventory;
    }

    public ContainerData getData() {
        return this.data;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.nuclear_controller");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ReactorControllerMenu(id, playerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Fuel", (Tag)this.fuelInventory.serializeNBT());
        tag.m_128405_("CoolantBlocks", this.cachedCoolantBlocks);
        tag.m_128405_("Lubricant", this.cachedLubricantLevel);
        tag.m_128379_("Active", this.cachedActiveState);
        tag.m_128405_("FuelCount", this.cachedFuelCount);
        tag.m_128405_("WaterTimer", this.waterConsumptionTimer);
        tag.m_128379_("ManuallyActivated", this.manuallyActivated);
        tag.m_128405_("WarningTimer", this.warningTimer);
        tag.m_128379_("WasWarning", this.wasWarning);
        tag.m_128405_("FuelConsumptionTimer", this.fuelConsumptionTimer);
        tag.m_128405_("LubricantConsumptionTimer", this.lubricantConsumptionTimer);
        tag.m_128405_("ControlRodCount", this.cachedControlRodCount);
        tag.m_128405_("ControlRodProgressPct", this.cachedControlRodProgressPct);
        tag.m_128405_("ControlRodEtaTicks", this.cachedControlRodEtaTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelInventory.deserializeNBT(tag.m_128469_("Fuel"));
        this.cachedCoolantBlocks = tag.m_128451_("CoolantBlocks");
        this.cachedLubricantLevel = tag.m_128451_("Lubricant");
        this.cachedActiveState = tag.m_128471_("Active");
        this.cachedFuelCount = tag.m_128441_("FuelCount") ? tag.m_128451_("FuelCount") : this.fuelInventory.getStackInSlot(0).m_41613_();
        this.waterConsumptionTimer = tag.m_128451_("WaterTimer");
        this.manuallyActivated = tag.m_128471_("ManuallyActivated");
        this.warningTimer = tag.m_128451_("WarningTimer");
        this.wasWarning = tag.m_128471_("WasWarning");
        this.fuelConsumptionTimer = tag.m_128451_("FuelConsumptionTimer");
        this.lubricantConsumptionTimer = tag.m_128451_("LubricantConsumptionTimer");
        this.cachedControlRodCount = tag.m_128451_("ControlRodCount");
        this.cachedControlRodProgressPct = tag.m_128451_("ControlRodProgressPct");
        this.cachedControlRodEtaTicks = tag.m_128451_("ControlRodEtaTicks");
    }

    public void onLoad() {
        super.onLoad();
        this.itemCapability = LazyOptional.of(() -> this.fuelInventory);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void attemptReactorStart(Player player) {
        boolean hasLubricant;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction facing = (Direction)state.m_61143_((Property)NuclearControllerBlock.FACING);
        if (!ReactorMultiblock.isFormed(this.f_58857_, this.f_58858_, facing)) {
            player.m_5661_((Component)Component.m_237113_((String)"Reactor structure incomplete!").m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean hasFuel = this.cachedFuelCount > 0;
        boolean hasCoolant = this.cachedCoolantBlocks >= 5;
        boolean bl = hasLubricant = this.cachedLubricantLevel > 0;
        if (!(hasFuel && hasCoolant && hasLubricant)) {
            if (!hasFuel) {
                player.m_5661_((Component)Component.m_237113_((String)"\u26a0 No fuel in reactor!").m_130940_(ChatFormatting.RED), true);
            }
            if (!hasCoolant) {
                player.m_5661_((Component)Component.m_237113_((String)"\u26a0 Insufficient coolant!").m_130940_(ChatFormatting.RED), true);
            }
            if (!hasLubricant) {
                player.m_5661_((Component)Component.m_237113_((String)"\u26a0 No lubricant!").m_130940_(ChatFormatting.RED), true);
            }
            player.m_5661_((Component)Component.m_237113_((String)"Reactor will enter CRITICAL STATE if activated!").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}), false);
        }
        this.manuallyActivated = true;
        this.warningTimer = 0;
        ReactorMultiblock.activate(this.f_58857_, this.f_58858_, facing);
        player.m_5661_((Component)Component.m_237113_((String)"Reactor activated").m_130940_(ChatFormatting.GREEN), true);
    }

    public void shutdownReactor(Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.manuallyActivated = false;
        this.warningTimer = 0;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction facing = (Direction)state.m_61143_((Property)NuclearControllerBlock.FACING);
        ReactorMultiblock.deactivate(this.f_58857_, this.f_58858_, facing);
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)"Reactor shutdown").m_130940_(ChatFormatting.YELLOW), true);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NuclearControllerBlockEntity entity) {
        if (level.f_46443_) {
            return;
        }
        entity.cachedActiveState = (Boolean)state.m_61143_((Property)NuclearControllerBlock.ACTIVE);
        entity.cachedCoolantBlocks = NuclearControllerBlockEntity.calculateCoolantBlocks(level, pos);
        entity.cachedLubricantLevel = NuclearControllerBlockEntity.calculateLubricantLevel(level, pos);
        entity.cachedFuelCount = NuclearControllerBlockEntity.calculateFuelFromPorts(level, pos);
        entity.cachedControlRodCount = NuclearControllerBlockEntity.calculateControlRodCount(level, pos);
        entity.cachedControlRodProgressPct = NuclearControllerBlockEntity.calculateControlRodProgressPercent(level, pos);
        entity.cachedControlRodEtaTicks = NuclearControllerBlockEntity.calculateControlRodRemainingTicks(level, pos);
        entity.m_6596_();
        if (!entity.manuallyActivated) {
            return;
        }
        boolean isActive = (Boolean)state.m_61143_((Property)NuclearControllerBlock.ACTIVE);
        if (!isActive) {
            return;
        }
        entity.tickResourceConsumption(level, pos);
        entity.checkCriticalConditions(level, pos, state);
        entity.updateMonitorState(level, pos, state);
        if (level.m_46467_() % 20L == 0L) {
            entity.produceSteamEffects((ServerLevel)level, pos);
        }
    }

    private void tickResourceConsumption(Level level, BlockPos pos) {
        if (++this.fuelConsumptionTimer >= 1200) {
            this.fuelConsumptionTimer = 0;
            this.consumeFuel(level, pos);
        }
        if (++this.lubricantConsumptionTimer >= 2400) {
            this.lubricantConsumptionTimer = 0;
            this.consumeLubricant(level, pos);
        }
        if (++this.waterConsumptionTimer >= (Integer)CommonConfig.REACTOR_COOLANT_CONSUMPTION_RATE.get()) {
            this.waterConsumptionTimer = 0;
            this.consumePurifiedWater();
        }
    }

    private void consumeFuel(Level level, BlockPos pos) {
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)NuclearControllerBlock.FACING);
        BlockPos fuelPortPos = pos.m_121945_(facing.m_122424_()).m_7494_();
        BlockEntity be = level.m_7702_(fuelPortPos);
        if (be instanceof ReactorFuelPortBlockEntity) {
            ReactorFuelPortBlockEntity fuelPort = (ReactorFuelPortBlockEntity)be;
            for (int i = 0; i < fuelPort.getItemHandler().getSlots(); ++i) {
                ItemStack stack = fuelPort.getItemHandler().getStackInSlot(i);
                if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.URANIUM_FUEL_CELL.get())) continue;
                stack.m_41774_(1);
                fuelPort.getItemHandler().setStackInSlot(i, stack);
                this.cachedFuelCount = Math.max(0, this.cachedFuelCount - 1);
                break;
            }
        }
    }

    private void consumeLubricant(Level level, BlockPos pos) {
        BlockPos tankPos = pos.m_7494_();
        BlockEntity be = level.m_7702_(tankPos);
        if (be instanceof ReactorLubricantTankBlockEntity) {
            ReactorLubricantTankBlockEntity tank = (ReactorLubricantTankBlockEntity)be;
            tank.consumeLubricant();
            this.cachedLubricantLevel = Math.max(0, this.cachedLubricantLevel - 1);
        }
    }

    private void checkCriticalConditions(Level level, BlockPos pos, BlockState state) {
        boolean hasLubricant;
        boolean hasFuel = this.cachedFuelCount > 0;
        boolean hasCoolant = this.cachedCoolantBlocks >= 5;
        boolean bl = hasLubricant = this.cachedLubricantLevel > 0;
        if (!(hasFuel && hasCoolant && hasLubricant)) {
            ++this.warningTimer;
            if (!this.wasWarning) {
                this.wasWarning = true;
            }
            if (this.warningTimer % 240 == 1) {
                level.m_5594_(null, pos, (SoundEvent)ModSounds.REACTOR_WARNING.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            }
            if (this.warningTimer % 40 == 0) {
                for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(80.0))) {
                    if (this.warningTimer >= 1000) {
                        player.m_5661_((Component)Component.m_237113_((String)"\u26a0\u26a0\u26a0 REACTOR CRITICAL - EXPLOSION IMMINENT \u26a0\u26a0\u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}), true);
                        continue;
                    }
                    Object warning = "\u26a0 REACTOR WARNING: ";
                    if (!hasFuel) {
                        warning = (String)warning + "NO FUEL ";
                    }
                    if (!hasCoolant) {
                        warning = (String)warning + "NO COOLANT ";
                    }
                    if (!hasLubricant) {
                        warning = (String)warning + "NO LUBRICANT ";
                    }
                    warning = (String)warning + "(" + (1200 - this.warningTimer) / 20 + "s)";
                    player.m_5661_((Component)Component.m_237113_((String)warning).m_130940_(ChatFormatting.RED), true);
                }
            }
            if (this.warningTimer >= 1200) {
                this.triggerReactorExplosion(level, pos);
            }
        } else {
            if (this.wasWarning && this.warningTimer > 0) {
                level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 2.0f, 1.0f);
                for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(80.0))) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u2713 REACTOR STABLE - Crisis averted").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), true);
                }
                this.wasWarning = false;
            }
            this.warningTimer = 0;
        }
    }

    private void triggerReactorExplosion(Level level, BlockPos pos) {
        int i;
        level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 45.0f, Level.ExplosionInteraction.BLOCK);
        for (i = 0; i < 12; ++i) {
            BlockPos randomPos = pos.m_7918_(level.f_46441_.m_188503_(21) - 10, level.f_46441_.m_188503_(11) - 5, level.f_46441_.m_188503_(21) - 10);
            level.m_254849_(null, (double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_(), 15.0f, Level.ExplosionInteraction.BLOCK);
        }
        for (i = 0; i < 8; ++i) {
            BlockPos outerPos = pos.m_7918_(level.f_46441_.m_188503_(31) - 15, level.f_46441_.m_188503_(7) - 3, level.f_46441_.m_188503_(31) - 15);
            level.m_254849_(null, (double)outerPos.m_123341_(), (double)outerPos.m_123342_(), (double)outerPos.m_123343_(), 10.0f, Level.ExplosionInteraction.BLOCK);
        }
        this.manuallyActivated = false;
        this.warningTimer = 0;
    }

    private void updateMonitorState(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)NuclearControllerBlock.FACING);
        BlockPos monitorPos = pos.m_121945_(facing.m_122427_());
        BlockState monitorState = level.m_8055_(monitorPos);
        if (monitorState.m_60713_((Block)ModBlocks.REACTOR_MONITOR.get()) && monitorState.m_61138_((Property)ReactorMonitorBlock.MONITOR_STATE)) {
            int totalResources = this.cachedFuelCount + this.cachedCoolantBlocks + this.cachedLubricantLevel;
            int maxResources = 51;
            float resourcePercent = (float)totalResources / (float)maxResources;
            int newState = resourcePercent > 0.5f ? 1 : (resourcePercent > 0.2f ? 2 : 3);
            if ((Integer)monitorState.m_61143_((Property)ReactorMonitorBlock.MONITOR_STATE) != newState) {
                level.m_7731_(monitorPos, (BlockState)monitorState.m_61124_((Property)ReactorMonitorBlock.MONITOR_STATE, (Comparable)Integer.valueOf(newState)), 3);
            }
        }
    }

    private void produceSteamEffects(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + level.f_46441_.m_188583_() * 0.3;
            double y = (double)pos.m_123342_() + 2.5;
            double z = (double)pos.m_123343_() + 0.5 + level.f_46441_.m_188583_() * 0.3;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 1, 0.0, 0.1, 0.0, 0.05);
        }
    }

    public boolean isManuallyActivated() {
        return this.manuallyActivated;
    }

    public void drops() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        SimpleContainer container = new SimpleContainer(this.fuelInventory.getSlots());
        for (int i = 0; i < this.fuelInventory.getSlots(); ++i) {
            container.m_6836_(i, this.fuelInventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
        this.cachedFuelCount = 0;
    }
}

