/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.client.CameraShakeHandler;
import com.modernmissions.entity.NuclearMissileEntity;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NuclearMissileBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int countdownTicks = -1;
    private static final int COUNTDOWN_DURATION = 200;

    public int getCountdownTicks() {
        return this.countdownTicks;
    }

    public boolean isCountingDown() {
        return this.countdownTicks > 0;
    }

    public NuclearMissileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NUCLEAR_MISSILE.get(), pos, state);
    }

    public void startCountdown() {
        if (this.countdownTicks < 0) {
            this.countdownTicks = 200;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.countdownTicks = tag.m_128451_("Countdown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Countdown", this.countdownTicks);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (this.countdownTicks > 0) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.nuclear_missile.activated"));
            }
            return state.setAndContinue(RawAnimation.begin());
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5, (double)pos.m_123341_() + 1.5, (double)pos.m_123342_() + 4.5, (double)pos.m_123343_() + 1.5);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NuclearMissileBlockEntity blockEntity) {
        if (blockEntity.countdownTicks > 0) {
            --blockEntity.countdownTicks;
            if (level.f_46443_) {
                CameraShakeHandler.addMissileShake(pos, blockEntity.countdownTicks);
            }
            if (blockEntity.countdownTicks % 20 == 0) {
                int secondsLeft = blockEntity.countdownTicks / 20;
                if (!level.f_46443_) {
                    for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(30.0))) {
                        if (secondsLeft <= 0) continue;
                        player.m_5661_((Component)Component.m_237113_((String)("T-" + secondsLeft + "...")), true);
                    }
                    if (secondsLeft <= 3 && secondsLeft > 0) {
                        level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
                        level.m_5594_(null, pos, SoundEvents.f_11701_, SoundSource.BLOCKS, 1.5f, 0.3f);
                    } else if (secondsLeft > 0) {
                        level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12215_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (secondsLeft == 5) {
                        level.m_5594_(null, pos, SoundEvents.f_11739_, SoundSource.BLOCKS, 2.0f, 0.5f);
                        level.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.5f, 0.7f);
                    }
                }
            }
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x = (double)pos.m_123341_() + 0.5;
                double z = (double)pos.m_123343_() + 0.5;
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    int i;
                    double dz;
                    double dy;
                    double dx = player.m_20185_() - x;
                    double distanceSq = dx * dx + (dy = player.m_20186_() - (double)pos.m_123342_()) * dy + (dz = player.m_20189_() - z) * dz;
                    if (!(distanceSq < 262144.0)) continue;
                    float progress = 1.0f - (float)blockEntity.countdownTicks / 200.0f;
                    if (blockEntity.countdownTicks < 180 && blockEntity.countdownTicks % 2 == 0) {
                        int steamCount = (int)(3.0f + progress * 7.0f);
                        for (int i2 = 0; i2 < steamCount; ++i2) {
                            double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                            double radius = 0.8 + serverLevel.f_46441_.m_188500_() * 0.4;
                            serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123796_, true, x + Math.cos(angle) * radius, (double)pos.m_123342_() + 0.1, z + Math.sin(angle) * radius, 1, 0.1, 0.05, 0.1, 0.02);
                        }
                    }
                    if (blockEntity.countdownTicks % 3 == 0) {
                        for (i = 0; i < Math.max(1, 5 - blockEntity.countdownTicks / 40); ++i) {
                            serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, true, x, (double)pos.m_123342_() + 0.2, z, 2, 0.15, 0.1, 0.15, 0.01);
                        }
                    }
                    if (blockEntity.countdownTicks < 100 && blockEntity.countdownTicks % 5 == 0) {
                        for (i = 0; i < 5; ++i) {
                            double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                            double dist = 0.5 + serverLevel.f_46441_.m_188500_() * 2.0;
                            serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, x + Math.cos(angle) * dist, (double)pos.m_123342_() + 0.05, z + Math.sin(angle) * dist, 1, 0.1, 0.02, 0.1, 0.01);
                        }
                    }
                    if (blockEntity.countdownTicks < 60) {
                        if (blockEntity.countdownTicks % 4 == 0) {
                            for (i = 0; i < 3; ++i) {
                                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, x + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.4, (double)pos.m_123342_() + 0.3, z + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.4, 1, 0.05, 0.1, 0.05, 0.02);
                            }
                        }
                        if (blockEntity.countdownTicks < 20) {
                            for (i = 0; i < 5; ++i) {
                                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, x + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2, (double)pos.m_123342_() + 0.1, z + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.2, 2, 0.1, 0.0, 0.1, 0.15);
                            }
                            serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, x, (double)pos.m_123342_() + 0.1, z, 3, 0.05, 0.0, 0.05, 0.1);
                            serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123778_, true, x, (double)pos.m_123342_() + 0.5, z, 2, 0.2, 0.3, 0.2, 0.05);
                        }
                    }
                    if (blockEntity.countdownTicks >= 40 || blockEntity.countdownTicks % 8 != 0) continue;
                    for (i = 0; i < 8; ++i) {
                        double angle = Math.PI * 2 * (double)i / 8.0;
                        serverLevel.m_8624_(player, (ParticleOptions)new DustColorTransitionOptions(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), 1.5f), true, x + Math.cos(angle) * 1.5, (double)pos.m_123342_() + 1.0, z + Math.sin(angle) * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (level.f_46443_) {
                int i;
                double x = (double)pos.m_123341_() + 0.5;
                double z = (double)pos.m_123343_() + 0.5;
                float progress = 1.0f - (float)blockEntity.countdownTicks / 200.0f;
                if (blockEntity.countdownTicks < 180) {
                    int steamCount = (int)(3.0f + progress * 7.0f);
                    for (int i3 = 0; i3 < steamCount; ++i3) {
                        double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                        double radius = 0.8 + level.f_46441_.m_188500_() * 0.4;
                        double vx = Math.cos(angle) * (0.08 + level.f_46441_.m_188500_() * 0.04);
                        double vz = Math.sin(angle) * (0.08 + level.f_46441_.m_188500_() * 0.04);
                        double vy = 0.05 + level.f_46441_.m_188500_() * 0.03;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x + Math.cos(angle) * radius, (double)pos.m_123342_() + 0.1, z + Math.sin(angle) * radius, vx, vy, vz);
                    }
                }
                for (i = 0; i < Math.max(1, 5 - blockEntity.countdownTicks / 40); ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                    double vx = offsetX * 0.02 + (level.f_46441_.m_188500_() - 0.5) * 0.01;
                    double vz = offsetZ * 0.02 + (level.f_46441_.m_188500_() - 0.5) * 0.01;
                    double vy = -0.03 + level.f_46441_.m_188500_() * 0.02;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + offsetX, (double)pos.m_123342_() + 0.2, z + offsetZ, vx, vy, vz);
                }
                if (blockEntity.countdownTicks < 100 && level.f_46441_.m_188503_(3) == 0) {
                    for (i = 0; i < 3; ++i) {
                        double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                        double dist = 0.5 + level.f_46441_.m_188500_() * 1.5;
                        double offsetX = Math.cos(angle) * dist;
                        double offsetZ = Math.sin(angle) * dist;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5 + offsetZ, offsetX * 0.01, 0.01 + level.f_46441_.m_188500_() * 0.01, offsetZ * 0.01);
                    }
                }
                if (blockEntity.countdownTicks < 60) {
                    if (level.f_46441_.m_188503_(3) == 0) {
                        for (i = 0; i < 2; ++i) {
                            double sparkX = (level.f_46441_.m_188500_() - 0.5) * 0.4;
                            double sparkZ = (level.f_46441_.m_188500_() - 0.5) * 0.4;
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x + sparkX, (double)pos.m_123342_() + 0.3 + level.f_46441_.m_188500_() * 0.3, z + sparkZ, sparkX * 0.02, 0.05 + level.f_46441_.m_188500_() * 0.02, sparkZ * 0.02);
                        }
                    }
                    if (blockEntity.countdownTicks < 20) {
                        for (i = 0; i < 3; ++i) {
                            double flameX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                            double flameZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + flameX, (double)pos.m_123342_() + 0.1, z + flameZ, flameX * 0.1, -0.15 - level.f_46441_.m_188500_() * 0.05, flameZ * 0.1);
                        }
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x + (level.f_46441_.m_188500_() - 0.5) * 0.1, (double)pos.m_123342_() + 0.1, z + (level.f_46441_.m_188500_() - 0.5) * 0.1, 0.0, -0.08, 0.0);
                    }
                }
                if (blockEntity.countdownTicks < 40 && blockEntity.countdownTicks % 4 < 2) {
                    for (i = 0; i < 8; ++i) {
                        double angle = Math.PI * 2 * (double)i / 8.0;
                        level.m_7106_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), 1.5f), x + Math.cos(angle) * 1.5, (double)pos.m_123342_() + 1.0, z + Math.sin(angle) * 1.5, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (blockEntity.countdownTicks == 0) {
                if (!level.f_46443_) {
                    blockEntity.launchMissile(level, pos, state);
                } else {
                    CameraShakeHandler.addLaunchAfterShake(pos);
                }
            }
            blockEntity.m_6596_();
        } else if (level.f_46443_ && level.f_46441_.m_188503_(10) == 0) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.2;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (level.f_46441_.m_188500_() - 0.5) * 0.3, y, z + (level.f_46441_.m_188500_() - 0.5) * 0.3, 0.0, 0.01, 0.0);
        }
    }

    private void launchMissile(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NuclearMissileEntity missile = new NuclearMissileEntity((EntityType<? extends NuclearMissileEntity>)((EntityType)ModEntities.NUCLEAR_MISSILE.get()), level);
            missile.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            missile.m_20334_(0.0, 0.5, 0.0);
            level.m_7967_((Entity)missile);
            level.m_7471_(pos, false);
            level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 3.0f, 0.5f);
            level.m_5594_(null, pos, SoundEvents.f_11705_, SoundSource.BLOCKS, 2.0f, 0.3f);
            level.m_5594_(null, pos, SoundEvents.f_11892_, SoundSource.BLOCKS, 1.5f, 0.7f);
            this.createLaunchParticles(serverLevel, pos);
        }
    }

    private void createLaunchParticles(ServerLevel serverLevel, BlockPos pos) {
        for (int ring = 0; ring < 3; ++ring) {
            double radius = (double)(ring + 1) * 1.5;
            for (int i = 0; i < 20; ++i) {
                double angle = Math.PI * 2 * (double)i / 20.0;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, (double)pos.m_123342_() + 0.1, z, 1, 0.0, 0.1, 0.0, 0.05);
                if (ring != 0) continue;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, (double)pos.m_123342_(), z, 1, 0.0, 0.3, 0.0, 0.02);
            }
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
    }
}

