/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.block.entity.NuclearControllerBlockEntity;
import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModItems;
import com.modernmissions.menu.ReactorControlRodPortMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorControlRodPortBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ReactorControlRodPortBlockEntity.this.m_6596_();
            if (ReactorControlRodPortBlockEntity.this.f_58857_ != null && !((ReactorControlRodPortBlockEntity)ReactorControlRodPortBlockEntity.this).f_58857_.f_46443_) {
                ReactorControlRodPortBlockEntity.this.f_58857_.m_7260_(ReactorControlRodPortBlockEntity.this.f_58858_, ReactorControlRodPortBlockEntity.this.m_58900_(), ReactorControlRodPortBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_150930_((Item)ModItems.REACTOR_CONTROL_ROD_BUNDLE.get());
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private LazyOptional<IItemHandler> itemCapability = LazyOptional.empty();
    private int consumptionTimer = 0;
    private boolean reactorActive = false;

    public ReactorControlRodPortBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REACTOR_CONTROL_ROD_PORT.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ReactorControlRodPortBlockEntity entity) {
        if (!level.f_46443_) {
            entity.tick();
        }
    }

    private void tick() {
        this.reactorActive = this.isReactorActive();
        if (this.reactorActive) {
            ++this.consumptionTimer;
            if (this.consumptionTimer >= (Integer)CommonConfig.REACTOR_CONTROL_ROD_CONSUMPTION_RATE.get()) {
                this.consumptionTimer = 0;
                this.consumeControlRodBundle();
            }
        } else {
            this.consumptionTimer = 0;
        }
    }

    private boolean isReactorActive() {
        for (Direction dir : Direction.values()) {
            for (int distance = 1; distance <= 3; ++distance) {
                BlockPos checkPos = this.f_58858_.m_5484_(dir, distance);
                BlockEntity be = this.f_58857_.m_7702_(checkPos);
                if (!(be instanceof NuclearControllerBlockEntity)) continue;
                NuclearControllerBlockEntity controller = (NuclearControllerBlockEntity)be;
                return controller.isActive();
            }
        }
        return false;
    }

    private void consumeControlRodBundle() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.m_41619_() && stack.m_150930_((Item)ModItems.REACTOR_CONTROL_ROD_BUNDLE.get())) {
            stack.m_41774_(1);
            this.inventory.setStackInSlot(0, stack);
            this.m_6596_();
        }
    }

    public ItemStack getControlRodStack() {
        return this.inventory.getStackInSlot(0);
    }

    public int getControlRodCount() {
        return this.inventory.getStackInSlot(0).m_41613_();
    }

    public int getConsumptionProgress() {
        return this.consumptionTimer;
    }

    public int getMaxConsumptionTime() {
        return (Integer)CommonConfig.REACTOR_CONTROL_ROD_CONSUMPTION_RATE.get();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modern_missions.reactor_control_rod_port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ReactorControlRodPortMenu(id, playerInventory, this, (ContainerData)new SimpleContainerData(2));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        this.consumptionTimer = tag.m_128451_("ConsumptionTimer");
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("ConsumptionTimer", this.consumptionTimer);
        super.m_183515_(tag);
    }

    public void drops() {
        SimpleContainer simpleInventory = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            simpleInventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }
}

