/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.block.entity;

import com.modernmissions.init.ModBlockEntities;
import com.modernmissions.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class UraniumSourceBlockEntity
extends BlockEntity {
    private static final int MAX_ORE_BLOCKS = 7;
    private static final int GROWTH_INTERVAL = 200;
    private static final double GROWTH_CHANCE = 0.3;
    private Set<BlockPos> spawnedOres = new HashSet<BlockPos>();
    private int tickCounter = 0;
    private boolean hasReachedMax = false;

    public UraniumSourceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.URANIUM_SOURCE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UraniumSourceBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++entity.tickCounter;
            if (entity.tickCounter >= 200) {
                entity.tickCounter = 0;
                if (!entity.hasReachedMax && level.f_46441_.m_188500_() < 0.3) {
                    entity.attemptGrowth(serverLevel);
                }
            }
            if (entity.tickCounter % 20 == 0) {
                entity.validateSpawnedOres(serverLevel);
            }
        }
    }

    private void attemptGrowth(ServerLevel level) {
        this.validateSpawnedOres(level);
        if (this.spawnedOres.size() >= 7) {
            this.hasReachedMax = true;
            return;
        }
        List<BlockPos> validPositions = this.findValidGrowthPositions(level);
        if (!validPositions.isEmpty()) {
            BlockPos targetPos = validPositions.get(level.f_46441_.m_188503_(validPositions.size()));
            level.m_7731_(targetPos, ((Block)ModBlocks.URANIUM_ORE.get()).m_49966_(), 3);
            this.spawnedOres.add(targetPos);
            if (this.spawnedOres.size() >= 7) {
                this.hasReachedMax = true;
            }
            this.m_6596_();
        }
    }

    private List<BlockPos> findValidGrowthPositions(ServerLevel level) {
        ArrayList<BlockPos> validPositions;
        block6: {
            block5: {
                validPositions = new ArrayList<BlockPos>();
                if (!this.spawnedOres.isEmpty()) break block5;
                for (Direction dir : Direction.values()) {
                    BlockPos checkPos = this.f_58858_.m_121945_(dir);
                    if (!this.isValidGrowthPosition(level, checkPos)) continue;
                    validPositions.add(checkPos);
                }
                break block6;
            }
            for (BlockPos orePos : this.spawnedOres) {
                for (Direction dir : Direction.values()) {
                    int adjacentOres;
                    BlockPos checkPos = orePos.m_121945_(dir);
                    if (checkPos.equals((Object)this.f_58858_) || this.spawnedOres.contains(checkPos) || !this.isValidGrowthPosition(level, checkPos) || (adjacentOres = this.countAdjacentOres(checkPos)) <= 0 || adjacentOres >= 4) continue;
                    validPositions.add(checkPos);
                }
            }
            if (!validPositions.isEmpty()) break block6;
            for (BlockPos orePos : this.spawnedOres) {
                Direction[] preferredDirs;
                for (Direction dir : preferredDirs = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
                    BlockPos checkPos = orePos.m_121945_(dir);
                    if (checkPos.equals((Object)this.f_58858_) || this.spawnedOres.contains(checkPos) || !this.isValidGrowthPosition(level, checkPos)) continue;
                    validPositions.add(checkPos);
                }
            }
        }
        return validPositions;
    }

    private boolean isValidGrowthPosition(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_152550_) || state.m_60713_(Blocks.f_50122_) || state.m_60713_(Blocks.f_50228_) || state.m_60713_(Blocks.f_50334_) || state.m_60713_(Blocks.f_152496_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_49994_);
    }

    private int countAdjacentOres(BlockPos pos) {
        int count = 0;
        for (Direction dir : Direction.values()) {
            if (!this.spawnedOres.contains(pos.m_121945_(dir))) continue;
            ++count;
        }
        return count;
    }

    private void validateSpawnedOres(ServerLevel level) {
        this.spawnedOres.removeIf(pos -> !level.m_8055_(pos).m_60713_((Block)ModBlocks.URANIUM_ORE.get()));
        if (this.spawnedOres.size() < 7 && this.hasReachedMax) {
            this.hasReachedMax = false;
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnedOres.clear();
        ListTag oreList = tag.m_128437_("SpawnedOres", 10);
        for (int i = 0; i < oreList.size(); ++i) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)oreList.m_128728_(i));
            this.spawnedOres.add(pos);
        }
        this.tickCounter = tag.m_128451_("TickCounter");
        this.hasReachedMax = tag.m_128471_("HasReachedMax");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag oreList = new ListTag();
        for (BlockPos pos : this.spawnedOres) {
            oreList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        tag.m_128365_("SpawnedOres", (Tag)oreList);
        tag.m_128405_("TickCounter", this.tickCounter);
        tag.m_128379_("HasReachedMax", this.hasReachedMax);
    }
}

