/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modern_missions", value={Dist.CLIENT})
public class CameraShakeHandler {
    private static final List<ShakeInstance> activeShakes = new ArrayList<ShakeInstance>();

    public static void addShake(BlockPos source, float intensity, float maxDistance, int durationTicks) {
        activeShakes.removeIf(shake -> shake.source.equals((Object)source));
        activeShakes.add(new ShakeInstance(source, intensity, maxDistance, durationTicks));
    }

    public static void addMissileShake(BlockPos source, int countdownTicks) {
        float progress = 1.0f - (float)countdownTicks / 200.0f;
        float intensity = countdownTicks < 20 ? 3.0f : (countdownTicks < 60 ? 2.0f + progress * 1.0f : (countdownTicks < 100 ? 1.0f + progress * 0.5f : 0.5f + progress * 0.25f));
        CameraShakeHandler.addShake(source, intensity, 50.0f, 5);
    }

    public static void addLaunchAfterShake(BlockPos source) {
        CameraShakeHandler.addShake(source, 2.5f, 60.0f, 30);
    }

    public static void addExplosionShake(BlockPos source, float intensity, int durationTicks) {
        CameraShakeHandler.addShake(source, intensity, 150.0f, durationTicks);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Iterator<ShakeInstance> it = activeShakes.iterator();
        while (it.hasNext()) {
            ShakeInstance shake = it.next();
            --shake.ticksRemaining;
            if (shake.ticksRemaining > 0) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (activeShakes.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        double playerX = mc.f_91074_.m_20185_();
        double playerY = mc.f_91074_.m_20186_() + (double)mc.f_91074_.m_20192_();
        double playerZ = mc.f_91074_.m_20189_();
        float totalShakeX = 0.0f;
        float totalShakeY = 0.0f;
        float totalShakeZ = 0.0f;
        for (ShakeInstance shake : activeShakes) {
            double dz;
            double dy;
            double dx;
            double distance;
            float intensity = shake.getIntensity(distance = Math.sqrt((dx = playerX - ((double)shake.source.m_123341_() + 0.5)) * dx + (dy = playerY - ((double)shake.source.m_123342_() + 0.5)) * dy + (dz = playerZ - ((double)shake.source.m_123343_() + 0.5)) * dz));
            if (!(intensity > 0.01f)) continue;
            float time = (float)(System.currentTimeMillis() % 10000L) / 100.0f;
            float shakeX = (float)(Math.sin((double)time * 12.7) * (double)intensity);
            float shakeY = (float)(Math.cos((double)time * 14.1) * (double)intensity * 0.7);
            float shakeZ = (float)(Math.sin((double)time * 16.4) * (double)intensity * 0.5);
            totalShakeX += (shakeX += (float)(Math.sin((double)time * 18.3) * (double)intensity * 0.3));
            totalShakeY += (shakeY += (float)(Math.sin((double)time * 9.7) * (double)intensity * 0.2));
            totalShakeZ += shakeZ;
        }
        if (Math.abs(totalShakeX) > 0.01f || Math.abs(totalShakeY) > 0.01f || Math.abs(totalShakeZ) > 0.01f) {
            totalShakeX = Mth.m_14036_((float)totalShakeX, (float)-5.0f, (float)5.0f);
            totalShakeY = Mth.m_14036_((float)totalShakeY, (float)-3.0f, (float)3.0f);
            totalShakeZ = Mth.m_14036_((float)totalShakeZ, (float)-2.0f, (float)2.0f);
            event.setPitch(event.getPitch() + totalShakeY);
            event.setYaw(event.getYaw() + totalShakeX);
            event.setRoll(event.getRoll() + totalShakeZ);
        }
    }

    public static class ShakeInstance {
        public final BlockPos source;
        public final float maxIntensity;
        public final float maxDistance;
        public int ticksRemaining;
        public int totalTicks;

        public ShakeInstance(BlockPos source, float intensity, float distance, int ticks) {
            this.source = source;
            this.maxIntensity = intensity;
            this.maxDistance = distance;
            this.ticksRemaining = ticks;
            this.totalTicks = ticks;
        }

        public float getIntensity(double distance) {
            if (distance > (double)this.maxDistance) {
                return 0.0f;
            }
            float distanceFactor = 1.0f - (float)(distance / (double)this.maxDistance);
            float timeFactor = (float)this.ticksRemaining / (float)this.totalTicks;
            return this.maxIntensity * distanceFactor * timeFactor;
        }
    }
}

