/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client;

import com.modernmissions.client.CameraShakeHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class NuclearExplosionRenderer {
    private static float flashIntensity = 0.0f;
    private static int flashDuration = 0;
    private static int flashTimer = 0;
    private static BlockPos explosionPos = null;
    private static final List<PendingShake> PENDING_SHAKES = new ArrayList<PendingShake>();

    public static void triggerFlash(BlockPos pos, float intensity, int duration) {
        double distance;
        explosionPos = pos;
        flashIntensity = intensity;
        flashDuration = duration;
        flashTimer = 0;
        if (Minecraft.m_91087_().f_91074_ != null && (distance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos))) < 150.0) {
            float initialIntensity = (float)(1.0 - distance / 150.0) * 3.0f;
            CameraShakeHandler.addExplosionShake(pos, initialIntensity, 20);
            int delayRumble = 10;
            float rumbleIntensity = (float)(1.0 - distance / 150.0) * 1.5f;
            PENDING_SHAKES.add(new PendingShake(pos, rumbleIntensity, delayRumble, 100));
            int delayAftershock = 40;
            float aftershockIntensity = (float)(1.0 - distance / 150.0) * 0.5f;
            PENDING_SHAKES.add(new PendingShake(pos, aftershockIntensity, delayAftershock, 40));
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (flashTimer < flashDuration) {
            float alpha;
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics graphics = event.getGuiGraphics();
            float progress = (float)flashTimer / (float)flashDuration;
            float colorShift = 1.0f;
            if (progress < 0.02f) {
                alpha = flashIntensity;
                colorShift = 1.0f;
            } else if (progress < 0.05f) {
                alpha = flashIntensity * 0.95f;
                colorShift = 1.0f;
            } else if (progress < 0.15f) {
                alpha = flashIntensity * (0.95f - (progress - 0.05f) * 2.0f);
                colorShift = 1.0f - (progress - 0.05f) * 3.0f;
            } else if (progress < 0.4f) {
                alpha = flashIntensity * 0.5f * (1.0f - (progress - 0.15f) / 0.25f);
                colorShift = 0.7f - (progress - 0.15f);
            } else {
                alpha = flashIntensity * 0.3f * (1.0f - (progress - 0.4f) / 0.6f);
                colorShift = 0.4f;
            }
            if (alpha > 0.01f) {
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int red = 255;
                int green = (int)(255.0f * Math.min(1.0f, colorShift + 0.2f));
                int blue = (int)(255.0f * colorShift);
                if (progress < 0.1f && explosionPos != null) {
                    float distortion = (float)(Math.sin((double)flashTimer * 0.5) * 2.0);
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(distortion, distortion * 0.5f, 0.0f);
                }
                graphics.m_280509_(0, 0, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_(), (int)(alpha * 255.0f) << 24 | red << 16 | green << 8 | blue);
                if (progress < 0.05f) {
                    float pulseAlpha = (float)(Math.sin((double)flashTimer * 0.8) * (double)0.1f + (double)0.1f);
                    graphics.m_280509_(0, 0, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_(), (int)(pulseAlpha * 255.0f) << 24 | 0xFFFFFF);
                }
                if (progress < 0.1f && explosionPos != null) {
                    graphics.m_280168_().m_85849_();
                }
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
            }
            ++flashTimer;
        }
    }

    public static void tick() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (PENDING_SHAKES.isEmpty()) {
            return;
        }
        Iterator<PendingShake> it = PENDING_SHAKES.iterator();
        while (it.hasNext()) {
            PendingShake ps = it.next();
            --ps.delayTicks;
            if (ps.delayTicks > 0) continue;
            CameraShakeHandler.addExplosionShake(ps.pos, ps.intensity, ps.duration);
            it.remove();
        }
    }

    private static class PendingShake {
        final BlockPos pos;
        final float intensity;
        int delayTicks;
        final int duration;

        PendingShake(BlockPos pos, float intensity, int delayTicks, int duration) {
            this.pos = pos;
            this.intensity = intensity;
            this.delayTicks = delayTicks;
            this.duration = duration;
        }
    }
}

