/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.event;

import com.modernmissions.client.sound.ReactorSoundManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="modern_missions", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ReactorSoundHandler {
    private static final Set<BlockPos> activeReactors = new HashSet<BlockPos>();
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        ReactorSoundManager.stopAllReactorSounds();
        activeReactors.clear();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos pos : activeReactors) {
                if (!event.getChunk().m_7697_().equals((Object)new ChunkPos(pos))) continue;
                toRemove.add(pos);
                ReactorSoundManager.stopReactorSound(pos);
            }
            activeReactors.removeAll(toRemove);
        }
    }

    public static void addActiveReactor(BlockPos pos) {
        activeReactors.add(pos);
    }

    public static void removeActiveReactor(BlockPos pos) {
        activeReactors.remove(pos);
    }
}

