/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.orbital;

import com.modernmissions.config.CommonConfig;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.WorldData;

public class MinimapTileCache {
    private final Minecraft mc;
    private static final Map<TileKey, Tile> CACHE = new HashMap<TileKey, Tile>();
    private static String CURRENT_WORLD_KEY = null;
    private static String CURRENT_WORLD_NAME = null;
    private final DynamicTexture placeholderTexture;
    private final ResourceLocation placeholderLoc;
    private static final int MAX_CACHE_SIZE = 1024;
    private static final long CACHE_LIFETIME = 600000000000L;
    private static final int TILE_SIZE = 256;
    private static final int FAST_TILE_SIZE = 256;
    private static final String DISK_CACHE_VERSION = "v1";
    private File diskCacheDir;

    public MinimapTileCache(Minecraft mc) {
        this.mc = mc;
        this.ensureWorldContext();
        this.diskCacheDir = null;
        this.updateDiskCacheDir();
        NativeImage img = new NativeImage(256, 256, true);
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                boolean edge = x == 0 || y == 0 || x == 255 || y == 255;
                img.m_84988_(x, y, edge ? -14013910 : -14935012);
            }
        }
        this.placeholderTexture = new DynamicTexture(img);
        this.placeholderLoc = new ResourceLocation("modern_missions", "minimap/placeholder");
        mc.m_91097_().m_118495_(this.placeholderLoc, (AbstractTexture)this.placeholderTexture);
    }

    public void prime(int centerChunkX, int centerChunkZ) {
        int budgetMs;
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        int scanRadius = (Integer)CommonConfig.MAP_PRIME_SCAN_RADIUS.get();
        if (scanRadius < 1) {
            scanRadius = 1;
        }
        if ((budgetMs = ((Integer)CommonConfig.MAP_PRIME_TIME_BUDGET_MS.get()).intValue()) < 1) {
            budgetMs = 1;
        }
        long start = System.nanoTime();
        long budgetNs = (long)budgetMs * 1000000L;
        for (int dist = 0; dist <= scanRadius; ++dist) {
            for (int dx = -dist; dx <= dist; ++dx) {
                for (int dz = -dist; dz <= dist; ++dz) {
                    if (Math.max(Math.abs(dx), Math.abs(dz)) != dist) continue;
                    if (System.nanoTime() - start >= budgetNs) {
                        return;
                    }
                    int cx = centerChunkX + dx;
                    int cz = centerChunkZ + dz;
                    ChunkAccess chunkAccess = level.m_6522_(cx, cz, ChunkStatus.f_62314_, false);
                    if (chunkAccess == null) continue;
                    TileKey key = new TileKey(cx, cz);
                    Tile existing = CACHE.get(key);
                    if (existing != null) {
                        boolean textureValid;
                        boolean bl = textureValid = existing.texture != null && !this.isTextureDisposed(existing.texture);
                        if (!textureValid) {
                            CACHE.remove(key);
                            existing = null;
                        }
                    }
                    if (existing != null || this.tryLoadFromDisk(cx, cz)) continue;
                    Tile newTile = this.generateTile(cx, cz, true);
                    this.putReplacing(key, newTile);
                    if (System.nanoTime() - start < budgetNs) continue;
                    return;
                }
            }
        }
    }

    private boolean tryLoadFromDisk(int chunkX, int chunkZ) {
        if (this.diskCacheDir == null) {
            return false;
        }
        this.ensureWorldContext();
        TileKey key = new TileKey(chunkX, chunkZ);
        File diskFile = this.diskPathFor(key);
        if (diskFile != null && diskFile.exists()) {
            boolean bl;
            String currentWorldId = this.getCurrentWorldIdentifier();
            if (!diskFile.getParentFile().getParentFile().getName().equals(currentWorldId.replaceAll("[^a-zA-Z0-9._-]", "_"))) {
                return false;
            }
            FileInputStream fis = new FileInputStream(diskFile);
            try {
                NativeImage img = NativeImage.m_85058_((InputStream)fis);
                DynamicTexture tex = new DynamicTexture(img);
                String safeDim = key.dimId.replace(':', '_').replace('/', '_');
                ResourceLocation loc = new ResourceLocation("modern_missions", "minimap/tile_" + safeDim + "_" + chunkX + "_" + chunkZ);
                this.mc.m_91097_().m_118495_(loc, (AbstractTexture)tex);
                this.putReplacing(key, new Tile(loc, tex, false, 256));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            fis.close();
            return bl;
        }
        return false;
    }

    private String getCurrentWorldIdentifier() {
        if (this.mc.m_91092_() != null) {
            WorldData worldData = this.mc.m_91092_().m_129910_();
            String worldName = worldData.m_5462_();
            long seed = this.mc.m_91092_().m_129783_().m_7328_();
            return worldName + "_" + seed;
        }
        if (this.mc.m_91089_() != null) {
            return this.mc.m_91089_().f_105363_.replace(":", "_").replace("/", "_");
        }
        return "unknown_world_" + System.currentTimeMillis();
    }

    public ResourceLocation getTile(int chunkX, int chunkZ, double scale) {
        Tile cached;
        this.ensureWorldContext();
        TileKey key = new TileKey(chunkX, chunkZ);
        Tile tile = CACHE.get(key);
        if (tile != null) {
            boolean textureValid;
            boolean bl = textureValid = tile.texture != null && !this.isTextureDisposed(tile.texture);
            if (!textureValid) {
                CACHE.remove(key);
                tile = null;
            } else {
                ChunkAccess chunkAccess;
                tile.lastUse = System.nanoTime();
                if (tile.fast && this.mc.f_91073_ != null && (chunkAccess = this.mc.f_91073_.m_6522_(chunkX, chunkZ, ChunkStatus.f_62314_, false)) != null) {
                    Tile newTile = this.generateTile(chunkX, chunkZ, false);
                    this.putReplacing(key, newTile);
                    return newTile.location;
                }
                return tile.location;
            }
        }
        if (this.tryLoadFromDisk(chunkX, chunkZ) && (cached = CACHE.get(key)) != null) {
            return cached.location;
        }
        Tile newTile = this.generateTile(chunkX, chunkZ, false);
        this.putReplacing(key, newTile);
        return newTile.location;
    }

    public void refreshPlaceholder(int chunkX, int chunkZ) {
        this.ensureWorldContext();
        if (this.mc.f_91073_ == null) {
            return;
        }
        ChunkAccess chunkAccess = this.mc.f_91073_.m_6522_(chunkX, chunkZ, ChunkStatus.f_62314_, false);
        if (chunkAccess == null) {
            return;
        }
        TileKey key = new TileKey(chunkX, chunkZ);
        Tile existing = CACHE.get(key);
        if (existing != null) {
            boolean textureValid;
            boolean bl = textureValid = existing.texture != null && !this.isTextureDisposed(existing.texture);
            if (!textureValid || existing.fast) {
                Tile updated = this.generateTile(chunkX, chunkZ, false);
                this.putReplacing(key, updated);
            }
        }
    }

    private Tile generateTile(int chunkX, int chunkZ, boolean fastMode) {
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return new Tile(this.placeholderLoc, this.placeholderTexture, true, 256);
        }
        this.ensureWorldContext();
        ChunkAccess chunkAccess = level.m_6522_(chunkX, chunkZ, ChunkStatus.f_62314_, false);
        if (chunkAccess == null) {
            NativeImage fogImg = new NativeImage(256, 256, true);
            for (int x = 0; x < 256; ++x) {
                for (int z = 0; z < 256; ++z) {
                    fogImg.m_84988_(x, z, -14671840);
                }
            }
            DynamicTexture fogTex = new DynamicTexture(fogImg);
            String safeDim = CURRENT_WORLD_KEY.replace(':', '_').replace('/', '_');
            ResourceLocation fogLoc = new ResourceLocation("modern_missions", "minimap/fog_" + safeDim + "_" + chunkX + "_" + chunkZ);
            this.mc.m_91097_().m_118495_(fogLoc, (AbstractTexture)fogTex);
            return new Tile(fogLoc, fogTex, true, 256);
        }
        int size = 256;
        int pixelsPerBlock = size / 16;
        NativeImage img = new NativeImage(size, size, true);
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                MapColor mapColor;
                int worldX = startX + blockX;
                int worldZ = startZ + blockZ;
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, worldX, worldZ) - 1;
                if (y < level.m_141937_()) {
                    y = level.m_141937_();
                } else if (y > level.m_151558_()) {
                    y = level.m_151558_() - 1;
                }
                pos.m_122178_(worldX, y, worldZ);
                BlockState state = level.m_8055_((BlockPos)pos);
                while (pos.m_123342_() > level.m_141937_() && ((state = level.m_8055_((BlockPos)pos)).m_60795_() || state.m_204336_(BlockTags.f_13041_) || state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_))) {
                    pos.m_122184_(0, -1, 0);
                }
                if (state.m_60795_() || pos.m_123342_() <= level.m_141937_()) {
                    state = Blocks.f_50752_.m_49966_();
                    pos.m_142448_(level.m_141937_());
                }
                if ((mapColor = state.m_284242_((BlockGetter)level, (BlockPos)pos)) == MapColor.f_283808_ && (mapColor = state.m_60734_().m_284356_()) == MapColor.f_283808_) {
                    mapColor = this.getSpecialBlockColor(state);
                }
                int brightness = 2;
                if (state.m_60819_().m_205070_(FluidTags.f_13131_) || state.m_60713_(Blocks.f_49990_)) {
                    int waterDepth;
                    BlockPos.MutableBlockPos waterPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    for (waterDepth = 0; waterDepth < 8 && waterPos.m_123342_() > level.m_141937_(); ++waterDepth) {
                        waterPos.m_122184_(0, -1, 0);
                        BlockState below = level.m_8055_((BlockPos)waterPos);
                        if (!below.m_60819_().m_205070_(FluidTags.f_13131_) && !below.m_60713_(Blocks.f_49990_)) break;
                    }
                    mapColor = MapColor.f_283864_;
                    int n = waterDepth > 4 ? 0 : (brightness = waterDepth > 2 ? 1 : 2);
                }
                if (state.m_60713_(Blocks.f_50440_)) {
                    mapColor = MapColor.f_283824_;
                } else if (state.m_204336_(BlockTags.f_13035_)) {
                    mapColor = MapColor.f_283915_;
                }
                if (!fastMode && worldZ > startZ) {
                    int northY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, worldX, worldZ - 1) - 1;
                    checkPos.m_122178_(worldX, northY, worldZ - 1);
                    while (checkPos.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)checkPos).m_60795_()) {
                        checkPos.m_122184_(0, -1, 0);
                    }
                    int heightDiff = checkPos.m_123342_() - pos.m_123342_();
                    if (heightDiff > 1) {
                        brightness = 0;
                    } else if (heightDiff > 0) {
                        brightness = 1;
                    } else if (heightDiff < -1) {
                        brightness = 3;
                    }
                }
                int color = this.getMapColor(mapColor, brightness);
                int abgr = this.toABGR(color);
                int startPx = blockX * pixelsPerBlock;
                int startPz = blockZ * pixelsPerBlock;
                for (int px = 0; px < pixelsPerBlock; ++px) {
                    for (int pz = 0; pz < pixelsPerBlock; ++pz) {
                        int imgX = startPx + px;
                        int imgZ = startPz + pz;
                        if (imgX < 0 || imgX >= size || imgZ < 0 || imgZ >= size) continue;
                        img.m_84988_(imgX, imgZ, abgr);
                    }
                }
            }
        }
        DynamicTexture tex = new DynamicTexture(img);
        String dim = this.mc.f_91073_ != null ? this.mc.f_91073_.m_46472_().m_135782_().toString() : "__no_level__";
        String safeDim = dim.replace(':', '_').replace('/', '_');
        ResourceLocation loc = new ResourceLocation("modern_missions", "minimap/tile_" + safeDim + "_" + chunkX + "_" + chunkZ);
        this.mc.m_91097_().m_118495_(loc, (AbstractTexture)tex);
        if (this.diskCacheDir != null) {
            try {
                File out = this.diskPathFor(new TileKey(chunkX, chunkZ));
                if (out != null) {
                    this.ensureParent(out);
                    img.m_85056_(out);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Tile(loc, tex, false, size);
    }

    private int getMapColor(MapColor mapColor, int brightness) {
        if (mapColor == MapColor.f_283808_) {
            return 0;
        }
        double multiplier = switch (brightness) {
            case 0 -> 0.71;
            case 1 -> 0.86;
            case 2 -> 1.0;
            case 3 -> 1.35;
            default -> 1.0;
        };
        int baseColor = mapColor.f_283871_;
        int r = baseColor >> 16 & 0xFF;
        int g = baseColor >> 8 & 0xFF;
        int b = baseColor & 0xFF;
        r = Mth.m_14045_((int)((int)((double)r * multiplier)), (int)0, (int)255);
        g = Mth.m_14045_((int)((int)((double)g * multiplier)), (int)0, (int)255);
        b = Mth.m_14045_((int)((int)((double)b * multiplier)), (int)0, (int)255);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int toABGR(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    private MapColor getSpecialBlockColor(BlockState state) {
        if (state.m_60734_() instanceof FlowerBlock) {
            return MapColor.f_283915_;
        }
        if (state.m_60734_() instanceof LeavesBlock) {
            return MapColor.f_283915_;
        }
        if (state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_)) {
            return MapColor.f_283811_;
        }
        if (state.m_60713_(Blocks.f_50126_) || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_)) {
            return MapColor.f_283828_;
        }
        if (state.m_60713_(Blocks.f_49991_)) {
            return MapColor.f_283750_;
        }
        if (state.m_60713_(Blocks.f_50141_)) {
            return MapColor.f_283761_;
        }
        if (state.m_60713_(Blocks.f_50451_)) {
            return MapColor.f_283913_;
        }
        if (state.m_60713_(Blocks.f_50692_)) {
            return MapColor.f_283772_;
        }
        return MapColor.f_283947_;
    }

    public void tick() {
        this.ensureWorldContext();
        if (CACHE.size() > 512) {
            this.cleanupOldTiles();
        }
    }

    private void ensureWorldContext() {
        boolean dimChanged;
        ClientLevel level = this.mc.f_91073_;
        String key = level == null ? "__no_level__" : level.m_46472_().m_135782_().toString();
        String worldName = this.getCurrentWorldIdentifier();
        boolean worldChanged = !Objects.equals(CURRENT_WORLD_NAME, worldName);
        boolean bl = dimChanged = !Objects.equals(CURRENT_WORLD_KEY, key);
        if (worldChanged && CURRENT_WORLD_NAME != null) {
            System.out.println("[MinimapCache] World changed from '" + CURRENT_WORLD_NAME + "' to '" + worldName + "' - clearing memory cache");
            CURRENT_WORLD_NAME = worldName;
            CURRENT_WORLD_KEY = key;
            MinimapTileCache.clearMemoryCache();
            this.updateDiskCacheDir();
        } else if (worldChanged && CURRENT_WORLD_NAME == null) {
            CURRENT_WORLD_NAME = worldName;
            CURRENT_WORLD_KEY = key;
            this.updateDiskCacheDir();
        } else if (dimChanged) {
            CURRENT_WORLD_KEY = key;
        }
    }

    private void updateDiskCacheDir() {
        File base;
        File gameDir = this.mc.f_91069_;
        String worldIdentifier = CURRENT_WORLD_NAME;
        if (worldIdentifier == null || worldIdentifier.isEmpty()) {
            worldIdentifier = "unknown_world";
        }
        if (!(base = new File(gameDir, "modern_missions" + File.separator + "cache" + File.separator + "minimap" + File.separator + (worldIdentifier = worldIdentifier.replaceAll("[^a-zA-Z0-9._-]", "_")))).exists()) {
            base.mkdirs();
        }
        this.diskCacheDir = base;
        System.out.println("[MinimapCache] Disk cache directory: " + this.diskCacheDir.getAbsolutePath());
    }

    private void putReplacing(TileKey key, Tile newTile) {
        Tile old = CACHE.put(key, newTile);
        if (old != null && old.texture != this.placeholderTexture && old.texture != newTile.texture) {
            try {
                old.texture.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setQuality(boolean high) {
    }

    public void onWorldJoin() {
        this.ensureWorldContext();
    }

    public void invalidateCache() {
        this.cleanupAllTiles();
        CACHE.clear();
        if (this.diskCacheDir != null && this.diskCacheDir.exists()) {
            this.deleteDirectory(this.diskCacheDir);
            this.diskCacheDir.mkdirs();
        }
    }

    public static void clearGlobalCache() {
        MinimapTileCache.clearMemoryCache();
        CURRENT_WORLD_KEY = null;
        CURRENT_WORLD_NAME = null;
        System.out.println("[MinimapCache] Memory cache cleared, disk cache preserved");
    }

    private static void clearMemoryCache() {
        for (Tile t : CACHE.values()) {
            try {
                if (t.texture == null) continue;
                t.texture.close();
            }
            catch (Exception exception) {}
        }
        CACHE.clear();
    }

    public void invalidateFogTilesAround(int centerChunkX, int centerChunkZ, int radiusChunks) {
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        for (int dx = -radiusChunks; dx <= radiusChunks; ++dx) {
            for (int dz = -radiusChunks; dz <= radiusChunks; ++dz) {
                ChunkAccess chunkAccess;
                int cx = centerChunkX + dx;
                int cz = centerChunkZ + dz;
                TileKey key = new TileKey(cx, cz);
                Tile existing = CACHE.get(key);
                if (existing == null || !existing.fast || (chunkAccess = level.m_6522_(cx, cz, ChunkStatus.f_62314_, false)) == null) continue;
                CACHE.remove(key);
                if (existing.texture == this.placeholderTexture) continue;
                try {
                    existing.texture.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
    }

    public int getQueueSize() {
        return 0;
    }

    public int getCacheSize() {
        return CACHE.size();
    }

    public int getTexSize(int chunkX, int chunkZ) {
        TileKey key = new TileKey(chunkX, chunkZ);
        Tile t = CACHE.get(key);
        if (t == null) {
            return 256;
        }
        return t.size;
    }

    private void cleanupOldTiles() {
        long now = System.nanoTime();
        CACHE.entrySet().removeIf(entry -> {
            Tile tile = (Tile)entry.getValue();
            if (now - tile.lastUse > 600000000000L) {
                try {
                    if (tile.texture != this.placeholderTexture) {
                        tile.texture.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        });
    }

    public void dispose() {
        for (Tile t : CACHE.values()) {
            try {
                if (t.texture == this.placeholderTexture) continue;
                t.texture.close();
            }
            catch (Exception exception) {}
        }
        CACHE.clear();
        try {
            this.placeholderTexture.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTextureDisposed(DynamicTexture texture) {
        try {
            NativeImage image = texture.m_117991_();
            return image == null;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void cleanupAllTiles() {
        for (Tile t : CACHE.values()) {
            try {
                if (t.texture == this.placeholderTexture) continue;
                t.texture.close();
            }
            catch (Exception exception) {}
        }
    }

    private File diskPathFor(TileKey key) {
        if (this.diskCacheDir == null) {
            return null;
        }
        String safeDim = key.dimId.replace(':', '_').replace('/', '_');
        File dimDir = new File(this.diskCacheDir, safeDim);
        return new File(dimDir, key.chunkX + "_" + key.chunkZ + "_v1.png");
    }

    private void ensureParent(File f) {
        File p = f.getParentFile();
        if (p != null && !p.exists()) {
            p.mkdirs();
        }
    }

    private static class TileKey {
        final String worldId;
        final String dimId;
        final int chunkX;
        final int chunkZ;

        TileKey(int chunkX, int chunkZ) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91092_() != null) {
                WorldData worldData = mc.m_91092_().m_129910_();
                String worldName = worldData.m_5462_();
                long seed = mc.m_91092_().m_129783_().m_7328_();
                this.worldId = worldName + "_" + seed;
            } else {
                this.worldId = mc.m_91089_() != null ? mc.m_91089_().f_105363_.replace(":", "_").replace("/", "_") : "__no_world__";
            }
            String id = mc.f_91073_ != null ? mc.f_91073_.m_46472_().m_135782_().toString() : "__no_level__";
            this.dimId = id;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TileKey)) {
                return false;
            }
            TileKey key = (TileKey)o;
            return this.chunkX == key.chunkX && this.chunkZ == key.chunkZ && Objects.equals(this.dimId, key.dimId) && Objects.equals(this.worldId, key.worldId);
        }

        public int hashCode() {
            int h = 17;
            h = 31 * h + (this.worldId == null ? 0 : this.worldId.hashCode());
            h = 31 * h + (this.dimId == null ? 0 : this.dimId.hashCode());
            h = 31 * h + this.chunkX;
            h = 31 * h + this.chunkZ;
            return h;
        }
    }

    private static class Tile {
        final ResourceLocation location;
        final DynamicTexture texture;
        final boolean fast;
        final int size;
        long lastUse = System.nanoTime();

        Tile(ResourceLocation location, DynamicTexture texture, boolean fast, int size) {
            this.location = location;
            this.texture = texture;
            this.fast = fast;
            this.size = size;
        }
    }
}

