/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.orbital;

import com.modernmissions.client.orbital.MinimapTileCache;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.C2SOrbitalStrikeRequestPacket;
import com.modernmissions.network.packet.C2SRequestLoadedChunksPacket;
import com.modernmissions.orbital.StrikeType;
import java.util.ArrayDeque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class OrbitalTargetingScreen
extends Screen {
    private static final int BACKDROP_COLOR = -1340071904;
    private static final int RETICLE = -2039584;
    private BlockPos center;
    private MinimapTileCache tileCache;
    private double scale = 4.0;
    private double panX = 0.0;
    private double panZ = 0.0;
    private int radius = 12;
    private boolean dragging = false;
    private double dragStartMouseX;
    private double dragStartMouseY;
    private double dragStartPanX;
    private double dragStartPanZ;
    private BlockPos cursorTarget = null;
    private boolean showHUD = true;
    private boolean typingCoords = false;
    private EditBox coordBox;
    private boolean awaitingStrike = false;
    private int pendingTicks = 0;
    private boolean showDebug = false;
    private int spiralR = 0;
    private int spiralK = 0;
    private int lastViewportHash = 0;
    private static final int SPIRAL_BUDGET_PER_TICK = 512;
    private final ArrayDeque<int[]> serverLoadedQueue = new ArrayDeque();
    private static OrbitalTargetingScreen CURRENT = null;
    private int serverRequestCooldown = 0;
    private static final int SERVER_REQ_INTERVAL_TICKS = 5;
    private static final int SERVER_REQ_MARGIN_CHUNKS = 32;
    private int updateTicks = 0;

    public OrbitalTargetingScreen(BlockPos startCenter) {
        super((Component)Component.m_237113_((String)"Satellite Targeting"));
        this.center = startCenter;
    }

    private void renderCountdownOverlay(GuiGraphics gui) {
        gui.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        int seconds = Math.max(0, (int)Math.ceil((double)this.pendingTicks / 20.0));
        String msg = "\u25c6 ORBITAL BOMBARDMENT INBOUND \u25c6";
        String countdown = "T-" + seconds + " SECONDS";
        int msgWidth = this.f_96547_.m_92895_(msg);
        int countWidth = this.f_96547_.m_92895_(countdown);
        int x1 = (this.f_96543_ - msgWidth) / 2;
        int x2 = (this.f_96543_ - countWidth) / 2;
        int y = this.f_96544_ / 2 - 20;
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)msg).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), x1, y, -49088);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)countdown).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}), x2, y + 14, -256);
        String hint = "Press ESC to close";
        int hw = this.f_96547_.m_92895_(hint);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)hint).m_130940_(ChatFormatting.GRAY), (this.f_96543_ - hw) / 2, y + 32, 0xC0C0C0);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.tileCache = new MinimapTileCache(Minecraft.m_91087_());
        if (this.tileCache != null && Minecraft.m_91087_().f_91073_ != null) {
            int cx = this.center.m_123341_() >> 4;
            int cz = this.center.m_123343_() >> 4;
            this.tileCache.invalidateFogTilesAround(cx, cz, 10);
            this.tileCache.prime(cx, cz);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    this.tileCache.refreshPlaceholder(cx + dx, cz + dz);
                }
            }
        }
        CURRENT = this;
        if (Minecraft.m_91087_().f_91073_ != null) {
            double halfWBlocks = (double)this.f_96543_ / (2.0 * this.scale);
            double halfHBlocks = (double)this.f_96544_ / (2.0 * this.scale);
            double viewCenterX = (double)this.center.m_123341_() - this.panX;
            double viewCenterZ = (double)this.center.m_123343_() - this.panZ;
            int minChunkX = (int)Math.floor((viewCenterX - halfWBlocks) / 16.0);
            int maxChunkX = (int)Math.ceil((viewCenterX + halfWBlocks) / 16.0);
            int minChunkZ = (int)Math.floor((viewCenterZ - halfHBlocks) / 16.0);
            int maxChunkZ = (int)Math.ceil((viewCenterZ + halfHBlocks) / 16.0);
            this.sendLoadedChunksRequest(minChunkX - 32, maxChunkX + 32, minChunkZ - 32, maxChunkZ + 32);
            this.serverRequestCooldown = 5;
        }
        if (this.typingCoords) {
            this.createOrShowCoordBox();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderBackdrop(gui);
        this.renderTiles(gui);
        this.renderAOE(gui, mouseX, mouseY);
        if (this.showHUD) {
            this.renderHUD(gui, mouseX, mouseY);
        }
        if (this.awaitingStrike) {
            this.renderCountdownOverlay(gui);
        }
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        if (this.tileCache != null) {
            this.tileCache.tick();
            ++this.updateTicks;
            if (this.updateTicks >= 40) {
                this.updateTicks = 0;
                int cx = (int)(((double)this.center.m_123341_() - this.panX) / 16.0);
                int cz = (int)(((double)this.center.m_123343_() - this.panZ) / 16.0);
                this.tileCache.invalidateFogTilesAround(cx, cz, 8);
            }
        }
    }

    private void renderTiles(GuiGraphics gui) {
        if (this.tileCache == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        double halfWBlocks = (double)this.f_96543_ / (2.0 * this.scale);
        double halfHBlocks = (double)this.f_96544_ / (2.0 * this.scale);
        double minWorldX = (double)this.center.m_123341_() - this.panX - halfWBlocks;
        double maxWorldX = (double)this.center.m_123341_() - this.panX + halfWBlocks;
        double minWorldZ = (double)this.center.m_123343_() - this.panZ - halfHBlocks;
        double maxWorldZ = (double)this.center.m_123343_() - this.panZ + halfHBlocks;
        int minChunkX = (int)Math.floor(minWorldX / 16.0);
        int maxChunkX = (int)Math.ceil(maxWorldX / 16.0);
        int minChunkZ = (int)Math.floor(minWorldZ / 16.0);
        int maxChunkZ = (int)Math.ceil(maxWorldZ / 16.0);
        int tilePixel = (int)Math.round(16.0 * this.scale);
        if (tilePixel < 1) {
            tilePixel = 1;
        }
        int centerCX = (minChunkX + maxChunkX) / 2;
        int centerCZ = (minChunkZ + maxChunkZ) / 2;
        for (int radius = 0; radius <= Math.max(maxChunkX - minChunkX, maxChunkZ - minChunkZ); ++radius) {
            for (int cx = centerCX - radius; cx <= centerCX + radius; ++cx) {
                for (int cz = centerCZ - radius; cz <= centerCZ + radius; ++cz) {
                    if (cx < minChunkX || cx > maxChunkX || cz < minChunkZ || cz > maxChunkZ || radius > 0 && Math.abs(cx - centerCX) < radius && Math.abs(cz - centerCZ) < radius) continue;
                    double chunkWorldX = (double)cx * 16.0;
                    double chunkWorldZ = (double)cz * 16.0;
                    int sx = this.screenX(chunkWorldX);
                    int sy = this.screenZ(chunkWorldZ);
                    if (sx + tilePixel < 0 || sx > this.f_96543_ || sy + tilePixel < 0 || sy > this.f_96544_) continue;
                    ResourceLocation loc = this.tileCache.getTile(cx, cz, this.scale);
                    int texSize = this.tileCache.getTexSize(cx, cz);
                    gui.m_280411_(loc, sx, sy, tilePixel, tilePixel, 0.0f, 0.0f, texSize, texSize, texSize, texSize);
                }
            }
        }
    }

    private void sendLoadedChunksRequest(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ) {
        int minX = Math.min(minChunkX, maxChunkX);
        int maxX = Math.max(minChunkX, maxChunkX);
        int minZ = Math.min(minChunkZ, maxChunkZ);
        int maxZ = Math.max(minChunkZ, maxChunkZ);
        ModNetworking.CHANNEL.sendToServer((Object)new C2SRequestLoadedChunksPacket(minX, maxX, minZ, maxZ));
    }

    private void renderBackdrop(GuiGraphics gui) {
        gui.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -1071636448);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.tileCache != null) {
            this.tileCache.dispose();
            this.tileCache = null;
        }
        if (CURRENT == this) {
            CURRENT = null;
        }
    }

    private void renderAOE(GuiGraphics gui, int mouseX, int mouseY) {
        BlockPos pos;
        this.cursorTarget = pos = this.worldPosAt(mouseX, mouseY);
        int segments = Math.max(24, Math.min(96, (int)Math.round((double)this.radius * this.scale * 1.5)));
        double angleStep = Math.PI * 2 / (double)segments;
        if ((double)this.radius * this.scale <= 16.0) {
            for (int r = 1; r < this.radius; ++r) {
                int alpha = (int)(40.0 * (1.0 - (double)r / (double)this.radius));
                int fillColor = alpha << 24 | 0xFF4020;
                int prevX = -1;
                int prevY = -1;
                for (int i = 0; i <= segments; ++i) {
                    double angle = (double)i * angleStep;
                    double dx = Math.cos(angle) * (double)r;
                    double dz = Math.sin(angle) * (double)r;
                    int sx = this.screenX((double)pos.m_123341_() + dx);
                    int sy = this.screenZ((double)pos.m_123343_() + dz);
                    if (i > 0 && prevX >= 0) {
                        this.drawLine(gui, prevX, prevY, sx, sy, fillColor);
                    }
                    prevX = sx;
                    prevY = sy;
                }
            }
        }
        int prevX = -1;
        int prevY = -1;
        for (int i = 0; i <= segments; ++i) {
            double angle = (double)i * angleStep;
            double dx = Math.cos(angle) * (double)this.radius;
            double dz = Math.sin(angle) * (double)this.radius;
            int sx = this.screenX((double)pos.m_123341_() + dx);
            int sy = this.screenZ((double)pos.m_123343_() + dz);
            if (i > 0) {
                this.drawLine(gui, prevX, prevY, sx, sy, -49120);
            }
            prevX = sx;
            prevY = sy;
        }
        int sx = this.screenX(pos.m_123341_());
        int sy = this.screenZ(pos.m_123343_());
        gui.m_280656_(sx - 8, sx + 8, sy, -2039584);
        gui.m_280315_(sx, sy - 8, sy + 8, -2039584);
        gui.m_280509_(sx - 2, sy - 2, sx + 3, sy + 3, -1);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            int px = this.screenX(mc.f_91074_.m_20185_());
            int py = this.screenZ(mc.f_91074_.m_20189_());
            this.drawTriangle(gui, px, py, 8, -16711936);
            gui.m_280488_(this.f_96547_, "YOU", px - 12, py + 10, -16711936);
        }
    }

    private void drawTriangle(GuiGraphics gui, int x, int y, int size, int color) {
        for (int dy = 0; dy < size; ++dy) {
            int width = size - dy;
            gui.m_280656_(x - width / 2, x + width / 2, y - size / 2 + dy, color);
        }
    }

    private void drawLine(GuiGraphics gui, int x0, int y0, int x1, int y1, int color) {
        int dx = Math.abs(x1 - x0);
        int dy = -Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            gui.m_280509_(x, y, x + 1, y + 1, color);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private void renderHUD(GuiGraphics gui, int mouseX, int mouseY) {
        int padding;
        int y = padding = 8;
        BlockPos pos = this.cursorTarget != null ? this.cursorTarget : this.center;
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u25c6 ORBITAL STRIKE SYSTEM \u25c6").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}), padding, y, 0xA0FFAA);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"TARGET: ").m_130940_(ChatFormatting.GRAY), padding, y += 14, 0xA0A0A0);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)String.format("X:%d Z:%d", pos.m_123341_(), pos.m_123343_())).m_130940_(ChatFormatting.WHITE), padding + 45, y, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"RADIUS: ").m_130940_(ChatFormatting.GRAY), padding, y += 11, 0xA0A0A0);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)(this.radius + "m")).m_130940_(ChatFormatting.YELLOW), padding + 45, y, 0xFFFF80);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"MODE: ").m_130940_(ChatFormatting.GRAY), padding + 100, y, 0xA0A0A0);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"BOMBARDMENT").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), padding + 140, y, 0xFFFF40);
        double zoomValue = this.scale / 0.5 * 25.0;
        String zoomPercent = String.format("%.0f%%", Math.max(5.0, Math.min(25.0, zoomValue)));
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"ZOOM: ").m_130940_(ChatFormatting.GRAY), padding, y += 11, 0xA0A0A0);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)zoomPercent).m_130940_(ChatFormatting.AQUA), padding + 40, y, 0x80FFFF);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && this.cursorTarget != null) {
            double dx = mc.f_91074_.m_20185_() - ((double)this.cursorTarget.m_123341_() + 0.5);
            double dz = mc.f_91074_.m_20189_() - ((double)this.cursorTarget.m_123343_() + 0.5);
            double dist = Math.sqrt(dx * dx + dz * dz);
            gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"DISTANCE: ").m_130940_(ChatFormatting.GRAY), padding + 100, y, 0xA0A0A0);
            String distStr = String.format("%.1fm", dist);
            ChatFormatting distColor = dist <= (double)this.radius ? ChatFormatting.RED : ChatFormatting.GREEN;
            gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)distStr).m_130940_(distColor), padding + 160, y, dist <= (double)this.radius ? 0xFF4040 : 0x40FF40);
            if (dist <= (double)this.radius) {
                boolean flash;
                y += 14;
                boolean bl = flash = System.currentTimeMillis() / 500L % 2L == 0L;
                if (flash) {
                    gui.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u26a0 DANGER CLOSE - YOU ARE IN BLAST RADIUS \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), padding, y, -65536);
                }
            }
        }
        y = this.f_96544_ - 30;
        if (this.f_96543_ < 800) {
            String controls1 = "LMB:Fire \u2022 RMB:Cancel \u2022 MMB:Pan \u2022 Scroll:Zoom";
            String controls2 = "Shift+Scroll:Radius";
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls1).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y, 0x808080);
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls2).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y + 10, 0x808080);
        } else if (this.f_96543_ < 1200) {
            String controls1 = "[LMB] Fire \u2022 [RMB] Cancel \u2022 [MMB] Pan \u2022 [Scroll] Zoom";
            String controls2 = "[Shift+Scroll] Radius";
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls1).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y, 0x808080);
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls2).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y + 10, 0x808080);
        } else {
            String controls1 = "[LMB] Fire \u2022 [RMB] Cancel \u2022 [MMB+Drag] Pan \u2022 [Scroll] Zoom";
            String controls2 = "[Shift+Scroll] Radius \u2022 [T] Coords";
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls1).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y, 0x808080);
            gui.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)controls2).m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, y + 10, 0x808080);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.awaitingStrike) {
            return false;
        }
        if (OrbitalTargetingScreen.m_96638_()) {
            int change = OrbitalTargetingScreen.m_96637_() ? 5 : 1;
            this.radius = Math.max(2, Math.min(128, this.radius + (delta > 0.0 ? change : -change)));
        } else {
            double oldScale = this.scale;
            double factor = delta > 0.0 ? 1.15 : 0.87;
            this.scale = Math.max(0.5, Math.min(16.0, this.scale * factor));
            if (oldScale != this.scale) {
                BlockPos mouseWorld = this.worldPosAt(mouseX, mouseY);
                double worldX = mouseWorld.m_123341_();
                double worldZ = mouseWorld.m_123343_();
                double screenCenterX = (double)this.f_96543_ / 2.0;
                double screenCenterY = (double)this.f_96544_ / 2.0;
                this.panX = -(worldX - (double)this.center.m_123341_() - (mouseX - screenCenterX) / this.scale);
                this.panZ = -(worldZ - (double)this.center.m_123343_() - (mouseY - screenCenterY) / this.scale);
            }
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.awaitingStrike) {
            return true;
        }
        if (button == 0 && this.cursorTarget != null) {
            ModNetworking.CHANNEL.sendToServer((Object)new C2SOrbitalStrikeRequestPacket(this.cursorTarget.m_123341_(), this.cursorTarget.m_123343_(), this.radius, StrikeType.CINEMATIC_BOMBARDMENT));
            this.awaitingStrike = true;
            this.pendingTicks = 140;
            return true;
        }
        if (button == 1) {
            this.m_7379_();
            return true;
        }
        if (button == 2) {
            this.dragging = true;
            this.dragStartMouseX = mouseX;
            this.dragStartMouseY = mouseY;
            this.dragStartPanX = this.panX;
            this.dragStartPanZ = this.panZ;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 2) {
            this.dragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.awaitingStrike) {
            return false;
        }
        if (this.dragging && button == 2) {
            double dx = mouseX - this.dragStartMouseX;
            double dy = mouseY - this.dragStartMouseY;
            this.panX = this.dragStartPanX - dx / this.scale;
            this.panZ = this.dragStartPanZ - dy / this.scale;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.awaitingStrike) {
            if (keyCode == 256) {
                this.m_7379_();
                return true;
            }
            return false;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                if (this.cursorTarget != null) {
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("Strike requested at X:" + this.cursorTarget.m_123341_() + " Z:" + this.cursorTarget.m_123343_() + " r=" + this.radius)), true);
                    }
                    this.m_7379_();
                }
                return true;
            }
            case 45: 
            case 259: {
                this.radius = Math.max(2, this.radius - (OrbitalTargetingScreen.m_96638_() ? 1 : 2));
                return true;
            }
            case 61: {
                this.radius = Math.min(128, this.radius + (OrbitalTargetingScreen.m_96638_() ? 1 : 2));
                return true;
            }
            case 87: {
                this.panZ -= 16.0 / this.scale;
                return true;
            }
            case 83: {
                this.panZ += 16.0 / this.scale;
                return true;
            }
            case 65: {
                this.panX -= 16.0 / this.scale;
                return true;
            }
            case 68: {
                this.panX += 16.0 / this.scale;
                return true;
            }
            case 84: {
                boolean bl = this.typingCoords = !this.typingCoords;
                if (this.typingCoords) {
                    this.createOrShowCoordBox();
                } else {
                    this.hideCoordBox();
                }
                return true;
            }
            case 72: {
                this.showDebug = !this.showDebug;
                return true;
            }
            case 81: {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.coordBox != null) {
            this.coordBox.m_94120_();
        }
        if (this.tileCache != null) {
            this.tileCache.tick();
        }
        this.requestTilesSpiralTick();
        if (this.serverRequestCooldown > 0) {
            --this.serverRequestCooldown;
        }
        int drain = 128;
        while (drain-- > 0 && !this.serverLoadedQueue.isEmpty()) {
            int[] pair = this.serverLoadedQueue.pollFirst();
            if (pair == null) continue;
            this.tileCache.refreshPlaceholder(pair[0], pair[1]);
            this.tileCache.getTile(pair[0], pair[1], this.scale);
        }
        if (this.awaitingStrike) {
            if (this.pendingTicks > 0) {
                --this.pendingTicks;
            }
            if (this.pendingTicks <= 0) {
                this.m_7379_();
            }
        }
    }

    public static void receiveLoadedChunks(String dimensionId, List<int[]> coords) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (!(screen instanceof OrbitalTargetingScreen)) {
            return;
        }
        OrbitalTargetingScreen s = (OrbitalTargetingScreen)screen;
        int cap = 8192;
        for (int[] pair : coords) {
            if (s.serverLoadedQueue.size() >= cap) break;
            s.serverLoadedQueue.addLast(pair);
        }
    }

    private void requestTilesSpiralTick() {
        int maxChunkZ;
        if (this.tileCache == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        double halfWBlocks = (double)this.f_96543_ / (2.0 * this.scale);
        double halfHBlocks = (double)this.f_96544_ / (2.0 * this.scale);
        double viewCenterX = (double)this.center.m_123341_() - this.panX;
        double viewCenterZ = (double)this.center.m_123343_() - this.panZ;
        int centerChunkX = (int)Math.floor(viewCenterX / 16.0);
        int centerChunkZ = (int)Math.floor(viewCenterZ / 16.0);
        int minChunkX = (int)Math.floor((viewCenterX - halfWBlocks) / 16.0);
        int maxChunkX = (int)Math.ceil((viewCenterX + halfWBlocks) / 16.0);
        int minChunkZ = (int)Math.floor((viewCenterZ - halfHBlocks) / 16.0);
        int viewportHash = centerChunkX * 0x700001 ^ centerChunkZ * 19349663 ^ minChunkX * 83492791 ^ minChunkZ * 297121507 ^ maxChunkX * 48271 ^ (maxChunkZ = (int)Math.ceil((viewCenterZ + halfHBlocks) / 16.0)) * 69697;
        if (viewportHash != this.lastViewportHash) {
            this.spiralR = 0;
            this.spiralK = 0;
            this.lastViewportHash = viewportHash;
            if (this.serverRequestCooldown <= 0) {
                this.sendLoadedChunksRequest(minChunkX - 32, maxChunkX + 32, minChunkZ - 32, maxChunkZ + 32);
                this.serverRequestCooldown = 5;
            }
        }
        int maxR = Math.max(Math.max(centerChunkX - minChunkX, maxChunkX - centerChunkX), Math.max(centerChunkZ - minChunkZ, maxChunkZ - centerChunkZ));
        int budget = 512;
        while (budget > 0 && this.spiralR <= maxR) {
            if (this.spiralR == 0) {
                if (centerChunkX >= minChunkX && centerChunkX <= maxChunkX && centerChunkZ >= minChunkZ && centerChunkZ <= maxChunkZ) {
                    this.tileCache.getTile(centerChunkX, centerChunkZ, this.scale);
                    --budget;
                }
                this.spiralR = 1;
                this.spiralK = 0;
                continue;
            }
            int sideLen = 2 * this.spiralR;
            int perimeter = 8 * this.spiralR;
            while (budget > 0 && this.spiralK < perimeter) {
                int cx;
                int side = this.spiralK / sideLen;
                int idx = this.spiralK % sideLen;
                int cz = switch (side) {
                    case 0 -> {
                        cx = centerChunkX - this.spiralR + idx;
                        yield centerChunkZ - this.spiralR;
                    }
                    case 1 -> {
                        cx = centerChunkX + this.spiralR;
                        yield centerChunkZ - this.spiralR + idx;
                    }
                    case 2 -> {
                        cx = centerChunkX + this.spiralR - idx;
                        yield centerChunkZ + this.spiralR;
                    }
                    default -> {
                        cx = centerChunkX - this.spiralR;
                        yield centerChunkZ + this.spiralR - idx;
                    }
                };
                if (cx >= minChunkX && cx <= maxChunkX && cz >= minChunkZ && cz <= maxChunkZ) {
                    this.tileCache.getTile(cx, cz, this.scale);
                    --budget;
                }
                ++this.spiralK;
            }
            if (this.spiralK < perimeter) continue;
            ++this.spiralR;
            this.spiralK = 0;
        }
    }

    private void createOrShowCoordBox() {
        if (this.coordBox == null) {
            int w = 160;
            int h = 20;
            int x = 8;
            int y = this.f_96544_ - h - 8;
            this.coordBox = new EditBox(this.f_96547_, x, y, w, h, (Component)Component.m_237113_((String)"X Z"));
            this.coordBox.m_94199_(64);
            BlockPos seed = this.cursorTarget != null ? this.cursorTarget : this.center;
            this.coordBox.m_94144_(seed.m_123341_() + " " + seed.m_123343_());
            this.m_142416_((GuiEventListener)this.coordBox);
        }
        this.coordBox.m_94194_(true);
        this.coordBox.m_93692_(true);
    }

    private void hideCoordBox() {
        if (this.coordBox != null) {
            this.coordBox.m_94194_(false);
            this.coordBox.m_93692_(false);
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.coordBox != null && this.coordBox.m_94213_() && this.coordBox.m_93696_()) {
            return this.coordBox.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.coordBox != null && this.coordBox.m_94213_() && this.coordBox.m_93696_() && (keyCode == 257 || keyCode == 335)) {
            this.applyCoordBox();
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void applyCoordBox() {
        if (this.coordBox == null) {
            return;
        }
        String s = this.coordBox.m_94155_();
        Matcher m = Pattern.compile("-?\\d+").matcher(s);
        Integer x = null;
        Integer z = null;
        while (m.find()) {
            if (x == null) {
                x = Integer.parseInt(m.group());
                continue;
            }
            z = Integer.parseInt(m.group());
            break;
        }
        if (x != null && z != null) {
            this.center = new BlockPos(x.intValue(), 0, z.intValue());
            this.panX = 0.0;
            this.panZ = 0.0;
            this.cursorTarget = new BlockPos(x.intValue(), 0, z.intValue());
        }
        this.typingCoords = false;
        this.hideCoordBox();
    }

    private int screenX(double worldX) {
        double dx = (worldX - (double)this.center.m_123341_() + this.panX) * this.scale;
        return (int)Math.round((double)this.f_96543_ / 2.0 + dx);
    }

    private int screenZ(double worldZ) {
        double dz = (worldZ - (double)this.center.m_123343_() + this.panZ) * this.scale;
        return (int)Math.round((double)this.f_96544_ / 2.0 + dz);
    }

    private BlockPos worldPosAt(double mouseX, double mouseY) {
        double wx = (double)this.center.m_123341_() - this.panX + (mouseX - (double)this.f_96543_ / 2.0) / this.scale;
        double wz = (double)this.center.m_123343_() - this.panZ + (mouseY - (double)this.f_96544_ / 2.0) / this.scale;
        return new BlockPos((int)Math.floor(wx), 0, (int)Math.floor(wz));
    }
}

