/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.client.sound;

import com.modernmissions.ModernMissions;
import com.modernmissions.client.sound.ReactorAmbientSound;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReactorSoundManager {
    private static final Map<BlockPos, SoundInstance> activeReactorSounds = new HashMap<BlockPos, SoundInstance>();

    public static void startReactorSound(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            ModernMissions.LOGGER.warn("Cannot start reactor sound - level is null");
            return;
        }
        ReactorSoundManager.stopReactorSound(pos);
        ReactorAmbientSound sound = new ReactorAmbientSound(pos, (Level)mc.f_91073_);
        activeReactorSounds.put(pos, (SoundInstance)sound);
        mc.m_91106_().m_120367_((SoundInstance)sound);
        ModernMissions.LOGGER.info("Started reactor ambient sound at {} (total active: {})", (Object)pos, (Object)activeReactorSounds.size());
    }

    public static void stopReactorSound(BlockPos pos) {
        SoundInstance sound = activeReactorSounds.remove(pos);
        if (sound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(sound);
            ModernMissions.LOGGER.info("Stopped reactor ambient sound at {} (remaining: {})", (Object)pos, (Object)activeReactorSounds.size());
        }
    }

    public static void stopAllReactorSounds() {
        Minecraft mc = Minecraft.m_91087_();
        int count = activeReactorSounds.size();
        for (SoundInstance sound : activeReactorSounds.values()) {
            mc.m_91106_().m_120399_(sound);
        }
        activeReactorSounds.clear();
        ModernMissions.LOGGER.info("Stopped all {} reactor sounds", (Object)count);
    }
}

