/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.explosion.NuclearExplosionManager;
import com.modernmissions.init.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChemicalGasBombEntity
extends Projectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lifeTime = 0;
    private static final int MAX_LIFETIME = 400;
    private float acceleration = 0.0f;
    private int targetX = 0;
    private int targetZ = 0;
    private double targetY = 64.0;
    private Vec3 targetPos = Vec3.f_82478_;
    private boolean hasTarget = false;
    private boolean hasReachedCruiseAltitude = false;
    private boolean strikePhase = false;
    private boolean strikeDeployed = false;
    private double launchBaseY = Double.NaN;

    public ChemicalGasBombEntity(EntityType<? extends ChemicalGasBombEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    protected void m_8097_() {
    }

    public void setTargetCoordinates(int x, int z) {
        this.targetX = x;
        this.targetZ = z;
        double groundY = 64.0;
        if (this.m_9236_() != null) {
            groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        }
        this.targetY = groundY;
        this.targetPos = new Vec3((double)x + 0.5, groundY, (double)z + 0.5);
        this.hasTarget = true;
        this.hasReachedCruiseAltitude = false;
        this.strikePhase = false;
        this.strikeDeployed = false;
    }

    public void m_8119_() {
        Vec3 finalMotion;
        Vec3 newMotion;
        ++this.lifeTime;
        if (Double.isNaN(this.launchBaseY)) {
            this.launchBaseY = this.m_20186_();
        }
        if (this.m_20186_() > 512.0 || this.lifeTime > 400) {
            if (!this.m_9236_().f_46443_) {
                this.explodeAndRemove();
            }
            return;
        }
        Vec3 currentMotion = this.m_20184_();
        if (this.strikePhase && this.hasTarget) {
            Vec3 aimPoint = new Vec3(this.targetPos.f_82479_, this.targetY, this.targetPos.f_82481_);
            Vec3 currentPos = this.m_20182_();
            Vec3 toTarget = aimPoint.m_82546_(currentPos);
            double distance = toTarget.m_82553_();
            if (distance > 0.001) {
                double speed = Math.min(2.4 + distance * 0.02, 5.6);
                if (currentPos.f_82480_ - this.targetY < 12.0) {
                    speed = Math.min(speed + 1.4, 6.2);
                }
                newMotion = toTarget.m_82541_().m_82490_(speed);
            } else {
                newMotion = new Vec3(0.0, -3.0, 0.0);
            }
        } else {
            double climbSpeed = Math.min(3.0 + (double)this.lifeTime * 0.25, 12.0);
            this.acceleration = (float)climbSpeed;
            double vy = climbSpeed;
            newMotion = new Vec3(0.0, vy, 0.0);
            if (!this.m_9236_().f_46443_ && this.hasTarget && !this.strikeDeployed) {
                if (this.lifeTime >= 100) {
                    this.deployStrikeProjectile();
                    return;
                }
                double deploymentAltitude = Math.max(this.launchBaseY + 200.0, this.targetY + 200.0);
                if (this.m_20186_() >= deploymentAltitude) {
                    this.deployStrikeProjectile();
                    return;
                }
            }
        }
        this.m_20256_(newMotion);
        this.f_19812_ = true;
        this.f_19794_ = !this.strikePhase && this.lifeTime < 40;
        this.m_20242_(true);
        this.f_19794_ = this.strikePhase || this.f_19794_;
        this.m_6034_(this.m_20185_() + newMotion.f_82479_, this.m_20186_() + newMotion.f_82480_, this.m_20189_() + newMotion.f_82481_);
        super.m_8119_();
        if (!this.strikePhase && !this.m_9236_().f_46443_ && this.lifeTime <= 40 && this.m_20186_() < this.launchBaseY + (double)this.lifeTime * 0.15) {
            this.m_6034_(this.m_20185_(), this.launchBaseY + (double)this.lifeTime * 0.15, this.m_20189_());
        }
        if (!this.m_9236_().f_46443_) {
            boolean strikeImpact;
            double horizontalDistance = this.hasTarget ? Math.sqrt(Math.pow(this.m_20185_() - this.targetPos.f_82479_, 2.0) + Math.pow(this.m_20189_() - this.targetPos.f_82481_, 2.0)) : Double.MAX_VALUE;
            boolean reachedTarget = this.hasTarget && horizontalDistance <= 3.0 && Math.abs(this.m_20186_() - this.targetY) <= 3.0;
            boolean bl = strikeImpact = this.strikePhase && this.hasTarget && this.m_20186_() <= this.targetY + 2.5 && horizontalDistance <= 6.0;
            if (this.lifeTime > 40 && (this.m_20096_() || reachedTarget || strikeImpact)) {
                this.explodeAndRemove();
                return;
            }
            if (this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
                this.explodeAndRemove();
                return;
            }
            if (this.lifeTime >= 398) {
                this.explodeAndRemove();
                return;
            }
        }
        if ((finalMotion = this.m_20184_()).m_82556_() > 1.0E-6) {
            float yaw = (float)Math.toDegrees(Math.atan2(finalMotion.f_82479_, finalMotion.f_82481_));
            float pitch = (float)Math.toDegrees(-Math.atan2(finalMotion.f_82480_, Math.sqrt(finalMotion.f_82479_ * finalMotion.f_82479_ + finalMotion.f_82481_ * finalMotion.f_82481_)));
            this.m_146922_(yaw);
            this.m_146926_(pitch);
        }
        this.createParticleTrail();
        if (this.lifeTime % 10 == 0 && !this.m_9236_().f_46443_) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11702_, SoundSource.NEUTRAL, 2.0f, 0.5f);
            if (this.lifeTime < 60) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11936_, SoundSource.NEUTRAL, 1.5f, 0.3f);
            }
        }
    }

    private void createParticleTrail() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                int i;
                double dz;
                double dy;
                double dx = player.m_20185_() - this.m_20185_();
                double distanceSq = dx * dx + (dy = player.m_20186_() - this.m_20186_()) * dy + (dz = player.m_20189_() - this.m_20189_()) * dz;
                if (!(distanceSq < 262144.0)) continue;
                double yOffset1 = this.strikePhase ? 0.2 : -0.2;
                double yOffset2 = this.strikePhase ? 0.4 : -0.4;
                double yOffset3 = this.strikePhase ? 0.6 : -0.6;
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20186_() + yOffset1, this.m_20189_(), 3, 0.05, 0.05, 0.05, 0.02);
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123778_, true, this.m_20185_(), this.m_20186_() + yOffset2, this.m_20189_(), 2, 0.1, 0.1, 0.1, 0.01);
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_(), this.m_20186_() + yOffset3, this.m_20189_(), 5, 0.2, 0.2, 0.2, 0.02);
                if (this.lifeTime % 3 == 0) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() - 0.2, this.m_20189_(), 1, 0.1, 0.1, 0.1, 0.02);
                }
                if (this.lifeTime >= 120) continue;
                for (i = 0; i < 8; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + offsetX, this.m_20186_() - 0.5, this.m_20189_() + offsetZ, 2, 0.0, -0.3, 0.0, 0.1);
                }
                for (i = 0; i < 5; ++i) {
                    double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
                    double radius = 0.4 + this.f_19796_.m_188500_() * 0.3;
                    double offsetX = Math.cos(angle) * radius;
                    double offsetZ = Math.sin(angle) * radius;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + offsetX, this.m_20186_() - 0.6, this.m_20189_() + offsetZ, 1, offsetX * 0.1, -0.4, offsetZ * 0.1, 0.05);
                }
            }
        }
    }

    private void deployStrikeProjectile() {
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (!this.strikeDeployed && this.hasTarget) break block6;
            }
            return;
        }
        if (this.strikePhase) {
            return;
        }
        ChemicalGasBombEntity strike = (ChemicalGasBombEntity)((EntityType)ModEntities.CHEMICAL_GAS_BOMB.get()).m_20615_((Level)serverLevel);
        if (strike == null) {
            return;
        }
        double spawnY = Math.max(this.targetY + 140.0, this.m_20186_());
        strike.m_6034_(this.targetPos.f_82479_, spawnY, this.targetPos.f_82481_);
        strike.m_20256_(new Vec3(0.0, -1.8, 0.0));
        strike.lifeTime = 0;
        strike.targetX = this.targetX;
        strike.targetZ = this.targetZ;
        strike.targetY = this.targetY;
        strike.targetPos = this.targetPos;
        strike.hasTarget = true;
        strike.hasReachedCruiseAltitude = true;
        strike.launchBaseY = spawnY;
        strike.acceleration = 0.0f;
        strike.strikePhase = true;
        strike.strikeDeployed = true;
        serverLevel.m_7967_((Entity)strike);
        System.out.println("[ChemDeploy] Spawned strike shell at (" + this.targetPos.f_82479_ + "," + spawnY + "," + this.targetPos.f_82481_ + ") targeting (" + this.targetX + "," + this.targetY + "," + this.targetZ + ")");
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 10, 0.3, 0.3, 0.3, 0.05);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11772_, SoundSource.NEUTRAL, 2.0f, 0.4f);
        this.strikeDeployed = true;
        this.m_146870_();
    }

    private void explodeAndRemove() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NuclearExplosionManager.triggerChemicalExplosion((Level)serverLevel, this.m_20183_());
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.5, 0.5, 0.5, 0.0);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 4.0f, 0.9f);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11772_, SoundSource.NEUTRAL, 3.0f, 0.5f);
        }
        this.m_146870_();
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifeTime = tag.m_128451_("LifeTime");
        this.targetX = tag.m_128451_("TargetX");
        this.targetZ = tag.m_128451_("TargetZ");
        if (tag.m_128441_("TargetY")) {
            this.targetY = tag.m_128459_("TargetY");
        }
        this.targetPos = new Vec3((double)this.targetX + 0.5, this.targetY, (double)this.targetZ + 0.5);
        this.hasTarget = tag.m_128471_("HasTarget");
        this.hasReachedCruiseAltitude = tag.m_128471_("HasReachedCruiseAltitude");
        this.strikePhase = tag.m_128471_("StrikePhase");
        this.strikeDeployed = tag.m_128471_("StrikeDeployed");
        if (tag.m_128441_("LaunchBaseY")) {
            this.launchBaseY = tag.m_128459_("LaunchBaseY");
        }
        this.acceleration = tag.m_128457_("Acceleration");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LifeTime", this.lifeTime);
        tag.m_128405_("TargetX", this.targetX);
        tag.m_128405_("TargetZ", this.targetZ);
        tag.m_128347_("TargetY", this.targetY);
        tag.m_128379_("HasTarget", this.hasTarget);
        tag.m_128379_("HasReachedCruiseAltitude", this.hasReachedCruiseAltitude);
        tag.m_128379_("StrikePhase", this.strikePhase);
        tag.m_128379_("StrikeDeployed", this.strikeDeployed);
        tag.m_128347_("LaunchBaseY", this.launchBaseY);
        tag.m_128350_("Acceleration", this.acceleration);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("flight"));
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getAcceleration() {
        return this.acceleration;
    }
}

