/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.explosion.NuclearExplosionManager;
import com.modernmissions.init.ModEntities;
import com.modernmissions.init.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NuclearMissileEntity
extends Projectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lifeTime = 0;
    private static final int MAX_LIFETIME = 600;
    private static final int LAUNCH_PHASE_DURATION = 60;
    private static final int WARNING_DELAY = 100;
    private static final int STRIKE_DEPLOY_TIME = 200;
    private static final int STRIKE_DESCENT_HEIGHT = 250;
    private float acceleration = 0.0f;
    private int targetX = 0;
    private int targetZ = 0;
    private double targetY = 64.0;
    private Vec3 targetPos = Vec3.f_82478_;
    private boolean hasTarget = false;
    private boolean hasReachedCruiseAltitude = false;
    private boolean strikePhase = false;
    private boolean strikeDeployed = false;
    private double launchBaseY = Double.NaN;
    private boolean warningPlayed = false;
    private int warningStartTick = -1;

    public NuclearMissileEntity(EntityType<? extends NuclearMissileEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    protected void m_8097_() {
    }

    public void setTargetCoordinates(int x, int z) {
        this.targetX = x;
        this.targetZ = z;
        double groundY = 64.0;
        if (this.m_9236_() != null) {
            groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        }
        this.targetY = groundY;
        this.targetPos = new Vec3((double)x + 0.5, groundY, (double)z + 0.5);
        this.hasTarget = true;
        this.hasReachedCruiseAltitude = false;
        this.strikePhase = false;
        this.strikeDeployed = false;
        System.out.println("[NuclearMissile] Target set to: (" + this.targetX + ", " + this.targetZ + ")");
    }

    public void m_8119_() {
        Vec3 finalMotion;
        Vec3 newMotion;
        ++this.lifeTime;
        if (Double.isNaN(this.launchBaseY)) {
            this.launchBaseY = this.m_20186_();
        }
        if (this.m_20186_() > 4096.0 || this.lifeTime > 600) {
            if (!this.m_9236_().f_46443_) {
                this.explodeAndRemove();
            }
            return;
        }
        Vec3 currentMotion = this.m_20184_();
        if (this.strikePhase && this.hasTarget) {
            Vec3 aimPoint = new Vec3(this.targetPos.f_82479_, this.targetY, this.targetPos.f_82481_);
            Vec3 currentPos = this.m_20182_();
            Vec3 toTarget = aimPoint.m_82546_(currentPos);
            double distance = toTarget.m_82553_();
            if (distance > 0.001) {
                double speed = Math.min(3.5 + distance * 0.03, 7.0);
                if (currentPos.f_82480_ - this.targetY < 20.0) {
                    speed = Math.min(speed + 2.0, 9.0);
                }
                newMotion = toTarget.m_82541_().m_82490_(speed);
            } else {
                newMotion = new Vec3(0.0, -5.0, 0.0);
            }
        } else if (this.lifeTime < 60) {
            double climbSpeed = 4.0 + (double)this.lifeTime * 0.3;
            this.acceleration = (float)climbSpeed;
            newMotion = new Vec3(0.0, climbSpeed, 0.0);
        } else {
            newMotion = new Vec3(0.0, 8.0, 0.0);
            if (!this.m_9236_().f_46443_ && !this.strikeDeployed) {
                if (this.hasTarget && this.lifeTime >= 200) {
                    System.out.println("[NuclearMissile] Deploying strike at tick " + this.lifeTime + " to target (" + this.targetX + ", " + this.targetZ + ")");
                    this.deployStrikeProjectile();
                    return;
                }
                if (this.lifeTime >= 210 && !this.hasTarget) {
                    System.out.println("[NuclearMissile] No target, despawning at tick " + this.lifeTime);
                    this.m_146870_();
                    return;
                }
            }
        }
        this.m_20256_(newMotion);
        this.f_19812_ = true;
        this.f_19794_ = !this.strikePhase && this.lifeTime < 40;
        this.m_20242_(true);
        boolean bl = this.f_19794_ = this.strikePhase || this.f_19794_;
        if (this.strikePhase) {
            this.m_6034_(this.m_20185_() + newMotion.f_82479_, this.m_20186_() + newMotion.f_82480_, this.m_20189_() + newMotion.f_82481_);
        } else {
            this.m_6034_(this.m_20185_() + newMotion.f_82479_, this.m_20186_() + newMotion.f_82480_, this.m_20189_() + newMotion.f_82481_);
        }
        super.m_8119_();
        if (!this.strikePhase && !this.m_9236_().f_46443_ && this.lifeTime <= 40 && this.m_20186_() < this.launchBaseY + (double)this.lifeTime * 0.15) {
            this.m_6034_(this.m_20185_(), this.launchBaseY + (double)this.lifeTime * 0.15, this.m_20189_());
        }
        if (!this.m_9236_().f_46443_ && this.lifeTime <= 40 && this.lifeTime % 5 == 0) {
            System.out.println("[NukeTick] t=" + this.lifeTime + " pos=(" + this.m_20185_() + "," + this.m_20186_() + "," + this.m_20189_() + ") vel=" + this.m_20184_());
        }
        if (!this.m_9236_().f_46443_) {
            boolean strikeImpact;
            double horizontalDistance;
            double d = horizontalDistance = this.hasTarget ? Math.sqrt(Math.pow(this.m_20185_() - this.targetPos.f_82479_, 2.0) + Math.pow(this.m_20189_() - this.targetPos.f_82481_, 2.0)) : Double.MAX_VALUE;
            if (this.lifeTime >= 100 && this.hasTarget && !this.warningPlayed && !this.strikePhase) {
                System.out.println("[NuclearMissile] Playing warning at target (" + this.targetX + ", " + this.targetZ + ")");
                this.playWarningForPlayersInTargetArea(true);
                this.warningPlayed = true;
                this.warningStartTick = this.lifeTime;
            }
            if (this.strikePhase && this.hasTarget && this.lifeTime % 20 == 0) {
                this.playWarningForPlayersInTargetArea(false);
            }
            boolean reachedTarget = this.hasTarget && horizontalDistance <= 3.0 && Math.abs(this.m_20186_() - this.targetY) <= 3.0;
            boolean bl2 = strikeImpact = this.strikePhase && this.hasTarget && this.m_20186_() <= this.targetY + 5.0 && horizontalDistance <= 6.0;
            if (this.lifeTime > 40 && (this.m_20096_() || reachedTarget || strikeImpact)) {
                if (this.strikePhase && this.m_20186_() < this.targetY) {
                    this.m_6034_(this.m_20185_(), this.targetY + 1.0, this.m_20189_());
                }
                this.explodeAndRemove();
                return;
            }
            if (this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
                this.explodeAndRemove();
                return;
            }
            if (this.lifeTime >= 598) {
                this.explodeAndRemove();
                return;
            }
            if (this.strikePhase && this.lifeTime % 10 == 0) {
                System.out.println("[NukeStrike] t=" + this.lifeTime + " pos=(" + this.m_20185_() + "," + this.m_20186_() + "," + this.m_20189_() + ") vel=" + this.m_20184_() + " targetY=" + this.targetY + " hd=" + horizontalDistance);
            }
        }
        if ((finalMotion = this.m_20184_()).m_82556_() > 1.0E-6) {
            float yaw = (float)Math.toDegrees(Math.atan2(finalMotion.f_82479_, finalMotion.f_82481_));
            float pitch = (float)Math.toDegrees(-Math.atan2(finalMotion.f_82480_, Math.sqrt(finalMotion.f_82479_ * finalMotion.f_82479_ + finalMotion.f_82481_ * finalMotion.f_82481_)));
            this.m_146922_(yaw);
            this.m_146926_(pitch);
        }
        this.createParticleTrail();
        if (this.lifeTime % 10 == 0 && !this.m_9236_().f_46443_) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11702_, SoundSource.NEUTRAL, 2.0f, 0.5f);
            if (this.lifeTime < 60) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11936_, SoundSource.NEUTRAL, 1.5f, 0.3f);
            }
        }
    }

    private void createParticleTrail() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            double distanceSq;
            double dz;
            double dy;
            double dx;
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                dx = player.m_20185_() - this.m_20185_();
                distanceSq = dx * dx + (dy = player.m_20186_() - this.m_20186_()) * dy + (dz = player.m_20189_() - this.m_20189_()) * dz;
                if (!(distanceSq < 262144.0)) continue;
                double yOffset1 = this.strikePhase ? 0.5 : -0.5;
                double yOffset2 = this.strikePhase ? 0.8 : -0.8;
                double yOffset3 = this.strikePhase ? 1.2 : -1.2;
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20186_() + yOffset1, this.m_20189_(), 3, 0.05, 0.05, 0.05, 0.02);
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123778_, true, this.m_20185_(), this.m_20186_() + yOffset2, this.m_20189_(), 2, 0.1, 0.1, 0.1, 0.01);
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_(), this.m_20186_() + yOffset3, this.m_20189_(), 5, 0.2, 0.2, 0.2, 0.02);
            }
            for (ServerPlayer player : serverLevel.m_6907_()) {
                int i;
                double ringOffset;
                dx = player.m_20185_() - this.m_20185_();
                distanceSq = dx * dx + (dy = player.m_20186_() - this.m_20186_()) * dy + (dz = player.m_20189_() - this.m_20189_()) * dz;
                if (!(distanceSq < 262144.0)) continue;
                double sparkOffset = this.strikePhase ? 0.5 : -0.5;
                double exhaustOffset = this.strikePhase ? 1.0 : -1.0;
                double d = ringOffset = this.strikePhase ? 1.2 : -1.2;
                if (this.lifeTime % 3 == 0) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, true, this.m_20185_(), this.m_20186_() + sparkOffset, this.m_20189_(), 1, 0.1, 0.1, 0.1, 0.02);
                }
                if (this.lifeTime >= 120) continue;
                for (i = 0; i < 8; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + offsetX, this.m_20186_() + exhaustOffset, this.m_20189_() + offsetZ, 2, 0.0, this.strikePhase ? 0.3 : -0.3, 0.0, 0.1);
                }
                for (i = 0; i < 5; ++i) {
                    double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
                    double radius = 0.4 + this.f_19796_.m_188500_() * 0.3;
                    double offsetX = Math.cos(angle) * radius;
                    double offsetZ = Math.sin(angle) * radius;
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + offsetX, this.m_20186_() + ringOffset, this.m_20189_() + offsetZ, 1, offsetX * 0.1, this.strikePhase ? 0.4 : -0.4, offsetZ * 0.1, 0.05);
                }
            }
        }
    }

    private void playWarningForPlayersInTargetArea(boolean playSound) {
        double altitudeAboveTarget;
        int secondsToImpact;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (playSound) {
            BlockPos targetBlockPos = new BlockPos(this.targetX, (int)this.targetY, this.targetZ);
            serverLevel.m_5594_(null, targetBlockPos, (SoundEvent)ModSounds.NUCLEAR_MISSILE_WARNING.get(), SoundSource.HOSTILE, 20.0f, 1.0f);
        }
        Object warningMessage = this.strikePhase ? ((secondsToImpact = (int)((altitudeAboveTarget = Math.max(0.0, this.m_20186_() - this.targetY)) / 40.0)) <= 3 ? "\u26a0\u26a0\u26a0 IMPACT IMMINENT \u26a0\u26a0\u26a0" : "\u26a0\u26a0 NUCLEAR STRIKE DESCENDING - " + secondsToImpact + " SECONDS \u26a0\u26a0") : "\u26a0 NUCLEAR MISSILE DETECTED - SEEK SHELTER \u26a0";
        for (ServerPlayer player : serverLevel.m_6907_()) {
            double dz;
            double dx = player.m_20185_() - (double)this.targetX;
            double distanceSq = dx * dx + (dz = player.m_20189_() - (double)this.targetZ) * dz;
            if (!(distanceSq < 40000.0)) continue;
            player.m_5661_((Component)Component.m_237113_((String)warningMessage).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}), true);
        }
    }

    private void explodeAndRemove() {
        System.out.println("[NuclearMissile] explodeAndRemove() called at " + this.m_20183_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos explosionPos = this.m_20183_();
            System.out.println("[NuclearMissile] Calling NuclearExplosionManager.triggerNuclearExplosion at " + explosionPos);
            NuclearExplosionManager.triggerNuclearExplosion((Level)serverLevel, explosionPos, true);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12089_, SoundSource.NEUTRAL, 5.0f, 0.5f);
        } else {
            System.out.println("[NuclearMissile] Not on server side, skipping explosion");
        }
        this.m_146870_();
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifeTime = tag.m_128451_("LifeTime");
        this.targetX = tag.m_128451_("TargetX");
        this.targetZ = tag.m_128451_("TargetZ");
        if (tag.m_128441_("TargetY")) {
            this.targetY = tag.m_128459_("TargetY");
        }
        this.hasTarget = tag.m_128471_("HasTarget");
        if (this.hasTarget) {
            this.targetPos = new Vec3((double)this.targetX + 0.5, this.targetY, (double)this.targetZ + 0.5);
        }
        this.hasReachedCruiseAltitude = tag.m_128471_("ReachedCruiseAltitude");
        this.strikePhase = tag.m_128471_("StrikePhase");
        this.strikeDeployed = tag.m_128471_("StrikeDeployed");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LifeTime", this.lifeTime);
        tag.m_128405_("TargetX", this.targetX);
        tag.m_128405_("TargetZ", this.targetZ);
        tag.m_128347_("TargetY", this.targetY);
        tag.m_128379_("HasTarget", this.hasTarget);
        tag.m_128379_("ReachedCruiseAltitude", this.hasReachedCruiseAltitude);
        tag.m_128379_("StrikePhase", this.strikePhase);
        tag.m_128379_("StrikeDeployed", this.strikeDeployed);
    }

    private void deployStrikeProjectile() {
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (!this.strikeDeployed && this.hasTarget) break block6;
            }
            return;
        }
        NuclearMissileEntity strike = (NuclearMissileEntity)((EntityType)ModEntities.NUCLEAR_MISSILE.get()).m_20615_((Level)serverLevel);
        if (strike == null) {
            return;
        }
        double spawnY = this.targetY + 250.0;
        strike.m_6034_(this.targetPos.f_82479_, spawnY, this.targetPos.f_82481_);
        strike.m_20256_(new Vec3(0.0, -3.0, 0.0));
        strike.lifeTime = 0;
        strike.targetX = this.targetX;
        strike.targetZ = this.targetZ;
        strike.targetY = this.targetY;
        strike.targetPos = this.targetPos;
        strike.hasTarget = true;
        strike.hasReachedCruiseAltitude = true;
        strike.launchBaseY = spawnY;
        strike.acceleration = 0.0f;
        strike.strikePhase = true;
        strike.strikeDeployed = true;
        strike.warningPlayed = true;
        serverLevel.m_7967_((Entity)strike);
        System.out.println("[NukeDeploy] Strike missile spawned at (" + this.targetPos.f_82479_ + "," + spawnY + "," + this.targetPos.f_82481_ + ") targeting (" + this.targetX + "," + this.targetY + "," + this.targetZ + ")");
        for (int i = 0; i < 10; ++i) {
            double offsetX = (serverLevel.f_46441_.m_188500_() - 0.5) * 10.0;
            double offsetZ = (serverLevel.f_46441_.m_188500_() - 0.5) * 10.0;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.targetPos.f_82479_ + offsetX, spawnY - 20.0, this.targetPos.f_82481_ + offsetZ, 3, 1.0, 1.0, 1.0, 0.1);
        }
        this.strikeDeployed = true;
        this.m_146870_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.nuclear_missile.activated")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

