/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.init.ModEntities;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class NuclearMushroomCloudEntity
extends Entity {
    private int lifeTime = 0;
    private static final int MAX_LIFETIME = 200;
    private int particleCounter = 0;
    private static final int PARTICLE_INTERVAL = 4;

    public NuclearMushroomCloudEntity(EntityType<? extends NuclearMushroomCloudEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public NuclearMushroomCloudEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends NuclearMushroomCloudEntity>)((EntityType)ModEntities.NUCLEAR_MUSHROOM_CLOUD.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTime;
        if (this.lifeTime >= 200) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            ++this.particleCounter;
            if (this.particleCounter % 4 == 0) {
                this.spawnMushroomParticles();
            }
        }
    }

    private void sendLongRangeParticles(ServerLevel level, ParticleOptions particle, double x, double y, double z, int count, double xDist, double yDist, double zDist, double speed) {
        for (ServerPlayer player : level.m_6907_()) {
            double distance = player.m_20275_(x, y, z);
            if (!(distance < 25600.0)) continue;
            level.m_7654_().m_6846_().m_11259_((UUID)player.m_20148_()).f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket(particle, true, x, y, z, (float)xDist, (float)yDist, (float)zDist, (float)speed, count));
        }
    }

    private void spawnMushroomParticles() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean thin = serverLevel.m_6907_().stream().mapToDouble(p -> p.m_20280_((Entity)this)).allMatch(d -> d > 10000.0);
        double columnHeight = Math.min(80.0, (double)this.lifeTime * 1.2);
        int y = 0;
        while ((double)y < columnHeight) {
            int rings = 5;
            for (int i = 0; i < rings; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)rings;
                double radius = 3.0 + Math.sin((double)y * 0.12) * 1.1;
                double px = this.m_20185_() + Math.cos(angle) * radius;
                double pz = this.m_20189_() + Math.sin(angle) * radius;
                this.sendLongRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123778_, px, this.m_20186_() + (double)y, pz, thin ? 1 : 2, 0.7, 0.45, 0.7, 0.0025);
                if (y >= 20 || i != 0 || this.lifeTime % 3 != 0) continue;
                this.sendLongRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)y, this.m_20189_(), 1, 0.5, 0.3, 0.5, 0.01);
            }
            y += 7;
        }
        if (columnHeight > 25.0) {
            double capRadius = Math.min(30.0, (double)(this.lifeTime - 20) * 0.8);
            double capY = this.m_20186_() + columnHeight;
            for (int angle = 0; angle < 360; angle += 24) {
                double rad = Math.toRadians(angle);
                int r = 0;
                while ((double)r < capRadius) {
                    double px = this.m_20185_() + Math.cos(rad) * (double)r;
                    double pz = this.m_20189_() + Math.sin(rad) * (double)r;
                    this.sendLongRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123778_, px, capY, pz, thin ? 1 : 2, 0.9, 0.55, 0.9, 0.0025);
                    if (r % 10 == 0) {
                        this.sendLongRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123762_, px, capY - 1.0, pz, 1, 0.5, 0.3, 0.5, 0.003);
                    }
                    r += 5;
                }
            }
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.lifeTime = compound.m_128451_("LifeTime");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("LifeTime", this.lifeTime);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return distance < 90000.0;
    }
}

