/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.entity;

import com.modernmissions.init.ModEntities;
import com.modernmissions.util.ExtendedParticleUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;

public class PoisonGasCloudEntity
extends Entity {
    private int lifeTime = 0;
    private static final int MAX_LIFETIME = 800;
    private static final double CLOUD_RADIUS = 20.0;
    private static final double CLOUD_HEIGHT = 10.0;
    private int particleSpawnCounter = 0;

    public PoisonGasCloudEntity(EntityType<? extends PoisonGasCloudEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public PoisonGasCloudEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends PoisonGasCloudEntity>)((EntityType)ModEntities.POISON_GAS_CLOUD.get()), level);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTime;
        if (this.lifeTime >= 800) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && this.lifeTime % 20 == 0) {
            this.applyPoisonEffects();
        }
        if (!this.m_9236_().f_46443_) {
            ++this.particleSpawnCounter;
            if (this.particleSpawnCounter % 3 == 0) {
                this.spawnGasParticles();
            }
        }
    }

    private void applyPoisonEffects() {
        AABB effectArea = new AABB(this.m_20185_() - 20.0, this.m_20186_() - 2.0, this.m_20189_() - 20.0, this.m_20185_() + 20.0, this.m_20186_() + 10.0, this.m_20189_() + 20.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity entity : entities) {
            double distance = entity.m_20182_().m_82554_(this.m_20182_());
            if (!(distance <= 20.0)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1, false, true));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0, false, true));
            if (!(distance <= 10.0)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0, false, true));
        }
    }

    private void spawnGasParticles() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float fadeProgress = (float)this.lifeTime / 800.0f;
        float intensity = fadeProgress < 0.1f ? fadeProgress * 10.0f : (fadeProgress > 0.8f ? 1.0f - (fadeProgress - 0.8f) * 5.0f : 1.0f);
        int baseParticles = 25;
        int particleCount = Math.max(3, (int)((float)baseParticles * intensity));
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)particleCount;
            double angle = t * Math.PI * 2.0 * 3.0;
            double radius = t * 20.0;
            double height = Math.sin(t * Math.PI * 2.0) * 10.0;
            double x = this.m_20185_() + Math.cos(angle) * radius;
            double y = this.m_20186_() + height + 2.0;
            double z = this.m_20189_() + Math.sin(angle) * radius;
            ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123778_, x, y, z, 2, 0.3, 0.2, 0.3, 0.005);
            if (i % 2 == 0) {
                ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123749_, x, y + 0.5, z, 5, 0.3, 0.3, 0.3, 0.02);
                ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, x, y, z, 2, 0.4, 0.3, 0.4, 0.01);
            }
            if (i % 3 != 0) continue;
            ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175833_, x, y + 1.0, z, 1, 0.5, 0.4, 0.5, 0.0);
        }
        int groundParticles = Math.max(5, (int)(15.0f * intensity));
        for (int g = 0; g < groundParticles; ++g) {
            double gAngle = (double)g / (double)groundParticles * Math.PI * 2.0;
            double gRadius = 20.0 * (0.8 + Math.random() * 0.4);
            double gx = this.m_20185_() + Math.cos(gAngle) * gRadius;
            double gy = this.m_20186_() - 0.5;
            double gz = this.m_20189_() + Math.sin(gAngle) * gRadius;
            ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123755_, gx, gy, gz, 2, 0.4, 0.1, 0.4, 0.002);
            if (g % 2 != 0) continue;
            ExtendedParticleUtil.sendExtendedRangeParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123749_, gx, gy + 0.2, gz, 2, 0.3, 0.05, 0.3, 0.01);
        }
        if (this.particleSpawnCounter % 6 == 0) {
            for (int p = 0; p < 5; ++p) {
                double pAngle = Math.random() * Math.PI * 2.0;
                double pRadius = Math.random() * 20.0 * 0.7;
                double px = this.m_20185_() + Math.cos(pAngle) * pRadius;
                double pz = this.m_20189_() + Math.sin(pAngle) * pRadius;
                for (int j = 0; j < 3; ++j) {
                    double py = this.m_20186_() + (double)(j * 2);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, px, py, pz, 1, 0.1, 0.3, 0.1, 0.02);
                }
            }
        }
        if (this.particleSpawnCounter % 9 == 0) {
            for (int d = 0; d < 8; ++d) {
                double dAngle = (double)d / 8.0 * Math.PI * 2.0;
                double dx = this.m_20185_() + Math.cos(dAngle) * 20.0;
                double dy = this.m_20186_() + 10.0;
                double dz = this.m_20189_() + Math.sin(dAngle) * 20.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175832_, dx, dy, dz, 1, 0.0, -0.2, 0.0, 0.05);
            }
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifeTime = tag.m_128451_("LifeTime");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LifeTime", this.lifeTime);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }
}

