/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.event;

import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModFluids;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modern_missions")
public class BucketEventHandler {
    @SubscribeEvent
    public static void onBucketFill(FillBucketEvent event) {
        Player player = event.getEntity();
        ItemStack bucket = event.getEmptyBucket();
        HitResult hitResult = event.getTarget();
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockState blockState = event.getLevel().m_8055_(blockHit.m_82425_());
        FluidState fluidState = event.getLevel().m_6425_(blockHit.m_82425_());
        if (blockState.m_60713_((Block)ModBlocks.OIL_SOURCE_BLOCK.get())) {
            event.setCanceled(true);
            if (!event.getLevel().f_46443_ && player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"This oil source cannot be collected!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        if (blockState.m_60713_((Block)ModBlocks.PURIFIED_WATER_SOURCE_BLOCK.get())) {
            event.setCanceled(true);
            if (!event.getLevel().f_46443_ && player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"This purified water source cannot be collected!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        if (!bucket.m_150930_(Items.f_42446_)) {
            return;
        }
        if (fluidState.m_76152_() == ModFluids.OIL_SOURCE.get() || fluidState.m_76152_() == ModFluids.OIL_FLOWING.get()) {
            event.setCanceled(true);
            if (!event.getLevel().f_46443_ && player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"You need an Empty Oil Bucket to collect oil!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        if (fluidState.m_76152_() == ModFluids.PURIFIED_WATER_SOURCE.get() || fluidState.m_76152_() == ModFluids.PURIFIED_WATER_FLOWING.get()) {
            event.setCanceled(true);
            if (!event.getLevel().f_46443_ && player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"You need an Empty Purified Water Bucket to collect purified water!").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
    }
}

