/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.explosion;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.entity.NuclearMushroomCloudEntity;
import com.modernmissions.entity.PoisonGasCloudEntity;
import com.modernmissions.network.ModNetworking;
import com.modernmissions.network.packet.S2CNuclearExplosionPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NuclearExplosionManager {
    private static final Map<UUID, Long> activeExplosions = new HashMap<UUID, Long>();
    private static final Map<UUID, ExplosionContext> explosionContexts = new HashMap<UUID, ExplosionContext>();
    private static final WeakHashMap<Explosion, Boolean> nuclearExplosions = new WeakHashMap();
    private static final Set<BlockPos> recentExplosionSites = new HashSet<BlockPos>();
    private static final int EXPLOSION_RADIUS = 30;
    private static final int RADIATION_RADIUS = 80;
    private static final int FLASH_RADIUS = 200;
    private static final int CHEMICAL_RADIUS = 30;

    public static boolean isNuclearExplosion(Explosion explosion) {
        return nuclearExplosions.containsKey(explosion);
    }

    public static void triggerNuclearExplosion(Level level, BlockPos pos, boolean hasActiveMissile) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        System.out.println("[NUCLEAR] triggerNuclearExplosion called at " + pos);
        if (recentExplosionSites.contains(pos)) {
            System.out.println("[NUCLEAR] Preventing chain reaction at " + pos);
            return;
        }
        recentExplosionSites.add(pos);
        UUID explosionId = UUID.randomUUID();
        activeExplosions.put(explosionId, System.currentTimeMillis());
        int startTick = serverLevel.m_7654_().m_129921_();
        explosionContexts.put(explosionId, new ExplosionContext(serverLevel, pos.m_7949_(), startTick));
        System.out.println("[NUCLEAR] Created explosion context for ID " + explosionId + " at " + pos + " startTick=" + startTick);
        System.out.println("[NUCLEAR] Starting explosion with ID: " + explosionId);
        NuclearExplosionManager.sendFlashToNearbyPlayers(serverLevel, pos);
        float basePower = hasActiveMissile ? 35.0f : 12.0f;
        Level.ExplosionInteraction explosionInteraction = (Boolean)CommonConfig.NON_DESTRUCTIVE_BLASTS.get() != false ? Level.ExplosionInteraction.NONE : Level.ExplosionInteraction.BLOCK;
        Explosion mainExplosion = level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, basePower, false, explosionInteraction);
        nuclearExplosions.put(mainExplosion, true);
        int secondaryCount = 20;
        for (int i = 0; i < secondaryCount; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double r = Math.sqrt(level.f_46441_.m_188500_()) * (hasActiveMissile ? 12.0 : 8.0);
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * r;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * r;
            double y = (double)pos.m_123342_() + (level.f_46441_.m_188500_() * 3.0 - 1.5);
            float power = basePower * (0.3f + level.f_46441_.m_188501_() * 0.5f);
            Explosion secondaryExplosion = level.m_255391_(null, x, y, z, power, false, explosionInteraction);
            nuclearExplosions.put(secondaryExplosion, true);
        }
        for (int wave = 1; wave <= 5; ++wave) {
            int currentWave = wave;
            int delay = wave * 10;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + delay, () -> {
                serverLevel.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 8.0f - (float)currentWave, 0.5f + serverLevel.f_46441_.m_188501_() * 0.3f);
                for (int j = 0; j < 3; ++j) {
                    double px = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 10.0;
                    double py = (double)pos.m_123342_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                    double pz = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 10.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, px, py, pz, 20, 2.0, 2.0, 2.0, 0.05);
                }
            }));
        }
        System.out.println("[NUCLEAR] Spawning mushroom cloud entity at " + pos);
        NuclearExplosionManager.spawnMushroomCloudEntity(serverLevel, pos);
        NuclearExplosionManager.applyRadiationEffects(serverLevel, pos);
        NuclearExplosionManager.createGroundZeroBatched(serverLevel, pos, (int)basePower);
        NuclearExplosionManager.playNuclearSounds(serverLevel, pos);
        serverLevel.m_7654_().execute(() -> serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 600, () -> NuclearExplosionManager.cleanupExplosion(explosionId))));
    }

    private static void spawnMushroomCloudEntity(ServerLevel level, BlockPos pos) {
        int worldSurface = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        int baseY = Math.max(worldSurface + 2, pos.m_123342_() + 5);
        System.out.println("[NUCLEAR] Creating mushroom cloud entity at Y=" + baseY + " (surface=" + worldSurface + ", explosion=" + pos.m_123342_() + ")");
        NuclearMushroomCloudEntity mushroomCloud = new NuclearMushroomCloudEntity((Level)level, (double)pos.m_123341_() + 0.5, baseY, (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)mushroomCloud);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, (double)baseY, (double)pos.m_123343_() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)baseY, (double)pos.m_123343_() + 0.5, 200, 4.0, 2.0, 4.0, 0.02);
    }

    private static void sendFlashToNearbyPlayers(ServerLevel level, BlockPos pos) {
        AABB flashArea = new AABB(pos).m_82400_(200.0);
        for (ServerPlayer player : level.m_45976_(ServerPlayer.class, flashArea)) {
            double distance = player.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            float intensity = (float)Math.max(0.0, 1.0 - distance / 200.0);
            ModNetworking.sendToPlayer(new S2CNuclearExplosionPacket(pos, intensity, (int)(intensity * 120.0f)), player);
        }
    }

    private static void spawnMushroomCloudAreaEffect(ServerLevel level, BlockPos pos, int baseY) {
        AreaEffectCloud cloud = new AreaEffectCloud((Level)level, (double)pos.m_123341_() + 0.5, (double)(baseY + 2), (double)pos.m_123343_() + 0.5);
        cloud.m_19724_((ParticleOptions)ParticleTypes.f_123755_);
        cloud.m_19712_(4.0f);
        cloud.m_19738_(0.02f);
        cloud.m_19734_(600);
        cloud.m_19740_(0);
        cloud.m_19732_(0.0f);
        level.m_7967_((Entity)cloud);
        System.out.println("[NUCLEAR] Spawned AreaEffectCloud fallback for mushroom visuals at Y=" + (baseY + 2));
    }

    private static void broadcastForcedParticles(ServerLevel level, ParticleOptions type, double x, double y, double z, int count, double dx, double dy, double dz, double speed) {
        for (ServerPlayer p : level.m_6907_()) {
            level.m_8624_(p, type, true, x, y, z, count, dx, dy, dz, speed);
        }
    }

    private static void createMushroomCloudDirect(ServerLevel level, BlockPos pos, UUID explosionId) {
        System.out.println("[NUCLEAR] Creating direct mushroom cloud at " + pos);
        int worldSurface = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        int sea = level.m_5736_();
        int minY = level.m_141937_() + 5;
        int maxY = level.m_151558_() - 20;
        int baseY = Math.max(Math.max(worldSurface, sea + 5), pos.m_123342_() + 20);
        baseY = Math.min(Math.max(baseY, minY), maxY);
        System.out.println("[NUCLEAR] Mushroom cloud baseY computed as " + baseY + " (surface=" + worldSurface + ", sea=" + sea + ") for pos " + pos);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, (double)(baseY + 2), (double)pos.m_123343_() + 0.5, 8, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)(baseY + 4), (double)pos.m_123343_() + 0.5, 80, 4.0, 2.0, 4.0, 0.02);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)(baseY + 2), (double)pos.m_123343_() + 0.5, 400, 6.0, 3.0, 6.0, 0.02);
        NuclearExplosionManager.broadcastForcedParticles(level, (ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, baseY + 2, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
        NuclearExplosionManager.broadcastForcedParticles(level, (ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, baseY + 2, (double)pos.m_123343_() + 0.5, 120, 6.0, 3.0, 6.0, 0.02);
        NuclearExplosionManager.spawnMushroomCloudAreaEffect(level, pos, baseY);
        for (int tick = 0; tick < 600; tick += 2) {
            int currentTick = tick;
            int finalBaseY = baseY;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + tick + 5, () -> {
                if (activeExplosions.containsKey(explosionId)) {
                    NuclearExplosionManager.spawnMushroomCloudParticles(level, pos, currentTick, finalBaseY);
                    if (currentTick % 40 == 0) {
                        double plumeY = (double)finalBaseY + Math.min(100.0, (double)currentTick * 0.3);
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, plumeY, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
                        NuclearExplosionManager.broadcastForcedParticles(level, (ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, plumeY, (double)pos.m_123343_() + 0.5, 60, 4.0, 2.0, 4.0, 0.015);
                    }
                }
            }));
        }
        System.out.println("[NUCLEAR] Scheduled 300 mushroom cloud particle updates");
    }

    private static void spawnMushroomCloudParticles(ServerLevel level, BlockPos pos, int tick, int baseY) {
        double pz;
        double px;
        if (tick <= 20 || tick % 100 == 0) {
            System.out.println("[NUCLEAR] Spawning mushroom cloud particles at tick " + tick + " pos=" + pos);
        }
        double columnHeight = Math.min(100.0, (double)tick * 0.3);
        int y = 0;
        while ((double)y < columnHeight) {
            double particleY = baseY + y;
            for (int i = 0; i < 12; ++i) {
                double angle = (double)i / 8.0 * Math.PI * 2.0;
                double radius = 2.5 + Math.sin((double)y * 0.12) * 1.8;
                px = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                pz = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, px, particleY, pz, 5, 0.6, 0.6, 0.6, 0.02);
            }
            y += 2;
        }
        if (tick > 200 && columnHeight > 50.0) {
            double capY = (double)baseY + columnHeight;
            double capRadius = Math.min(30.0, (double)(tick - 200) * 0.25);
            for (int angle = 0; angle < 360; angle += 12) {
                int r = 4;
                while ((double)r < capRadius) {
                    double rad = Math.toRadians(angle);
                    px = (double)pos.m_123341_() + 0.5 + Math.cos(rad) * (double)r;
                    pz = (double)pos.m_123343_() + 0.5 + Math.sin(rad) * (double)r;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, px, capY, pz, 8, 1.2, 1.2, 1.2, 0.01);
                    r += 2;
                }
            }
        }
    }

    private static void updateMushroomCloud(ServerLevel level, BlockPos pos, int tick, UUID explosionId) {
        double z;
        double z2;
        if (!activeExplosions.containsKey(explosionId)) {
            return;
        }
        if (tick <= 20 || tick % 100 == 0) {
            System.out.println("[NUCLEAR] Mushroom cloud update at tick " + tick + " pos=" + pos);
        }
        double progress = (double)tick / 600.0;
        int baseY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        if (tick == 0) {
            System.out.println("[NUCLEAR] Mushroom cloud baseY (surface) computed as " + baseY + " for pos " + pos + " (explosion at Y=" + pos.m_123342_() + ")");
        }
        if (baseY < 10) {
            baseY = Math.max(10, pos.m_123342_() + 20);
            if (tick == 0) {
                System.out.println("[NUCLEAR] Adjusted baseY to " + baseY + " for flat world visibility");
            }
        }
        double columnHeight = Math.min(100.0, (double)tick * 0.3);
        if (tick < 100 && tick % 10 == 0) {
            double explosionY = (double)baseY + (double)tick * 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_() + 0.5, explosionY, (double)pos.m_123343_() + 0.5, 1, 2.0, 1.0, 2.0, 0.0);
            if (tick % 20 == 0) {
                level.m_6263_(null, (double)pos.m_123341_() + 0.5, explosionY, (double)pos.m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.BLOCKS, 3.0f, 1.2f + level.f_46441_.m_188501_() * 0.3f);
            }
        }
        if (tick % 1 == 0) {
            int y = 0;
            while ((double)y < columnHeight) {
                int particlesInRing = 12;
                for (int i = 0; i < particlesInRing; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particlesInRing;
                    double radius = 5.0 + Math.sin((double)y * 0.05) * 2.0;
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                    z2 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, (double)(baseY + y), z2, 5, 0.3, 0.3, 0.3, 0.0);
                }
                if (y % 6 == 0) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123778_, (double)pos.m_123341_() + 0.5, (double)(baseY + y), (double)pos.m_123343_() + 0.5, 10, 2.0, 0.5, 2.0, 0.0);
                }
                y += 3;
            }
        }
        if (columnHeight > 50.0) {
            double capRadius = 30.0;
            double capY = (double)baseY + columnHeight;
            for (int ring = 0; ring < 8; ++ring) {
                double ringProgress = (double)ring / 8.0;
                double ringRadius = capRadius * Math.sin(ringProgress * Math.PI);
                double ringY = capY - ringProgress * 20.0;
                int particleCount = (int)(ringRadius * 2.0);
                for (int i = 0; i < particleCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particleCount;
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * ringRadius;
                    double z3 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * ringRadius;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, ringY, z3, 30, 0.8, 0.3, 0.8, 0.01);
                }
            }
        }
        if (tick < 20 && tick % 4 == 0) {
            double shockwaveRadius = (double)tick * 2.5;
            double shockwaveHeight = Math.max(0.0, 4.0 - (double)tick * 0.2);
            int particleCount = Math.min(15, (int)(shockwaveRadius * 0.8));
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * shockwaveRadius;
                z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * shockwaveRadius;
                BlockPos groundPos = new BlockPos((int)x, baseY + 5, (int)z);
                while (level.m_46859_(groundPos) && groundPos.m_123342_() > level.m_141937_()) {
                    groundPos = groundPos.m_7495_();
                }
                int h = 0;
                while ((double)h < shockwaveHeight) {
                    if ((double)level.f_46441_.m_188501_() < 0.8) {
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x + level.f_46441_.m_188583_() * 0.5, (double)(groundPos.m_123342_() + h + 1), z + level.f_46441_.m_188583_() * 0.5, 1, 0.3, 0.1, 0.3, 0.02);
                    }
                    ++h;
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, (double)groundPos.m_123342_() + shockwaveHeight / 2.0, z, 2, 0.5, shockwaveHeight / 4.0, 0.5, 0.01);
                if (i % 3 != 0) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, (double)groundPos.m_123342_() + 0.5, z, 3, 0.3, 0.2, 0.3, 0.08);
            }
            if (tick < 30) {
                double secondaryRadius = tick * 5;
                int secondaryCount = (int)(secondaryRadius * 2.0);
                for (int i = 0; i < secondaryCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)secondaryCount;
                    double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * secondaryRadius;
                    double z4 = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * secondaryRadius;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, (double)(baseY + 10), z4, 1, 0.1, 5.0, 0.1, 0.0);
                }
            }
        }
        if (tick > 80 && tick % 5 == 0) {
            int debrisCount = Math.min(30, 20 + (int)(progress * 15.0));
            double debrisRadius = 60.0 + progress * 40.0;
            for (int i = 0; i < debrisCount; ++i) {
                double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * debrisRadius * 2.0;
                double z5 = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * debrisRadius * 2.0;
                double y = (double)(pos.m_123342_() + 50) + level.f_46441_.m_188500_() * 30.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z5, 3, 0.5, -0.8, 0.5, 0.15);
                if (tick > 150) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123790_, x, y - 10.0, z5, 2, 0.3, -0.3, 0.3, 0.1);
                }
                if ((double)level.f_46441_.m_188501_() < 0.15) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123801_, x, y, z5, 1, 0.0, -0.5, 0.0, 0.0);
                }
                if (!((double)level.f_46441_.m_188501_() < 0.2)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_175827_, x, y - 5.0, z5, 1, 0.2, -0.2, 0.2, 0.05);
            }
            if (tick > 200 && tick < 350) {
                int rainCount = 30;
                double rainRadius = 80.0;
                for (int i = 0; i < rainCount; ++i) {
                    double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * rainRadius * 2.0;
                    z2 = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * rainRadius * 2.0;
                    double y = pos.m_123342_() + 70;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123765_, x, y, z2, 1, 0.0, -2.0, 0.0, 0.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123787_, x, y + 5.0, z2, 1, 0.1, -1.0, 0.1, 0.0);
                }
            }
        }
        if (tick < 200) {
            double heatRadius = 30.0 + (double)tick * 0.5;
            int shimmerCount = 15;
            for (int i = 0; i < shimmerCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)shimmerCount;
                double r = heatRadius * (0.8 + level.f_46441_.m_188500_() * 0.4);
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * r;
                z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * r;
                double y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 20.0;
                if ((double)level.f_46441_.m_188501_() < 0.3) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 1, 0.0, 0.5, 0.0, 0.1);
                }
                if (tick >= 40 || !((double)level.f_46441_.m_188501_() < 0.1)) continue;
                level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 10.0, z, 2, 1.0, 1.0, 1.0, 0.5);
            }
        }
    }

    private static void applyRadiationEffects(ServerLevel level, BlockPos pos) {
        AABB radiationArea = new AABB(pos).m_82400_(80.0);
        for (LivingEntity entity : level.m_45976_(LivingEntity.class, radiationArea)) {
            double distance = entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            if (distance < 30.0) {
                entity.m_6469_(level.m_269111_().m_269549_(), 100.0f);
                continue;
            }
            int duration = (int)(600.0 * (1.0 - distance / 80.0));
            int amplifier = distance < 45.0 ? 2 : 1;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, duration / 2, amplifier - 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration * 2, amplifier));
        }
    }

    private static void createGroundZeroBatched(ServerLevel level, BlockPos center, int radius) {
        int maxDelayPerBatch = 40;
        boolean step = true;
        int batchIndex = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                double horizontalDistance = Math.sqrt(x * x + z * z);
                if (horizontalDistance > (double)radius) continue;
                int fx = x;
                int fz = z;
                int delay = Math.min(batchIndex / 8, 40);
                level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay, () -> NuclearExplosionManager.processGroundZeroColumn(level, center, radius, fx, fz)));
                ++batchIndex;
            }
        }
    }

    private static void processGroundZeroColumn(ServerLevel level, BlockPos center, int radius, int x, int z) {
        for (int y = -radius / 2; y <= radius / 2; ++y) {
            BlockPos pos = center.m_7918_(x, y, z);
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance <= (double)radius) {
                if (level.f_46441_.m_188501_() < 0.2f && distance < (double)radius * 0.5 && level.m_8055_(pos).m_204336_(BlockTags.f_13029_)) {
                    level.m_7731_(pos, Blocks.f_50058_.m_49966_(), 2);
                }
                if (level.f_46441_.m_188501_() < 0.15f && !level.m_46859_(pos)) {
                    BlockState state = level.m_8055_(pos);
                    if (state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50440_)) {
                        level.m_7731_(pos, Blocks.f_50137_.m_49966_(), 2);
                    } else if (state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_50652_)) {
                        level.m_7731_(pos, Blocks.f_50730_.m_49966_(), 2);
                    } else if (state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13090_)) {
                        level.m_7731_(pos, Blocks.f_50353_.m_49966_(), 2);
                    }
                }
                if (!(level.f_46441_.m_188501_() < 0.005f) || !(distance < (double)radius * 0.3) || !level.m_46859_(pos)) continue;
                level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 2);
                continue;
            }
            if (!(distance > (double)radius) || !(distance < (double)radius * 1.8)) continue;
            BlockPos groundPos = pos;
            while (level.m_46859_(groundPos) && groundPos.m_123342_() > level.m_141937_()) {
                groundPos = groundPos.m_7495_();
            }
            BlockPos debrisPos = groundPos.m_7494_();
            double debrisChance = 0.15 * (1.0 - (distance - (double)radius) / ((double)radius * 0.8));
            if (!((double)level.f_46441_.m_188501_() < debrisChance) || !level.m_46859_(debrisPos)) continue;
            float rand = level.f_46441_.m_188501_();
            if ((double)rand < 0.3) {
                level.m_7731_(debrisPos, Blocks.f_50137_.m_49966_(), 2);
            } else if ((double)rand < 0.55) {
                level.m_7731_(debrisPos, Blocks.f_50730_.m_49966_(), 2);
            } else if ((double)rand < 0.7) {
                level.m_7731_(debrisPos, Blocks.f_152551_.m_49966_(), 2);
            } else if ((double)rand < 0.85) {
                level.m_7731_(debrisPos, Blocks.f_50450_.m_49966_(), 2);
            } else {
                level.m_7731_(debrisPos, Blocks.f_50353_.m_49966_(), 2);
            }
            if (!((double)level.f_46441_.m_188501_() < 0.3) || !level.m_46859_(debrisPos.m_7494_())) continue;
            BlockPos stackedDebris = debrisPos.m_7494_();
            if (level.f_46441_.m_188499_()) {
                level.m_7731_(stackedDebris, Blocks.f_50137_.m_49966_(), 2);
                continue;
            }
            level.m_7731_(stackedDebris, Blocks.f_50730_.m_49966_(), 2);
        }
    }

    private static void playNuclearSounds(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 10.0f, 0.5f);
        level.m_5594_(null, pos, SoundEvents.f_12563_, SoundSource.BLOCKS, 8.0f, 0.3f);
        int i = 1;
        while (i <= 5) {
            int delay = i++;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay * 20, () -> level.m_5594_(null, pos, SoundEvents.f_11894_, SoundSource.BLOCKS, 5.0f - (float)delay, 0.5f)));
        }
    }

    private static void cleanupExplosion(UUID explosionId) {
        System.out.println("[NUCLEAR] Cleaning up explosion ID: " + explosionId);
        activeExplosions.remove(explosionId);
        explosionContexts.remove(explosionId);
    }

    public static void onServerTick(MinecraftServer server) {
        if (server.m_129921_() % 20 == 0) {
            System.out.println("[NUCLEAR] onServerTick called - explosionContexts.size()=" + explosionContexts.size() + " at tick " + server.m_129921_());
        }
        if (explosionContexts.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<UUID, ExplosionContext>> entries = new ArrayList<Map.Entry<UUID, ExplosionContext>>(explosionContexts.entrySet());
        for (Map.Entry entry : entries) {
            UUID id = (UUID)entry.getKey();
            ExplosionContext ctx = (ExplosionContext)entry.getValue();
            ServerLevel level = ctx.level;
            int elapsed = server.m_129921_() - ctx.startTick;
            if (elapsed < 5) continue;
            int visualTick = elapsed - 5;
            if (visualTick > 600) {
                NuclearExplosionManager.cleanupExplosion(id);
                continue;
            }
            NuclearExplosionManager.updateMushroomCloud(level, ctx.center, visualTick, id);
        }
    }

    public static void triggerChemicalExplosion(Level level, BlockPos pos) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (recentExplosionSites.contains(pos)) {
            return;
        }
        recentExplosionSites.add(pos);
        System.out.println("Triggering chemical explosion at " + pos);
        float explosionPower = 10.0f;
        Explosion explosion = level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, explosionPower, false, Level.ExplosionInteraction.TNT);
        nuclearExplosions.put(explosion, true);
        NuclearExplosionManager.createToxicCloud(serverLevel, pos);
        NuclearExplosionManager.applyChemicalEffects(serverLevel, pos);
        NuclearExplosionManager.playChemicalSounds(serverLevel, pos);
        serverLevel.m_7654_().execute(() -> serverLevel.m_7654_().m_6937_((Runnable)new TickTask(serverLevel.m_7654_().m_129921_() + 100, () -> recentExplosionSites.remove(pos))));
    }

    private static void createToxicCloud(ServerLevel level, BlockPos pos) {
        PoisonGasCloudEntity gasCloud = new PoisonGasCloudEntity((Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)gasCloud);
        for (int tick = 0; tick < 60; ++tick) {
            int currentTick = tick;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + tick, () -> NuclearExplosionManager.updateToxicCloud(level, pos, currentTick)));
        }
    }

    private static void updateToxicCloud(ServerLevel level, BlockPos pos, int tick) {
        int i;
        double progress = (double)tick / 60.0;
        double radius = 30.0 * (1.0 - progress * 0.3);
        int particleCount = (int)(radius * 3.0);
        for (i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double distance = level.f_46441_.m_188500_() * radius;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * distance;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * distance;
            double y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 5.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 2, 0.2, 0.2, 0.2, 0.02);
            if ((double)level.f_46441_.m_188501_() < 0.5) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123749_, x, y + 0.5, z, 3, 0.1, 0.1, 0.1, 0.02);
            }
            if ((double)level.f_46441_.m_188501_() < 0.3) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.1, 0.1, 0.1, 0.01);
            }
            if (!((double)level.f_46441_.m_188501_() < 0.2)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175833_, x, y + 1.0, z, 1, 0.3, 0.3, 0.3, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            double x = (double)pos.m_123341_() + (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
            double z = (double)pos.m_123343_() + (level.f_46441_.m_188500_() - 0.5) * radius * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123757_, x, (double)pos.m_123342_() + 0.1, z, 3, 0.5, 0.1, 0.5, 0.0);
        }
    }

    private static void applyChemicalEffects(ServerLevel level, BlockPos pos) {
        AABB poisonArea = new AABB(pos).m_82400_(30.0);
        for (LivingEntity entity : level.m_45976_(LivingEntity.class, poisonArea)) {
            double distance = entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)pos));
            if (!(distance < 30.0)) continue;
            if (distance < 5.0) {
                entity.m_6469_(level.m_269111_().m_269425_(), 20.0f);
            }
            int duration = (int)(400.0 * (1.0 - distance / 30.0));
            int amplifier = distance < 10.0 ? 2 : (distance < 20.0 ? 1 : 0);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, duration * 2, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, amplifier));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, duration, 1));
        }
    }

    private static void playChemicalSounds(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 5.0f, 1.2f);
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 4.0f, 0.5f);
        int i = 0;
        while (i < 5) {
            int delay = i++;
            level.m_7654_().m_6937_((Runnable)new TickTask(level.m_7654_().m_129921_() + delay * 20, () -> level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 3.0f - (float)delay * 0.5f, 1.5f)));
        }
    }

    static {
        new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    recentExplosionSites.clear();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }).start();
    }

    private static class ExplosionContext {
        final ServerLevel level;
        final BlockPos center;
        final int startTick;

        ExplosionContext(ServerLevel level, BlockPos center, int startTick) {
            this.level = level;
            this.center = center;
            this.startTick = startTick;
        }
    }
}

