/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.item;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.block.entity.NuclearReactorScreenBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class NuclearTimerRemoteItem
extends Item {
    private static final String NBT_LINKED_POS = "LinkedReactorPos";
    private static final String NBT_LINKED_DIM = "LinkedReactorDimension";
    private static final int ALERT_TIME = 1200;
    private static final int FLASH_INTERVAL = 10;

    public NuclearTimerRemoteItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            BlockPos controllerPos = this.findNearbyController(level, pos);
            if (controllerPos != null) {
                BlockPos screenPos = this.findReactorScreen(level, controllerPos);
                if (screenPos != null) {
                    this.linkToReactor(stack, screenPos, level.m_46472_().m_135782_().toString());
                    if (!level.f_46443_) {
                        player.m_5661_((Component)Component.m_237113_((String)("Remote linked to reactor at " + screenPos.m_123344_())).m_130940_(ChatFormatting.GREEN), true);
                        level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)"No reactor screen found in multiblock!").m_130940_(ChatFormatting.RED), true);
                }
            } else if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"No reactor controller found nearby!").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResult.PASS;
    }

    private BlockPos findNearbyController(Level level, BlockPos startPos) {
        if (level.m_8055_(startPos).m_60734_() instanceof NuclearControllerBlock) {
            return startPos;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = startPos.m_7918_(x, y, z);
                    if (!(level.m_8055_(checkPos).m_60734_() instanceof NuclearControllerBlock)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    private BlockPos findReactorScreen(Level level, BlockPos startPos) {
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos checkPos = startPos.m_7918_(x, y, z);
                    BlockEntity be = level.m_7702_(checkPos);
                    if (!(be instanceof NuclearReactorScreenBlockEntity)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    private void linkToReactor(ItemStack stack, BlockPos pos, String dimension) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(NBT_LINKED_POS, pos.m_121878_());
        tag.m_128359_(NBT_LINKED_DIM, dimension);
    }

    public static BlockPos getLinkedPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(NBT_LINKED_POS)) {
            return BlockPos.m_122022_((long)tag.m_128454_(NBT_LINKED_POS));
        }
        return null;
    }

    public static String getLinkedDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(NBT_LINKED_DIM)) {
            return tag.m_128461_(NBT_LINKED_DIM);
        }
        return null;
    }

    public static int getTimeUntilCode(Level level, ItemStack stack) {
        BlockPos linkedPos = NuclearTimerRemoteItem.getLinkedPos(stack);
        String linkedDim = NuclearTimerRemoteItem.getLinkedDimension(stack);
        if (linkedPos == null || linkedDim == null) {
            return -1;
        }
        if (!level.m_46472_().m_135782_().toString().equals(linkedDim)) {
            return -2;
        }
        BlockEntity be = level.m_7702_(linkedPos);
        if (be instanceof NuclearReactorScreenBlockEntity) {
            NuclearReactorScreenBlockEntity screenBE = (NuclearReactorScreenBlockEntity)be;
            if (NuclearTimerRemoteItem.isAlarmActive(screenBE)) {
                return NuclearTimerRemoteItem.getAlarmCountdown(screenBE);
            }
            long currentTime = level.m_46467_();
            long timeSinceLastEntry = NuclearTimerRemoteItem.getTimeSinceLastCodeEntry(screenBE, level);
            if (timeSinceLastEntry < 0L) {
                return 24000;
            }
            if (timeSinceLastEntry >= 24000L) {
                return 0;
            }
            return (int)(24000L - timeSinceLastEntry);
        }
        return -3;
    }

    private static long getTimeSinceLastCodeEntry(NuclearReactorScreenBlockEntity be, Level level) {
        long lastEntry = be.getLastCodeEntryTime();
        if (lastEntry < 0L) {
            return -1L;
        }
        return level.m_46467_() - lastEntry;
    }

    private static boolean isAlarmActive(NuclearReactorScreenBlockEntity be) {
        return be.isAlarmActive();
    }

    private static int getAlarmCountdown(NuclearReactorScreenBlockEntity be) {
        return be.getAlarmCountdown();
    }

    public static boolean shouldAlert(ItemStack stack, Level level) {
        int timeRemaining = NuclearTimerRemoteItem.getTimeUntilCode(level, stack);
        return timeRemaining > 0 && timeRemaining <= 1200;
    }

    public static boolean shouldFlashTexture(ItemStack stack, Level level) {
        if (!NuclearTimerRemoteItem.shouldAlert(stack, level)) {
            return false;
        }
        return level.m_46467_() / 10L % 2L == 0L;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        BlockPos linkedPos = NuclearTimerRemoteItem.getLinkedPos(stack);
        if (linkedPos != null) {
            tooltip.add((Component)Component.m_237113_((String)("Linked to: " + linkedPos.m_123344_())).m_130940_(ChatFormatting.GREEN));
            if (level != null) {
                int timeRemaining = NuclearTimerRemoteItem.getTimeUntilCode(level, stack);
                if (timeRemaining == -2) {
                    tooltip.add((Component)Component.m_237113_((String)"Wrong dimension!").m_130940_(ChatFormatting.RED));
                } else if (timeRemaining == -3) {
                    tooltip.add((Component)Component.m_237113_((String)"Reactor not found!").m_130940_(ChatFormatting.RED));
                } else if (timeRemaining >= 0) {
                    int seconds = timeRemaining / 20;
                    int minutes = seconds / 60;
                    ChatFormatting color = timeRemaining <= 1200 ? ChatFormatting.RED : ChatFormatting.YELLOW;
                    tooltip.add((Component)Component.m_237113_((String)String.format("Time until code: %d:%02d", minutes, seconds %= 60)).m_130940_(color));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"Not linked").m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Shift + Right Click on reactor to link").m_130940_(ChatFormatting.GRAY));
        }
    }
}

