/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.item;

import com.modernmissions.block.NuclearControllerBlock;
import com.modernmissions.client.orbital.OrbitalTargetingScreen;
import com.modernmissions.client.renderer.SatelliteTransmitterRenderer;
import com.modernmissions.init.ModBlocks;
import com.modernmissions.init.ModItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.DistExecutor;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SatelliteTransmitterItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SatelliteTransmitterItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private SatelliteTransmitterRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SatelliteTransmitterRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SatelliteTransmitterItem> animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("animation.model.on", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("ReactorPos")) {
            BlockPos reactorPos = BlockPos.m_122022_((long)tag.m_128454_("ReactorPos"));
            tooltipComponents.add((Component)Component.m_237113_((String)"Linked to reactor at: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)String.format("[%d, %d, %d]", reactorPos.m_123341_(), reactorPos.m_123342_(), reactorPos.m_123343_())).m_130940_(ChatFormatting.AQUA)));
            tooltipComponents.add((Component)Component.m_237113_((String)"Right-click to call orbital strike").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.m_237113_((String)"Not linked to reactor!").m_130940_(ChatFormatting.RED));
            tooltipComponents.add((Component)Component.m_237113_((String)"Shift-right-click on nuclear reactor to link").m_130940_(ChatFormatting.YELLOW));
        }
        tooltipComponents.add((Component)Component.m_237113_((String)"Requires: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)"Signal Matrix").m_130940_(ChatFormatting.AQUA)));
        tooltipComponents.add((Component)Component.m_237113_((String)"Consumed per use").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("ReactorPos")) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Transmitter not linked to nuclear reactor!").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        boolean hasSignalMatrix = player.m_7500_();
        if (!hasSignalMatrix) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack invStack = player.m_150109_().m_8020_(i);
                if (invStack.m_41619_() || !invStack.m_150930_((Item)ModItems.SIGNAL_MATRIX.get())) continue;
                hasSignalMatrix = true;
                break;
            }
        }
        if (!hasSignalMatrix) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)"Signal Matrix required for orbital strike!").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.f_46443_) {
            BlockPos reactorPos = BlockPos.m_122022_((long)tag.m_128454_("ReactorPos"));
            BlockState state = level.m_8055_(reactorPos);
            if (!state.m_60713_((Block)ModBlocks.NUCLEAR_CONTROLLER.get())) {
                player.m_5661_((Component)Component.m_237113_((String)"Linked reactor no longer exists!").m_130940_(ChatFormatting.RED), true);
                tag.m_128473_("ReactorPos");
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!((Boolean)state.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                player.m_5661_((Component)Component.m_237113_((String)"Linked reactor is not active!").m_130940_(ChatFormatting.YELLOW), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        if (level.f_46443_) {
            BlockPos start = player.m_20183_();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.openTargeting(start));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && player.m_6144_() && (state = level.m_8055_(pos)).m_60713_((Block)ModBlocks.NUCLEAR_CONTROLLER.get())) {
            if (!level.f_46443_) {
                if (((Boolean)state.m_61143_((Property)NuclearControllerBlock.ACTIVE)).booleanValue()) {
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128356_("ReactorPos", pos.m_121878_());
                    player.m_5661_((Component)Component.m_237113_((String)"Transmitter linked to reactor!").m_130940_(ChatFormatting.GREEN), true);
                    level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"Reactor must be active to link!").m_130940_(ChatFormatting.YELLOW), true);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHooks {
        private ClientHooks() {
        }

        static void openTargeting(BlockPos start) {
            Minecraft.m_91087_().m_91152_((Screen)new OrbitalTargetingScreen(start));
        }
    }
}

