/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.loot;

import com.modernmissions.config.CommonConfig;
import com.modernmissions.init.ModBlocks;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class UraniumPotatoHarvestModifier
extends LootModifier {
    public static final Codec<UraniumPotatoHarvestModifier> CODEC = RecordCodecBuilder.create(inst -> UraniumPotatoHarvestModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, UraniumPotatoHarvestModifier::new));

    protected UraniumPotatoHarvestModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        CropBlock crop;
        Block block;
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ServerLevel level = context.m_78952_();
        BlockPos origin = BlockPos.m_274446_((Position)((Position)context.m_78953_(LootContextParams.f_81460_)));
        if (state == null || level == null || origin == null) {
            return generatedLoot;
        }
        if (state.m_60713_(Blocks.f_50250_) && (block = state.m_60734_()) instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
            boolean nearUranium;
            int radius = (Integer)CommonConfig.POTATO_HARVEST_RADIUS.get();
            if (radius < 1) {
                radius = 1;
            }
            if (nearUranium = this.isNearUranium((Level)level, origin, radius)) {
                double chance = (Double)CommonConfig.POTATO_HARVEST_POISON_CHANCE.get();
                if (context.m_230907_().m_188500_() < chance) {
                    int totalPotatoes = 0;
                    for (int i = generatedLoot.size() - 1; i >= 0; --i) {
                        ItemStack stack = (ItemStack)generatedLoot.get(i);
                        if (stack.m_41720_() != Items.f_42620_) continue;
                        totalPotatoes += stack.m_41613_();
                        generatedLoot.remove(i);
                    }
                    if (totalPotatoes > 0) {
                        generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42675_, totalPotatoes));
                    }
                }
            }
        }
        return generatedLoot;
    }

    private boolean isNearUranium(Level level, BlockPos center, int radius) {
        int r2 = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    double dist2;
                    BlockPos p = center.m_7918_(dx, dy, dz);
                    BlockState s = level.m_8055_(p);
                    if (!s.m_60713_((Block)ModBlocks.URANIUM_BLOCK.get()) && !s.m_60713_((Block)ModBlocks.URANIUM_ORE.get()) && !s.m_60713_((Block)ModBlocks.URANIUM_SOURCE.get()) || !((dist2 = center.m_123331_((Vec3i)p)) <= (double)r2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

