/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.menu;

import com.modernmissions.block.entity.LaunchControllerBlockEntity;
import com.modernmissions.init.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LaunchControllerMenu
extends AbstractContainerMenu {
    private final LaunchControllerBlockEntity blockEntity;
    private final ContainerData data;

    public LaunchControllerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(buf.m_130135_()));
    }

    public LaunchControllerMenu(int containerId, Inventory playerInventory, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.LAUNCH_CONTROLLER.get(), containerId);
        LaunchControllerBlockEntity controller;
        if (!(blockEntity instanceof LaunchControllerBlockEntity)) {
            throw new IllegalStateException("Block entity is not a Launch Controller!");
        }
        this.blockEntity = controller = (LaunchControllerBlockEntity)blockEntity;
        this.data = new SimpleContainerData(4){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> controller.getTargetX();
                    case 1 -> controller.getTargetZ();
                    case 2 -> {
                        if (controller.isArmed()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 3 -> controller.getCooldownTicks();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
            }
        };
        this.m_38884_(this.data);
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_58904_() != null && player.m_20275_((double)this.blockEntity.m_58899_().m_123341_() + 0.5, (double)this.blockEntity.m_58899_().m_123342_() + 0.5, (double)this.blockEntity.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public LaunchControllerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getTargetX() {
        return this.data.m_6413_(0);
    }

    public int getTargetZ() {
        return this.data.m_6413_(1);
    }

    public boolean isArmed() {
        return this.data.m_6413_(2) == 1;
    }

    public int getCooldownTicks() {
        return this.data.m_6413_(3);
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }
}

