/*
 * Decompiled with CFR 0.152.
 */
package com.modernmissions.mixin;

import com.modernmissions.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Shadow
    int cookingProgress;
    @Shadow
    int cookingTotalTime;

    @Inject(method={"getTotalCookTime"}, at={@At(value="RETURN")}, cancellable=true)
    private static void modifyCookTime(Level level, RecipeType<? extends AbstractCookingRecipe> recipeType, Container container, CallbackInfoReturnable<Integer> cir) {
        int originalTime = (Integer)cir.getReturnValue();
        double mult = Math.max(1.0, (Double)CommonConfig.FURNACE_COOK_TIME_MULTIPLIER.get());
        int adjusted = (int)Math.max(1L, Math.round((double)originalTime * mult));
        cir.setReturnValue((Object)adjusted);
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void onServerTick(Level level, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity furnace, CallbackInfo ci) {
        if (level.m_46467_() % 20L == 0L) {
            // empty if block
        }
    }
}

