/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.ExplosionOverhaul;
import com.vinlanx.explosionoverhaul.PacketHandler;
import com.vinlanx.explosionoverhaul.ScanLoadPromptPacket;
import com.vinlanx.explosionoverhaul.ScanProgressPacket;
import com.vinlanx.explosionoverhaul.ScanPromptPacket;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class BlockIndexManager {
    private static final Map<ResourceKey<Level>, ConcurrentHashMap<Long, Set<Long>>> indexByDimension = new ConcurrentHashMap<ResourceKey<Level>, ConcurrentHashMap<Long, Set<Long>>>();
    private static final ConcurrentLinkedQueue<ScanTask> chunkScanQueue = new ConcurrentLinkedQueue();
    private static final Map<ResourceKey<Level>, Set<Long>> pendingChunkKeys = new ConcurrentHashMap<ResourceKey<Level>, Set<Long>>();
    public static volatile boolean ENABLED = true;
    private static final boolean SCAN_ONLY_ON_START = true;
    private static volatile boolean INITIAL_SCAN_ENQUEUED = false;
    private static volatile int totalChunksToScan = 0;
    private static volatile int chunksScanned = 0;
    private static volatile boolean scanningComplete = false;
    private static volatile int lampsFound = 0;
    private static volatile int dripstonesFound = 0;
    private static volatile int glassBlocksFound = 0;
    private static volatile ResourceKey<Level> lastScannedDimension = null;
    private static volatile boolean waitingForUserInput = false;
    private static volatile ServerLevel pendingScanLevel = null;
    private static volatile ResourceKey<Level> currentScannedWorld = null;
    private static volatile boolean isSingleplayer = false;
    private static volatile boolean serverScanPromptShown = false;
    private static volatile boolean serverScanDecisionMade = false;
    private static volatile boolean isRescanMode = false;
    private static volatile ServerPlayer rescanRequestingPlayer = null;
    private static volatile boolean userDeclinedScan = false;
    private static volatile boolean waitingForLoadDecision = false;
    private static volatile boolean hasSaveFile = false;
    private static volatile String currentWorldId = null;
    private static final Set<String> REINFORCED_GLASS_BLACKLIST = Set.of("securitycraft:reinforced_white_stained_glass", "securitycraft:reinforced_orange_stained_glass", "securitycraft:reinforced_magenta_stained_glass", "securitycraft:reinforced_light_blue_stained_glass", "securitycraft:reinforced_yellow_stained_glass", "securitycraft:reinforced_lime_stained_glass", "securitycraft:reinforced_pink_stained_glass", "securitycraft:reinforced_gray_stained_glass", "securitycraft:reinforced_light_gray_stained_glass", "securitycraft:reinforced_cyan_stained_glass", "securitycraft:reinforced_purple_stained_glass", "securitycraft:reinforced_blue_stained_glass", "securitycraft:reinforced_brown_stained_glass", "securitycraft:reinforced_green_stained_glass", "securitycraft:reinforced_red_stained_glass", "securitycraft:reinforced_black_stained_glass", "securitycraft:reinforced_white_stained_glass_pane", "securitycraft:reinforced_orange_stained_glass_pane", "securitycraft:reinforced_magenta_stained_glass_pane", "securitycraft:reinforced_light_blue_stained_glass_pane", "securitycraft:reinforced_yellow_stained_glass_pane", "securitycraft:reinforced_lime_stained_glass_pane", "securitycraft:reinforced_pink_stained_glass_pane", "securitycraft:reinforced_gray_stained_glass_pane", "securitycraft:reinforced_light_gray_stained_glass_pane", "securitycraft:reinforced_cyan_stained_glass_pane", "securitycraft:reinforced_purple_stained_glass_pane", "securitycraft:reinforced_blue_stained_glass_pane", "securitycraft:reinforced_brown_stained_glass_pane", "securitycraft:reinforced_green_stained_glass_pane", "securitycraft:reinforced_red_stained_glass_pane", "securitycraft:reinforced_black_stained_glass_pane", "securitycraft:reinforced_glass", "securitycraft:reinforced_glass_pane", "create_tank_defenses:titanium_morning_reinforced_blast_glass", "mofus_better_end_:reinforced_glass", "crusty_chunks:reinforced_glass", "createnuclear:reinforced_glass");

    private static ConcurrentHashMap<Long, Set<Long>> getOrCreateDimIndex(ServerLevel level) {
        ResourceKey dim = level.m_46472_();
        return indexByDimension.computeIfAbsent((ResourceKey<Level>)dim, k -> new ConcurrentHashMap());
    }

    private static Set<Long> getOrCreatePendingSet(ServerLevel level) {
        ResourceKey dim = level.m_46472_();
        return pendingChunkKeys.computeIfAbsent((ResourceKey<Level>)dim, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    private static long chunkKey(ChunkPos cp) {
        return (long)cp.f_45578_ & 0xFFFFFFFFL | ((long)cp.f_45579_ & 0xFFFFFFFFL) << 32;
    }

    private static long packPos(BlockPos pos) {
        return pos.m_121878_();
    }

    private static BlockPos unpackPos(long packed) {
        return BlockPos.m_122022_((long)packed);
    }

    public static int getTotalChunksToScan() {
        return totalChunksToScan;
    }

    public static int getChunksScanned() {
        return chunksScanned;
    }

    public static float getScanProgress() {
        if (totalChunksToScan == 0) {
            return 1.0f;
        }
        return Math.min(1.0f, (float)chunksScanned / (float)totalChunksToScan);
    }

    public static boolean isScanningComplete() {
        return scanningComplete;
    }

    public static int getLampsFound() {
        return lampsFound;
    }

    public static int getDripstonesFound() {
        return dripstonesFound;
    }

    public static int getGlassBlocksFound() {
        return glassBlocksFound;
    }

    private static void clearScanDataSilent() {
        indexByDimension.clear();
        chunkScanQueue.clear();
        pendingChunkKeys.clear();
        totalChunksToScan = 0;
        chunksScanned = 0;
        scanningComplete = false;
        currentScannedWorld = null;
        lastScannedDimension = null;
        lampsFound = 0;
        dripstonesFound = 0;
        glassBlocksFound = 0;
        ExplosionOverhaul.LOGGER.debug("BlockIndexManager: cleared scan data silently");
    }

    private static void clearScanData() {
        BlockIndexManager.clearScanDataSilent();
        BlockIndexManager.sendProgressUpdate();
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: cleared all scan data for world switch");
    }

    private static void clearAndSaveData() {
        if (!indexByDimension.isEmpty() && scanningComplete) {
            try {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    BlockIndexManager.saveIndexData(server);
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: saved data before clearing");
                }
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to save data before clearing: {}", (Object)e.getMessage());
            }
        }
        BlockIndexManager.clearScanData();
    }

    private static void startSingleplayerScan(ServerLevel level) {
        if (currentScannedWorld != null && currentScannedWorld.equals((Object)level.m_46472_())) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: already scanning world {}, skipping", (Object)level.m_46472_().m_135782_());
            return;
        }
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: starting singleplayer scan for world: {}", (Object)level.m_46472_().m_135782_());
        BlockIndexManager.clearScanDataSilent();
        currentScannedWorld = level.m_46472_();
        BlockIndexManager.scanSingleWorld(level);
    }

    private static void startServerScan(MinecraftServer server) {
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: starting server-wide scan for all dimensions");
        BlockIndexManager.clearScanDataSilent();
        BlockIndexManager.scanExistingChunksOnServer(server);
    }

    private static void scanSingleWorld(ServerLevel level) {
        try {
            HashSet existingChunks;
            block22: {
                chunksScanned = 0;
                scanningComplete = false;
                lastScannedDimension = level.m_46472_();
                lampsFound = 0;
                dripstonesFound = 0;
                glassBlocksFound = 0;
                String dimensionName = level.m_46472_().m_135782_().toString();
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: scanning existing chunks in world: {}", (Object)dimensionName);
                existingChunks = new HashSet();
                ServerChunkCache chunkSource = level.m_7726_();
                try {
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: scanning for all existing chunks...");
                    MinecraftServer server = level.m_7654_();
                    String dimPath = level.m_46472_().m_135782_().m_135815_();
                    Path worldPath = server.m_129843_(LevelResource.f_78182_);
                    Path regionPath = "overworld".equals(dimPath) ? worldPath.resolve("region") : ("the_nether".equals(dimPath) ? worldPath.resolve("DIM-1").resolve("region") : ("the_end".equals(dimPath) ? worldPath.resolve("DIM1").resolve("region") : worldPath.resolve("dimensions").resolve(level.m_46472_().m_135782_().m_135827_()).resolve(level.m_46472_().m_135782_().m_135815_()).resolve("region")));
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: scanning region files in: {}", (Object)regionPath);
                    if (Files.exists(regionPath, new LinkOption[0])) {
                        try (Stream<Path> regionFiles = Files.list(regionPath);){
                            List<Path> mcaFiles = regionFiles.filter(path -> path.toString().endsWith(".mca")).collect(Collectors.toList());
                            ExplosionOverhaul.LOGGER.info("BlockIndexManager: found {} .mca files in region directory", (Object)mcaFiles.size());
                            mcaFiles.forEach(regionFile -> {
                                block7: {
                                    try {
                                        int chunksInThisRegion;
                                        int regionZ;
                                        int regionX;
                                        block8: {
                                            String[] parts;
                                            String fileName = regionFile.getFileName().toString();
                                            if (!fileName.startsWith("r.") || !fileName.endsWith(".mca") || (parts = fileName.substring(2, fileName.length() - 4).split("\\.")).length != 2) break block7;
                                            regionX = Integer.parseInt(parts[0]);
                                            regionZ = Integer.parseInt(parts[1]);
                                            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: processing region {}, {} ({})", new Object[]{regionX, regionZ, fileName});
                                            chunksInThisRegion = 0;
                                            try {
                                                byte[] header = Files.readAllBytes(regionFile);
                                                if (header.length < 4096) break block8;
                                                for (int i = 0; i < 1024; ++i) {
                                                    int chunkOffset;
                                                    int offset = i * 4;
                                                    if (offset + 3 >= header.length || (chunkOffset = (header[offset] & 0xFF) << 16 | (header[offset + 1] & 0xFF) << 8 | header[offset + 2] & 0xFF) <= 0) continue;
                                                    int cx = i % 32;
                                                    int cz = i / 32;
                                                    int chunkX = regionX * 32 + cx;
                                                    int chunkZ = regionZ * 32 + cz;
                                                    ChunkPos cp = new ChunkPos(chunkX, chunkZ);
                                                    existingChunks.add(cp);
                                                    ++chunksInThisRegion;
                                                }
                                            }
                                            catch (Exception readEx) {
                                                ExplosionOverhaul.LOGGER.warn("BlockIndexManager: failed to read region file {}: {}", (Object)fileName, (Object)readEx.getMessage());
                                                for (int cx = 0; cx < 32; ++cx) {
                                                    for (int cz = 0; cz < 32; ++cz) {
                                                        int chunkX = regionX * 32 + cx;
                                                        int chunkZ = regionZ * 32 + cz;
                                                        ChunkPos cp = new ChunkPos(chunkX, chunkZ);
                                                        existingChunks.add(cp);
                                                        ++chunksInThisRegion;
                                                    }
                                                }
                                            }
                                        }
                                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: region {},{} - found {} existing chunks (read from .mca header)", new Object[]{regionX, regionZ, chunksInThisRegion});
                                    }
                                    catch (Exception e) {
                                        ExplosionOverhaul.LOGGER.warn("BlockIndexManager: failed to parse region file {}: {}", (Object)regionFile.getFileName(), (Object)e.getMessage());
                                    }
                                }
                            });
                        }
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: scanned region files and found {} existing chunks", (Object)existingChunks.size());
                    } else {
                        ExplosionOverhaul.LOGGER.warn("BlockIndexManager: region directory not found: {}", (Object)regionPath);
                    }
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: found {} total existing chunks in world", (Object)existingChunks.size());
                }
                catch (Exception e) {
                    ExplosionOverhaul.LOGGER.error("BlockIndexManager: failed to scan world storage: {}", (Object)e.getMessage());
                    e.printStackTrace();
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: using fallback - estimate chunks from .mca files");
                    try {
                        String dimPath = level.m_46472_().m_135782_().m_135815_();
                        MinecraftServer server = level.m_7654_();
                        Path worldPath = server.m_129843_(LevelResource.f_78182_);
                        Path regionPath = "overworld".equals(dimPath) ? worldPath.resolve("region") : ("the_nether".equals(dimPath) ? worldPath.resolve("DIM-1").resolve("region") : ("the_end".equals(dimPath) ? worldPath.resolve("DIM1").resolve("region") : worldPath.resolve("dimensions").resolve(level.m_46472_().m_135782_().m_135827_()).resolve(level.m_46472_().m_135782_().m_135815_()).resolve("region")));
                        if (!Files.exists(regionPath, new LinkOption[0])) break block22;
                        try (Stream<Path> regionFiles = Files.list(regionPath);){
                            regionFiles.filter(path -> path.toString().endsWith(".mca")).forEach(regionFile -> {
                                String[] parts;
                                String fileName = regionFile.getFileName().toString();
                                if (fileName.startsWith("r.") && fileName.endsWith(".mca") && (parts = fileName.substring(2, fileName.length() - 4).split("\\.")).length == 2) {
                                    int regionX = Integer.parseInt(parts[0]);
                                    int regionZ = Integer.parseInt(parts[1]);
                                    for (int cx = 0; cx < 32; ++cx) {
                                        for (int cz = 0; cz < 32; ++cz) {
                                            int chunkX = regionX * 32 + cx;
                                            int chunkZ = regionZ * 32 + cz;
                                            ChunkPos cp = new ChunkPos(chunkX, chunkZ);
                                            existingChunks.add(cp);
                                        }
                                    }
                                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: fallback added ~1024 chunks from region {},{}", (Object)regionX, (Object)regionZ);
                                }
                            });
                        }
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: fallback found {} estimated chunks", (Object)existingChunks.size());
                    }
                    catch (Exception fallbackEx) {
                        ExplosionOverhaul.LOGGER.error("BlockIndexManager: fallback also failed: {}", (Object)fallbackEx.getMessage());
                    }
                }
            }
            for (ChunkPos cp : existingChunks) {
                chunkScanQueue.add(new ScanTask((ResourceKey<Level>)level.m_46472_(), cp));
            }
            totalChunksToScan = existingChunks.size();
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: enqueued {} existing chunks for scanning", (Object)totalChunksToScan);
            BlockIndexManager.sendProgressUpdate();
        }
        catch (Exception ex) {
            ExplosionOverhaul.LOGGER.warn("BlockIndexManager: failed to start singleplayer scan: {}", (Object)ex.toString());
        }
    }

    private static void sendProgressUpdate() {
        try {
            ScanProgressPacket packet = new ScanProgressPacket(totalChunksToScan, chunksScanned, scanningComplete, lampsFound, dripstonesFound, glassBlocksFound);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    if (!player.m_20310_(2)) continue;
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                }
            }
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.warn("Failed to send scan progress update: {}", (Object)e.getMessage());
        }
    }

    private static void sendScanPromptPacket(ServerPlayer player) {
        try {
            ScanPromptPacket packet = new ScanPromptPacket(true);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            ExplosionOverhaul.LOGGER.info("Sent scan prompt to OP player: {}", (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.warn("Failed to send scan prompt: {}", (Object)e.getMessage());
        }
    }

    public static void startManualScan() {
        if (BlockIndexManager.isChunkScanningDisabled()) {
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: manual scan cancelled - chunk scanning is disabled in config");
            BlockIndexManager.cancelManualScan();
            return;
        }
        if (waitingForUserInput && pendingScanLevel != null) {
            waitingForUserInput = false;
            serverScanDecisionMade = true;
            userDeclinedScan = false;
            if (isRescanMode) {
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: clearing data for rescan as user confirmed");
                BlockIndexManager.clearScanDataSilent();
                try {
                    MinecraftServer server = pendingScanLevel.m_7654_();
                    Path saveFile = BlockIndexManager.getSaveFilePath(server);
                    if (Files.exists(saveFile, new LinkOption[0])) {
                        Files.delete(saveFile);
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: deleted old save file for rescan");
                    }
                }
                catch (Exception e) {
                    ExplosionOverhaul.LOGGER.warn("Failed to delete old save file: {}", (Object)e.getMessage());
                }
            }
            if (isSingleplayer || isRescanMode) {
                BlockIndexManager.startSingleplayerScan(pendingScanLevel);
            } else {
                BlockIndexManager.startServerScan(pendingScanLevel.m_7654_());
            }
            ServerPlayer requestingPlayer = rescanRequestingPlayer;
            pendingScanLevel = null;
            isRescanMode = false;
            rescanRequestingPlayer = null;
            try {
                if (requestingPlayer != null && requestingPlayer.m_6084_()) {
                    ScanPromptPacket packet = new ScanPromptPacket(false);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> requestingPlayer), (Object)packet);
                } else {
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server != null) {
                        for (ServerPlayer player : server.m_6846_().m_11314_()) {
                            if (!player.m_20310_(2)) continue;
                            ScanPromptPacket packet = new ScanPromptPacket(false);
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                        }
                    }
                }
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to hide scan prompt: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void loadExistingData() {
        if (BlockIndexManager.waitingForLoadDecision && BlockIndexManager.pendingScanLevel != null) {
            BlockIndexManager.waitingForLoadDecision = false;
            BlockIndexManager.serverScanDecisionMade = true;
            server = BlockIndexManager.pendingScanLevel.m_7654_();
            loaded = BlockIndexManager.loadIndexData(server);
            if (loaded) {
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: Successfully loaded existing scan data");
                BlockIndexManager.sendProgressUpdate();
                try {
                    currentServer = ServerLifecycleHooks.getCurrentServer();
                    if (currentServer == null) ** GOTO lbl24
                    for (ServerPlayer serverPlayer : currentServer.m_6846_().m_11314_()) {
                        if (!serverPlayer.m_20310_(2)) continue;
                        packet = new ScanLoadPromptPacket(false);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with((Supplier<ServerPlayer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadExistingData$10(net.minecraft.server.level.ServerPlayer ), ()Lnet/minecraft/server/level/ServerPlayer;)((ServerPlayer)serverPlayer)), (Object)packet);
                        ExplosionOverhaul.LOGGER.debug("Hidden load prompt for OP: {}", (Object)serverPlayer.m_7755_().getString());
                    }
                }
                catch (Exception e) {
                    ExplosionOverhaul.LOGGER.warn("Failed to hide load prompt: {}", (Object)e.getMessage());
                }
            } else {
                ExplosionOverhaul.LOGGER.warn("BlockIndexManager: Failed to load existing data, falling back to new scan");
                BlockIndexManager.startNewScan();
            }
lbl24:
            // 4 sources

            BlockIndexManager.pendingScanLevel = null;
        }
    }

    public static void startNewScan() {
        if (waitingForLoadDecision && pendingScanLevel != null) {
            waitingForLoadDecision = false;
            serverScanDecisionMade = true;
            userDeclinedScan = false;
            try {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                        if (!serverPlayer.m_20310_(2)) continue;
                        ScanLoadPromptPacket hideLoadPacket = new ScanLoadPromptPacket(false);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)hideLoadPacket);
                        ScanPromptPacket showScanPacket = new ScanPromptPacket(true);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)showScanPacket);
                        ExplosionOverhaul.LOGGER.debug("Switched prompts for OP: {}", (Object)serverPlayer.m_7755_().getString());
                    }
                }
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to switch prompts: {}", (Object)e.getMessage());
            }
            waitingForUserInput = true;
            serverScanDecisionMade = false;
        }
    }

    public static void cancelManualScan() {
        if (waitingForUserInput) {
            waitingForUserInput = false;
            serverScanDecisionMade = true;
            userDeclinedScan = true;
            pendingScanLevel = null;
            ServerPlayer requestingPlayer = rescanRequestingPlayer;
            isRescanMode = false;
            rescanRequestingPlayer = null;
            chunkScanQueue.clear();
            totalChunksToScan = 0;
            chunksScanned = 0;
            scanningComplete = false;
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: manual scan cancelled by user - cleared scan queue");
            try {
                if (requestingPlayer != null && requestingPlayer.m_6084_()) {
                    ScanPromptPacket packet = new ScanPromptPacket(false);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> requestingPlayer), (Object)packet);
                } else {
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server != null) {
                        for (ServerPlayer player : server.m_6846_().m_11314_()) {
                            if (!player.m_20310_(2)) continue;
                            ScanPromptPacket packet = new ScanPromptPacket(false);
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                        }
                    }
                }
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to hide scan prompt: {}", (Object)e.getMessage());
            }
        }
    }

    public static void resetScanState() {
        waitingForUserInput = false;
        waitingForLoadDecision = false;
        pendingScanLevel = null;
        serverScanPromptShown = false;
        serverScanDecisionMade = false;
        isRescanMode = false;
        rescanRequestingPlayer = null;
        userDeclinedScan = false;
        hasSaveFile = false;
        INITIAL_SCAN_ENQUEUED = false;
        BlockIndexManager.clearAndSaveData();
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: scan state reset by command");
    }

    public static void forceServerScan(MinecraftServer server) {
        BlockIndexManager.resetScanState();
        BlockIndexManager.startServerScan(server);
    }

    public static void forceSingleplayerScan(ServerLevel level) {
        BlockIndexManager.resetScanState();
        BlockIndexManager.startSingleplayerScan(level);
    }

    public static void showRescanPrompt(ServerPlayer player) {
        isRescanMode = true;
        waitingForUserInput = true;
        pendingScanLevel = player.m_284548_();
        rescanRequestingPlayer = player;
        serverScanPromptShown = true;
        serverScanDecisionMade = false;
        try {
            ScanPromptPacket packet = new ScanPromptPacket(true);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: showing rescan prompt to player: {}", (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.warn("Failed to send rescan prompt: {}", (Object)e.getMessage());
        }
    }

    private static void sendScanPromptPacket(boolean show) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    if (!player.m_20310_(2)) continue;
                    ScanPromptPacket packet = new ScanPromptPacket(show);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                    if (!show) continue;
                    ExplosionOverhaul.LOGGER.debug("Sent scan prompt to OP: {}", (Object)player.m_7755_().getString());
                }
            }
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.warn("Failed to send scan prompt packet: {}", (Object)e.getMessage());
        }
    }

    private static boolean isGlassBlock(BlockState state) {
        try {
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString().toLowerCase();
            if (REINFORCED_GLASS_BLACKLIST.contains(blockName)) {
                return false;
            }
            return blockName.contains("glass");
        }
        catch (Exception e) {
            return state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_152498_);
        }
    }

    public static boolean isReinforcedGlass(BlockState state) {
        try {
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString().toLowerCase();
            return REINFORCED_GLASS_BLACKLIST.contains(blockName);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String generateWorldId(MinecraftServer server) {
        try {
            Path worldPath = server.m_129843_(LevelResource.f_78182_);
            String worldName = server.m_129910_().m_5462_();
            String folderName = worldPath.getFileName().toString();
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: World path: {}", (Object)worldPath);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: World name from level.dat: '{}'", (Object)worldName);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Folder name: '{}'", (Object)folderName);
            if (folderName == null || folderName.trim().isEmpty()) {
                folderName = "world";
            }
            if (worldName == null || worldName.trim().isEmpty()) {
                worldName = "Unknown";
            }
            String combined = folderName + "_" + worldName;
            String result = combined.replaceAll("[^a-zA-Z0-9_-]", "_").toLowerCase();
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Generated world ID: '{}'", (Object)result);
            return result;
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.warn("Failed to generate world ID, using fallback: {}", (Object)e.getMessage());
            String fallback = "unknown_world_" + System.currentTimeMillis();
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Using fallback ID: '{}'", (Object)fallback);
            return fallback;
        }
    }

    private static Path getSaveFilePath(MinecraftServer server) {
        String worldId = BlockIndexManager.generateWorldId(server);
        Path configDir = server.m_129843_(LevelResource.f_78182_).getParent().resolve("config").resolve("explosionoverhaul");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: Using config directory: {}", (Object)configDir);
        }
        catch (IOException e) {
            ExplosionOverhaul.LOGGER.error("Failed to create config directory: {}", (Object)e.getMessage());
        }
        Path saveFile = configDir.resolve("block_index_" + worldId + ".json");
        ExplosionOverhaul.LOGGER.debug("BlockIndexManager: Save file path: {}", (Object)saveFile);
        return saveFile;
    }

    public static void saveIndexData(MinecraftServer server) {
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: Attempting to save data...");
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: IndexByDimension size: {}", (Object)indexByDimension.size());
        if (indexByDimension.isEmpty()) {
            ExplosionOverhaul.LOGGER.warn("BlockIndexManager: No data to save - index is empty!");
            return;
        }
        try {
            Path saveFile = BlockIndexManager.getSaveFilePath(server);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Saving to file: {}", (Object)saveFile);
            HashMap saveData = new HashMap();
            int totalBlocks = 0;
            for (Map.Entry<ResourceKey<Level>, ConcurrentHashMap<Long, Set<Long>>> dimEntry : indexByDimension.entrySet()) {
                String dimKey = dimEntry.getKey().m_135782_().toString();
                HashMap<String, Set<Long>> chunkMap = new HashMap<String, Set<Long>>();
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: Processing dimension: {}", (Object)dimKey);
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: Chunks in dimension: {}", (Object)dimEntry.getValue().size());
                for (Map.Entry<Long, Set<Long>> chunkEntry : dimEntry.getValue().entrySet()) {
                    Set<Long> blocks = chunkEntry.getValue();
                    if (blocks.isEmpty()) continue;
                    chunkMap.put(chunkEntry.getKey().toString(), blocks);
                    totalBlocks += blocks.size();
                }
                if (chunkMap.isEmpty()) continue;
                saveData.put(dimKey, chunkMap);
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: Added {} chunks with blocks to save data for dimension {}", (Object)chunkMap.size(), (Object)dimKey);
            }
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Total blocks to save: {}", (Object)totalBlocks);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Dimensions to save: {}", (Object)saveData.size());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(saveData);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: JSON length: {}", (Object)json.length());
            Files.write(saveFile, json.getBytes(), new OpenOption[0]);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Successfully saved index data to {}", (Object)saveFile);
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.error("BlockIndexManager: Failed to save index data: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static boolean loadIndexData(MinecraftServer server) {
        try {
            Type saveDataType;
            Path saveFile = BlockIndexManager.getSaveFilePath(server);
            if (!Files.exists(saveFile, new LinkOption[0])) {
                ExplosionOverhaul.LOGGER.debug("BlockIndexManager: No save file found at {}", (Object)saveFile);
                return false;
            }
            Gson gson = new Gson();
            String json = new String(Files.readAllBytes(saveFile));
            Map saveData = (Map)gson.fromJson(json, saveDataType = new TypeToken<Map<String, Map<String, Set<Long>>>>(){}.getType());
            if (saveData == null || saveData.isEmpty()) {
                ExplosionOverhaul.LOGGER.warn("BlockIndexManager: Save file is empty or corrupted");
                return false;
            }
            indexByDimension.clear();
            for (Map.Entry dimEntry : saveData.entrySet()) {
                try {
                    ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation((String)dimEntry.getKey()));
                    ConcurrentHashMap chunkMap = new ConcurrentHashMap();
                    for (Map.Entry chunkEntry : ((Map)dimEntry.getValue()).entrySet()) {
                        Long chunkKey = Long.parseLong((String)chunkEntry.getKey());
                        Set blockSet = Collections.newSetFromMap(new ConcurrentHashMap());
                        blockSet.addAll((Collection)chunkEntry.getValue());
                        chunkMap.put(chunkKey, blockSet);
                    }
                    indexByDimension.put((ResourceKey<Level>)dimKey, chunkMap);
                }
                catch (Exception e) {
                    ExplosionOverhaul.LOGGER.warn("BlockIndexManager: Failed to load dimension {}: {}", dimEntry.getKey(), (Object)e.getMessage());
                }
            }
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Successfully loaded index data from {}", (Object)saveFile);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Loaded {} dimensions with indexed blocks", (Object)indexByDimension.size());
            scanningComplete = true;
            totalChunksToScan = 0;
            chunksScanned = 0;
            lampsFound = 0;
            dripstonesFound = 0;
            glassBlocksFound = 0;
            return true;
        }
        catch (Exception e) {
            ExplosionOverhaul.LOGGER.error("BlockIndexManager: Failed to load index data: {}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasSaveFile(MinecraftServer server) {
        Path saveFile = BlockIndexManager.getSaveFilePath(server);
        return Files.exists(saveFile, new LinkOption[0]) && Files.isRegularFile(saveFile, new LinkOption[0]);
    }

    private static int getChunksToScanPerTick() {
        return (Integer)Config.COMMON.scan.chunksToScanPerTick.get();
    }

    private static boolean isChunkScanningDisabled() {
        return (Boolean)Config.COMMON.scan.enableBlockIndexing.get() == false;
    }

    private static boolean isScanning() {
        return !chunkScanQueue.isEmpty() && totalChunksToScan > 0 && !scanningComplete;
    }

    public static boolean isRescanMode() {
        return isRescanMode;
    }

    public static void register(ServerLevel level, BlockPos pos, BlockType type) {
        ConcurrentHashMap<Long, Set<Long>> dimIndex = BlockIndexManager.getOrCreateDimIndex(level);
        ChunkPos cp = new ChunkPos(pos);
        long ck = BlockIndexManager.chunkKey(cp);
        dimIndex.computeIfAbsent(ck, k -> Collections.newSetFromMap(new ConcurrentHashMap())).add(BlockIndexManager.packPos(pos));
    }

    public static void unregister(ServerLevel level, BlockPos pos, BlockType type) {
        ChunkPos cp;
        long ck;
        ConcurrentHashMap<Long, Set<Long>> dimIndex = BlockIndexManager.getOrCreateDimIndex(level);
        Set<Long> set = dimIndex.get(ck = BlockIndexManager.chunkKey(cp = new ChunkPos(pos)));
        if (set != null) {
            set.remove(BlockIndexManager.packPos(pos));
            if (set.isEmpty()) {
                dimIndex.remove(ck);
            }
        }
    }

    public static void scanChunk(ServerLevel level, ChunkPos cp) {
        long ck;
        ConcurrentHashMap<Long, Set<Long>> dimIndex = BlockIndexManager.getOrCreateDimIndex(level);
        if (dimIndex.containsKey(ck = BlockIndexManager.chunkKey(cp))) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: chunk {} {} already scanned, skipping", (Object)cp.f_45578_, (Object)cp.f_45579_);
            return;
        }
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        int chunkLamps = 0;
        int chunkDripstones = 0;
        int chunkGlass = 0;
        for (int lx = 0; lx < 16; ++lx) {
            for (int lz = 0; lz < 16; ++lz) {
                for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                    BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                    if (!level.m_46749_(pos)) continue;
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60713_(Blocks.f_50261_)) {
                        set.add(BlockIndexManager.packPos(pos));
                        ++chunkLamps;
                        continue;
                    }
                    if (state.m_60713_(Blocks.f_152588_)) {
                        set.add(BlockIndexManager.packPos(pos));
                        ++chunkDripstones;
                        continue;
                    }
                    if (!BlockIndexManager.isGlassBlock(state)) continue;
                    set.add(BlockIndexManager.packPos(pos));
                    ++chunkGlass;
                }
            }
        }
        lampsFound += chunkLamps;
        dripstonesFound += chunkDripstones;
        glassBlocksFound += chunkGlass;
        if (!set.isEmpty()) {
            dimIndex.put(ck, set);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Found {} blocks in chunk {} {}: {}", new Object[]{set.size(), cp.f_45578_, cp.f_45579_, set.size() > 10 ? set.size() + " blocks" : set});
        } else {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: No blocks found in chunk {} {}", (Object)cp.f_45578_, (Object)cp.f_45579_);
        }
        ExplosionOverhaul.LOGGER.debug("BlockIndexManager: scanned chunk {} {} ({}/{} total)", new Object[]{cp.f_45578_, cp.f_45579_, ++chunksScanned, totalChunksToScan});
        if (chunksScanned >= totalChunksToScan && totalChunksToScan > 0) {
            scanningComplete = true;
            int totalBlocksFound = 0;
            for (Map.Entry<ResourceKey<Level>, ConcurrentHashMap<Long, Set<Long>>> dimEntry : indexByDimension.entrySet()) {
                for (Map.Entry<Long, Set<Long>> chunkEntry : dimEntry.getValue().entrySet()) {
                    totalBlocksFound += chunkEntry.getValue().size();
                }
            }
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: chunk scanning completed! Scanned {}/{} chunks", (Object)chunksScanned, (Object)totalChunksToScan);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: Found {} total blocks across {} dimensions", (Object)totalBlocksFound, (Object)indexByDimension.size());
            try {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: Starting auto-save after scan completion...");
                    BlockIndexManager.saveIndexData(server);
                }
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to auto-save scan data: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        if (chunksScanned % 10 == 0 || scanningComplete) {
            BlockIndexManager.sendProgressUpdate();
        }
    }

    public static void removeChunk(ServerLevel level, ChunkPos cp) {
        ConcurrentHashMap<Long, Set<Long>> dimIndex = BlockIndexManager.getOrCreateDimIndex(level);
        long ck = BlockIndexManager.chunkKey(cp);
        dimIndex.remove(ck);
        Set<Long> pending = BlockIndexManager.getOrCreatePendingSet(level);
        pending.remove(ck);
    }

    public static List<BlockPos> getNearby(ServerLevel level, BlockPos center, int radius, BlockType type) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int minX = center.m_123341_() - radius;
        int maxX = center.m_123341_() + radius;
        int minZ = center.m_123343_() - radius;
        int maxZ = center.m_123343_() + radius;
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        ConcurrentHashMap<Long, Set<Long>> dimIndex = BlockIndexManager.getOrCreateDimIndex(level);
        long r2 = (long)radius * (long)radius;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                long ck = BlockIndexManager.chunkKey(new ChunkPos(cx, cz));
                Set<Long> set = dimIndex.get(ck);
                if (set == null || set.isEmpty()) continue;
                for (long packed : set) {
                    long dz;
                    long dy;
                    BlockPos pos = BlockIndexManager.unpackPos(packed);
                    long dx = pos.m_123341_() - center.m_123341_();
                    if (dx * dx + (dy = (long)(pos.m_123342_() - center.m_123342_())) * dy + (dz = (long)(pos.m_123343_() - center.m_123343_())) * dz > r2) continue;
                    BlockState state = level.m_8055_(pos);
                    if (type == BlockType.LAMP && state.m_60713_(Blocks.f_50261_)) {
                        result.add(pos);
                    }
                    if (type == BlockType.DRIPSTONE && state.m_60713_(Blocks.f_152588_)) {
                        result.add(pos);
                    }
                    if (type != BlockType.GLASS || !BlockIndexManager.isGlassBlock(state)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!ENABLED) {
            return;
        }
        if (BlockIndexManager.isChunkScanningDisabled()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (userDeclinedScan) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: ignoring chunk load - user declined scanning");
            return;
        }
        if (!isSingleplayer && !serverScanDecisionMade) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: ignoring chunk load - no server scan decision yet");
            return;
        }
        if (INITIAL_SCAN_ENQUEUED) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: ignoring new chunk load {} {} (scan only on start mode, scanning complete: {})", new Object[]{event.getChunk().m_7697_().f_45578_, event.getChunk().m_7697_().f_45579_, scanningComplete});
            return;
        }
        ResourceKey chunkDimension = level.m_46472_();
        if (lastScannedDimension != null && !lastScannedDimension.equals((Object)chunkDimension)) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: ignoring chunk {} {} in different dimension {} (last scanned: {})", new Object[]{event.getChunk().m_7697_().f_45578_, event.getChunk().m_7697_().f_45579_, chunkDimension.m_135782_(), lastScannedDimension.m_135782_()});
            return;
        }
        if (scanningComplete) {
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: ignoring chunk {} {} - scanning already complete", (Object)event.getChunk().m_7697_().f_45578_, (Object)event.getChunk().m_7697_().f_45579_);
            return;
        }
        long ck = BlockIndexManager.chunkKey(event.getChunk().m_7697_());
        Set<Long> pending = BlockIndexManager.getOrCreatePendingSet(level);
        if (pending.add(ck)) {
            chunkScanQueue.add(new ScanTask((ResourceKey<Level>)level.m_46472_(), event.getChunk().m_7697_()));
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: enqueued chunk {} {} for scanning (total: {} scanned, {} to scan)", new Object[]{event.getChunk().m_7697_().f_45578_, event.getChunk().m_7697_().f_45579_, chunksScanned, totalChunksToScan});
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!ENABLED) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockIndexManager.removeChunk(level, event.getChunk().m_7697_());
        chunkScanQueue.removeIf(t -> t.dim().equals((Object)level.m_46472_()) && t.chunkPos().equals((Object)event.getChunk().m_7697_()));
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!ENABLED) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50261_)) {
            BlockIndexManager.register(level, pos, BlockType.LAMP);
        } else if (state.m_60713_(Blocks.f_152588_)) {
            BlockIndexManager.register(level, pos, BlockType.DRIPSTONE);
        } else if (BlockIndexManager.isGlassBlock(state)) {
            BlockIndexManager.register(level, pos, BlockType.GLASS);
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!ENABLED) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        BlockIndexManager.unregister(level, pos, BlockType.LAMP);
        BlockIndexManager.unregister(level, pos, BlockType.DRIPSTONE);
        BlockIndexManager.unregister(level, pos, BlockType.GLASS);
    }

    @SubscribeEvent
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ENABLED) {
            return;
        }
        if (BlockIndexManager.isChunkScanningDisabled()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_20310_(2)) {
            ServerLevel level = player2.m_284548_();
            MinecraftServer server = level.m_7654_();
            boolean saveFileExists = BlockIndexManager.hasSaveFile(server);
            if (isSingleplayer) {
                if (!(waitingForUserInput || waitingForLoadDecision || scanningComplete)) {
                    chunkScanQueue.clear();
                    totalChunksToScan = 0;
                    chunksScanned = 0;
                }
                if (!(waitingForUserInput || waitingForLoadDecision || BlockIndexManager.isScanning() || scanningComplete || userDeclinedScan)) {
                    pendingScanLevel = level;
                    if (saveFileExists) {
                        waitingForLoadDecision = true;
                        hasSaveFile = true;
                        try {
                            ScanLoadPromptPacket packet = new ScanLoadPromptPacket(true);
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
                            ExplosionOverhaul.LOGGER.info("BlockIndexManager: showing load prompt for existing save file in world: {}", (Object)level.m_46472_().m_135782_());
                        }
                        catch (Exception e) {
                            ExplosionOverhaul.LOGGER.warn("Failed to send load prompt: {}", (Object)e.getMessage());
                        }
                    } else {
                        waitingForUserInput = true;
                        hasSaveFile = false;
                        BlockIndexManager.sendScanPromptPacket(true);
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: waiting for user input to start scan in world: {}", (Object)level.m_46472_().m_135782_());
                    }
                } else if (BlockIndexManager.isScanning() || !chunkScanQueue.isEmpty() && totalChunksToScan > 0) {
                    try {
                        ScanProgressPacket packet = new ScanProgressPacket(totalChunksToScan, chunksScanned, scanningComplete, lampsFound, dripstonesFound, glassBlocksFound);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
                        ExplosionOverhaul.LOGGER.debug("Sent scan progress to rejoining OP player: {}/{} chunks", (Object)chunksScanned, (Object)totalChunksToScan);
                    }
                    catch (Exception e) {
                        ExplosionOverhaul.LOGGER.warn("Failed to send scan progress to rejoining OP player: {}", (Object)e.getMessage());
                    }
                }
            } else if (!serverScanDecisionMade && !userDeclinedScan) {
                if (!serverScanPromptShown) {
                    serverScanPromptShown = true;
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: first OP joined server, waiting for scan decision from: {}", (Object)player2.m_7755_().getString());
                } else {
                    ExplosionOverhaul.LOGGER.info("BlockIndexManager: additional OP joined server, showing pending decision to: {}", (Object)player2.m_7755_().getString());
                }
                pendingScanLevel = level;
                if (saveFileExists) {
                    waitingForLoadDecision = true;
                    hasSaveFile = true;
                    try {
                        ScanLoadPromptPacket packet = new ScanLoadPromptPacket(true);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: showing load prompt for existing save file to OP: {}", (Object)player2.m_7755_().getString());
                    }
                    catch (Exception e) {
                        ExplosionOverhaul.LOGGER.warn("Failed to send load prompt: {}", (Object)e.getMessage());
                    }
                } else {
                    waitingForUserInput = true;
                    hasSaveFile = false;
                    try {
                        ScanPromptPacket packet = new ScanPromptPacket(true);
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
                        ExplosionOverhaul.LOGGER.info("BlockIndexManager: showing scan prompt to OP: {}", (Object)player2.m_7755_().getString());
                    }
                    catch (Exception e) {
                        ExplosionOverhaul.LOGGER.warn("Failed to send scan prompt: {}", (Object)e.getMessage());
                    }
                }
            } else if (totalChunksToScan > 0 && !scanningComplete) {
                try {
                    ScanProgressPacket packet = new ScanProgressPacket(totalChunksToScan, chunksScanned, scanningComplete, lampsFound, dripstonesFound, glassBlocksFound);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
                    ExplosionOverhaul.LOGGER.debug("Sent scan progress to joining OP player: {}/{} chunks", (Object)chunksScanned, (Object)totalChunksToScan);
                }
                catch (Exception e) {
                    ExplosionOverhaul.LOGGER.warn("Failed to send scan progress to joining OP player: {}", (Object)e.getMessage());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ScanTask task;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (BlockIndexManager.isChunkScanningDisabled()) {
            return;
        }
        if (userDeclinedScan) {
            return;
        }
        if (!isSingleplayer && !serverScanDecisionMade) {
            return;
        }
        int chunksToScan = BlockIndexManager.getChunksToScanPerTick();
        for (int processed = 0; processed < chunksToScan && (task = chunkScanQueue.poll()) != null; ++processed) {
            MinecraftServer server = event.getServer();
            ServerLevel level = server.m_129880_(task.dim());
            if (level == null) continue;
            ExplosionOverhaul.LOGGER.debug("BlockIndexManager: scanning chunk {} {} (task)", (Object)task.chunkPos().f_45578_, (Object)task.chunkPos().f_45579_);
            try {
                BlockIndexManager.scanChunk(level, task.chunkPos());
                ExplosionOverhaul.LOGGER.debug("BlockIndexManager: finished scanning chunk {} {}", (Object)task.chunkPos().f_45578_, (Object)task.chunkPos().f_45579_);
                long ck = BlockIndexManager.chunkKey(task.chunkPos());
                Set<Long> pending = BlockIndexManager.getOrCreatePendingSet(level);
                pending.remove(ck);
                continue;
            }
            catch (Exception ex) {
                ExplosionOverhaul.LOGGER.warn("BlockIndexManager: error scanning chunk {} {}: {}", new Object[]{task.chunkPos().f_45578_, task.chunkPos().f_45579_, ex.toString()});
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!ENABLED) {
            return;
        }
        if (BlockIndexManager.isChunkScanningDisabled()) {
            return;
        }
        if (INITIAL_SCAN_ENQUEUED) {
            return;
        }
        MinecraftServer server = event.getServer();
        isSingleplayer = server.m_129792_();
        if (!isSingleplayer) {
            userDeclinedScan = false;
        }
        serverScanPromptShown = false;
        serverScanDecisionMade = false;
        if (isSingleplayer) {
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: singleplayer detected, will scan on world entry");
            INITIAL_SCAN_ENQUEUED = true;
            return;
        }
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: multiplayer server detected, will wait for user decision before scanning");
        INITIAL_SCAN_ENQUEUED = true;
    }

    private static void scanExistingChunksOnServer(MinecraftServer server) {
        try {
            chunksScanned = 0;
            scanningComplete = false;
            for (ServerLevel level : server.m_129785_()) {
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = level;
                String dimensionName = serverLevel.m_46472_().m_135782_().toString();
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: scanning existing chunks in dimension: {}", (Object)dimensionName);
                BlockIndexManager.scanSingleWorld(serverLevel);
            }
            totalChunksToScan = chunkScanQueue.size();
            INITIAL_SCAN_ENQUEUED = true;
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: enqueued {} existing chunks for scanning", (Object)totalChunksToScan);
            BlockIndexManager.sendProgressUpdate();
        }
        catch (Exception ex) {
            ExplosionOverhaul.LOGGER.warn("BlockIndexManager: failed to enqueue existing chunk scans: {}", (Object)ex.toString());
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        if (!ENABLED) {
            return;
        }
        if (!indexByDimension.isEmpty() && scanningComplete) {
            try {
                BlockIndexManager.saveIndexData(event.getServer());
                ExplosionOverhaul.LOGGER.info("BlockIndexManager: saved data before server shutdown");
            }
            catch (Exception e) {
                ExplosionOverhaul.LOGGER.warn("Failed to save data on server stop: {}", (Object)e.getMessage());
            }
        }
        userDeclinedScan = false;
        serverScanPromptShown = false;
        serverScanDecisionMade = false;
        waitingForUserInput = false;
        waitingForLoadDecision = false;
        pendingScanLevel = null;
        isRescanMode = false;
        rescanRequestingPlayer = null;
        hasSaveFile = false;
        currentWorldId = null;
        INITIAL_SCAN_ENQUEUED = false;
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: reset scan state on server stop");
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!ENABLED) {
            return;
        }
        if (!isSingleplayer) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        waitingForUserInput = false;
        waitingForLoadDecision = false;
        pendingScanLevel = null;
        userDeclinedScan = false;
        hasSaveFile = false;
        BlockIndexManager.clearAndSaveData();
        ExplosionOverhaul.LOGGER.info("BlockIndexManager: saved and cleared scan data on singleplayer logout");
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!ENABLED) {
            return;
        }
        if (!isSingleplayer) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!userDeclinedScan && player2.m_20310_(2)) {
            ServerLevel newLevel = player2.m_284548_();
            BlockIndexManager.startSingleplayerScan(newLevel);
            ExplosionOverhaul.LOGGER.info("BlockIndexManager: starting scan for new dimension: {}", (Object)newLevel.m_46472_().m_135782_());
        }
    }

    private static /* synthetic */ ServerPlayer lambda$loadExistingData$10(ServerPlayer serverPlayer) {
        return serverPlayer;
    }

    private record ScanTask(ResourceKey<Level> dim, ChunkPos chunkPos) {
    }

    public static enum BlockType {
        LAMP,
        DRIPSTONE,
        GLASS;

    }
}

