/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.client.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CameraShakePacket {
    private final float intensity;
    private final int durationTicks;
    private final float pushIntensity;
    private final int delayTicks;

    public CameraShakePacket(float intensity, int durationTicks, float pushIntensity, int delayTicks) {
        this.intensity = intensity;
        this.durationTicks = durationTicks;
        this.pushIntensity = pushIntensity;
        this.delayTicks = delayTicks;
    }

    public static void encode(CameraShakePacket msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.intensity);
        buf.writeInt(msg.durationTicks);
        buf.writeFloat(msg.pushIntensity);
        buf.writeInt(msg.delayTicks);
    }

    public static CameraShakePacket decode(FriendlyByteBuf buf) {
        return new CameraShakePacket(buf.readFloat(), buf.readInt(), buf.readFloat(), buf.readInt());
    }

    public static void handle(CameraShakePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEffects.triggerDelayedCameraShake(msg.getIntensity(), msg.getDurationTicks(), msg.getPushIntensity(), msg.getDelayTicks())));
        ctx.get().setPacketHandled(true);
    }

    public float getIntensity() {
        return this.intensity;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public float getPushIntensity() {
        return this.pushIntensity;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }
}

