/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vinlanx.explosionoverhaul.ModParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class CustomGlowParticleOptions
implements ParticleOptions {
    public static final Codec<CustomGlowParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("zone").forGetter(CustomGlowParticleOptions::getZone), (App)Codec.FLOAT.fieldOf("power").forGetter(CustomGlowParticleOptions::getPower), (App)Codec.FLOAT.fieldOf("scale").forGetter(CustomGlowParticleOptions::getScale), (App)Codec.INT.fieldOf("animationType").forGetter(CustomGlowParticleOptions::getAnimationType)).apply((Applicative)instance, CustomGlowParticleOptions::new));
    public static final ParticleOptions.Deserializer<CustomGlowParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<CustomGlowParticleOptions>(){

        public CustomGlowParticleOptions fromCommand(ParticleType<CustomGlowParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int zone = reader.readInt();
            reader.expect(' ');
            float power = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int animationType = reader.readInt();
            return new CustomGlowParticleOptions(zone, power, scale, animationType);
        }

        public CustomGlowParticleOptions fromNetwork(ParticleType<CustomGlowParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new CustomGlowParticleOptions(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
        }
    };
    private final int zone;
    private final float power;
    private final float scale;
    private final int animationType;

    public CustomGlowParticleOptions(int zone, float power, float scale, int animationType) {
        this.zone = zone;
        this.power = power;
        this.scale = scale;
        this.animationType = animationType;
    }

    public CustomGlowParticleOptions(int zone, float power, float scale) {
        this(zone, power, scale, 0);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.CUSTOM_GLOW.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.zone);
        buffer.writeFloat(this.power);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.animationType);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f %d", ModParticles.CUSTOM_GLOW.getId(), this.zone, Float.valueOf(this.power), Float.valueOf(this.scale), this.animationType);
    }

    public int getZone() {
        return this.zone;
    }

    public float getPower() {
        return this.power;
    }

    public float getScale() {
        return this.scale;
    }

    public int getAnimationType() {
        return this.animationType;
    }
}

